/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.List;

public class MaskMoveOperator
extends SimpleMCMCOperator {
    private final List<Parameter> masks;
    private final Parameter cutPoint;
    private final int[] selectBefore;
    private final int[] selectAfter;
    private static final boolean DEBUG = false;

    public MaskMoveOperator(List<Parameter> list, Parameter parameter, int[] nArray, int[] nArray2, double d) {
        this.masks = list;
        this.cutPoint = parameter;
        this.selectBefore = nArray;
        this.selectAfter = nArray2;
        this.setWeight(d);
        if (!MaskMoveOperator.checkMaskValues(list, parameter, nArray, nArray2)) {
            throw new IllegalArgumentException("Bad initialization state");
        }
    }

    public static boolean checkMaskValues(List<Parameter> list, Parameter parameter, int[] nArray, int[] nArray2) {
        int n = (int)(parameter.getParameterValue(0) + 0.5);
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray3;
            int[] nArray4;
            boolean bl;
            Parameter parameter2 = list.get(i);
            boolean bl2 = bl = i < n;
            if (bl) {
                nArray4 = nArray;
                nArray3 = nArray2;
            } else {
                nArray4 = nArray2;
                nArray3 = nArray;
            }
            for (int n2 : nArray4) {
                if (parameter2.getParameterValue(n2) == 1.0) continue;
                return false;
            }
            for (int n2 : nArray3) {
                if (parameter2.getParameterValue(n2) == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    private String printMask() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = (int)(this.cutPoint.getParameterValue(0) + 0.5);
        stringBuilder.append("Cut: " + n + "\n");
        for (int i = 0; i < this.masks.size(); ++i) {
            stringBuilder.append(i + 1 + " " + this.masks.get(i).getParameterValue(this.selectBefore[0]) + " " + this.masks.get(i).getParameterValue(this.selectAfter[0]) + "\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public final double doOperation() {
        int[] nArray;
        int[] nArray2;
        Parameter parameter;
        boolean bl;
        double d = 0.0;
        Object var3_2 = null;
        int n = (int)(this.cutPoint.getParameterValue(0) + 0.5);
        if (n == 0) {
            bl = true;
            d -= Math.log(2.0);
        } else if (n == this.masks.size()) {
            bl = false;
            d -= Math.log(2.0);
        } else {
            bl = !(MathUtils.nextDouble() < 0.5);
        }
        Parameter parameter2 = parameter = bl ? this.masks.get(n) : this.masks.get(n - 1);
        if (bl) {
            nArray2 = this.selectBefore;
            nArray = this.selectAfter;
        } else {
            nArray2 = this.selectAfter;
            nArray = this.selectBefore;
        }
        for (int n2 : nArray) {
            parameter.setParameterValueQuietly(n2, 0.0);
        }
        for (int n2 : nArray2) {
            parameter.setParameterValueQuietly(n2, 1.0);
        }
        parameter.fireParameterChangedEvent();
        this.cutPoint.setParameterValue(0, n + (bl ? 1 : -1));
        return d;
    }

    @Override
    public final String getOperatorName() {
        return "maskMove(" + this.cutPoint.getParameterName() + ")";
    }

    public final String getPerformanceSuggestion() {
        return "no performance suggestion";
    }

    public String toString() {
        return this.getOperatorName();
    }
}

