/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.RObjectChooser;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.HelpButton;

public class TextFileChooser {
    private static final String HELP_URL = "index.php?n=Main.TextImportFromFile";
    private JFileChooser fc;
    JDialog actualDialog;
    boolean useExistingCorpus = false;
    final JTextField newNameField = new JTextField();
    String existingCorpus = null;
    private static String mostRecentPath = null;

    public TextFileChooser(JFrame jFrame) {
        this.fc = new JFileChooser();
        this.fc.setFileSelectionMode(2);
        this.fc.setApproveButtonText("Import");
        this.fc.setMultiSelectionEnabled(true);
        this.fc.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                    if (!(propertyChangeEvent.getNewValue() instanceof File)) {
                        return;
                    }
                    File file = (File)propertyChangeEvent.getNewValue();
                    String string = file.getName();
                    TextFileChooser.this.newNameField.setText(Deducer.getUniqueName((String)string));
                }
            }
        });
        this.fc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    String string2;
                    int n;
                    File[] fileArray;
                    File[] fileArray2 = TextFileChooser.this.fc.getSelectedFiles();
                    ArrayList<File> arrayList = new ArrayList<File>();
                    for (int i = 0; i < fileArray2.length; ++i) {
                        if (fileArray2[i].isDirectory()) {
                            fileArray = fileArray2[i].listFiles();
                            if (fileArray == null) continue;
                            for (n = 0; n < fileArray.length; ++n) {
                                if (fileArray[n].isDirectory() || fileArray[n].getName().startsWith(".")) continue;
                                arrayList.add(fileArray[n]);
                            }
                            continue;
                        }
                        arrayList.add(fileArray2[i]);
                    }
                    String string3 = "Corpus(VectorSource(c(\n";
                    fileArray = TextFileChooser.this.fc.getCurrentDirectory().getAbsolutePath();
                    mostRecentPath = (String)fileArray;
                    for (n = 0; n < arrayList.size(); ++n) {
                        string2 = Deducer.addSlashes((String)((File)arrayList.get(n)).getAbsolutePath());
                        string3 = string3 + "paste(readLines('" + string2 + "', warn=F), sep='', collapse='\\n')";
                        if (n != arrayList.size() - 1) {
                            string3 = string3 + ",";
                        }
                        string3 = string3 + "\n";
                    }
                    string3 = string3 + ")))";
                    if (!TextFileChooser.this.useExistingCorpus) {
                        String string4 = TextFileChooser.this.newNameField.getText();
                        boolean bl = string4.equals(Deducer.getUniqueName((String)string4));
                        boolean bl2 = true;
                        if (string4 == null || string4.equals("") || Character.isDigit(string4.charAt(0))) {
                            bl2 = false;
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(null, "You must give the corpus a name.", "Alert", 0);
                        } else if (!bl) {
                            int n2 = JOptionPane.showConfirmDialog(null, "The corpus name \"" + string4 + "\" is already in use." + "\nWould you like to overwrite the existing variable?", "Warning", 0);
                            boolean bl3 = bl2 = n2 == 0;
                        }
                        if (bl2) {
                            Deducer.execute((String)(string4 + " <- " + string3));
                            TextFileChooser.this.actualDialog.dispose();
                        }
                    } else {
                        String string5 = TextFileChooser.this.existingCorpus;
                        string2 = Deducer.getUniqueName((String)"tempCorp");
                        Deducer.execute((String)(string5 + "<- c(" + string5 + ",\n" + string3 + "\n)"));
                        TextFileChooser.this.actualDialog.dispose();
                    }
                } else if (string.equals("CancelSelection")) {
                    TextFileChooser.this.actualDialog.dispose();
                }
            }
        });
        this.actualDialog = new JDialog(jFrame){

            public void setVisible(boolean bl) {
                if (bl) {
                    this.setLocationRelativeTo(this.getParent());
                }
                super.setVisible(bl);
            }
        };
        this.actualDialog.setLayout(new BorderLayout());
        this.actualDialog.add((Component)this.fc, "Center");
        this.actualDialog.add((Component)this.constructExtraOptionsPanel(), "South");
        this.fc.addChoosableFileFilter(new FileFilter(){

            public String getDescription() {
                return "Text files (*.txt *.rtf)";
            }

            public boolean accept(File file) {
                String string = file.getName().toLowerCase();
                return string.endsWith(".txt") || string.endsWith(".rtf") || file.isDirectory();
            }
        });
    }

    public JPanel constructExtraOptionsPanel() {
        final JRadioButton jRadioButton = new JRadioButton("Make New Corpus");
        JRadioButton jRadioButton2 = new JRadioButton("Add to Existing Corpus");
        final RObjectChooser rObjectChooser = new RObjectChooser();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        final JPanel jPanel = new JPanel(new CardLayout());
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                cardLayout.show(jPanel, "make new corpus");
                TextFileChooser.this.useExistingCorpus = false;
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (rObjectChooser.getItemCount() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(null, "You do not yet have any corpuses.", "Alert", 0);
                    jRadioButton.setSelected(true);
                } else {
                    CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                    cardLayout.show(jPanel, "choose existing corpus");
                    TextFileChooser.this.useExistingCorpus = true;
                }
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        jPanel3.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.ipady = 15;
        jPanel2.add((Component)new HelpButton(HELP_URL), gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel4.add((Component)new JLabel("Save as: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.newNameField.setText(Deducer.getUniqueName((String)"untitled.corpus"));
        jPanel4.add((Component)this.newNameField, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel5.add((Component)new JLabel("Add to: "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        rObjectChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFileChooser.this.existingCorpus = rObjectChooser.getSelectedObject();
            }
        });
        rObjectChooser.setClassFilter("Corpus");
        rObjectChooser.refreshObjects();
        if (rObjectChooser.getObjectCount() > 0) {
            rObjectChooser.setSelectedIndex(0);
        }
        jPanel5.add((Component)rObjectChooser, gridBagConstraints);
        jPanel.add((Component)jPanel4, "make new corpus");
        jPanel.add((Component)jPanel5, "choose existing corpus");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jRadioButton.setSelected(true);
        return jPanel2;
    }

    public void run() {
        if (mostRecentPath != null) {
            this.fc.setCurrentDirectory(new File(mostRecentPath));
        }
        this.actualDialog.pack();
        this.actualDialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setVisible(true);
        TextFileChooser textFileChooser = new TextFileChooser(jFrame){};
        textFileChooser.run();
    }
}

