/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedSparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectedSparseFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, float[]> elements;
    protected int[] sliceOffsets;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedSparseFComplexMatrix3D(ConcurrentHashMap<Long, float[]> concurrentHashMap, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = nArray3.length;
        this.setUp(n2, n3, n4);
        this.elements = concurrentHashMap;
        this.sliceOffsets = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n;
        this.isNoView = false;
    }

    @Override
    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    @Override
    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    @Override
    protected int _sliceOffset(int n) {
        return this.sliceOffsets[n];
    }

    @Override
    public float[] getQuick(int n, int n2, int n3) {
        return this.elements.get((long)this.offset + (long)this.sliceOffsets[this.sliceZero + n * this.sliceStride] + (long)this.rowOffsets[this.rowZero + n2 * this.rowStride] + (long)this.columnOffsets[this.columnZero + n3 * this.columnStride]);
    }

    @Override
    public ConcurrentHashMap<Integer, float[]> elements() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D instanceof SelectedSparseFComplexMatrix3D) {
            SelectedSparseFComplexMatrix3D selectedSparseFComplexMatrix3D = (SelectedSparseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == selectedSparseFComplexMatrix3D.elements;
        }
        if (fComplexMatrix3D instanceof SparseFComplexMatrix3D) {
            SparseFComplexMatrix3D sparseFComplexMatrix3D = (SparseFComplexMatrix3D)fComplexMatrix3D;
            return this.elements == sparseFComplexMatrix3D.elements;
        }
        return false;
    }

    @Override
    public long index(int n, int n2, int n3) {
        return (long)this.offset + (long)this.sliceOffsets[this.sliceZero + n * this.sliceStride] + (long)this.rowOffsets[this.rowZero + n2 * this.rowStride] + (long)this.columnOffsets[this.columnZero + n3 * this.columnStride];
    }

    @Override
    public FComplexMatrix3D like(int n, int n2, int n3) {
        return new SparseFComplexMatrix3D(n, n2, n3);
    }

    @Override
    public FComplexMatrix1D vectorize() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    protected FComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    @Override
    public FComplexMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int n, int n2, int n3, float[] fArray) {
        long l = (long)this.offset + (long)this.sliceOffsets[this.sliceZero + n * this.sliceStride] + (long)this.rowOffsets[this.rowZero + n2 * this.rowStride] + (long)this.columnOffsets[this.columnZero + n3 * this.columnStride];
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, fArray);
        }
    }

    @Override
    public void setQuick(int n, int n2, int n3, float f, float f2) {
        long l = (long)this.offset + (long)this.sliceOffsets[this.sliceZero + n * this.sliceStride] + (long)this.rowOffsets[this.rowZero + n2 * this.rowStride] + (long)this.columnOffsets[this.columnZero + n3 * this.columnStride];
        if (f == 0.0f && f2 == 0.0f) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new float[]{f, f2});
        }
    }

    @Override
    protected void setUp(int n, int n2, int n3) {
        super.setUp(n, n2, n3);
        this.sliceStride = 1;
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    protected AbstractMatrix3D vDice(int n, int n2, int n3) {
        super.vDice(n, n2, n3);
        int[][] nArrayArray = new int[][]{this.sliceOffsets, this.rowOffsets, this.columnOffsets};
        this.sliceOffsets = nArrayArray[n];
        this.rowOffsets = nArrayArray[n2];
        this.columnOffsets = nArrayArray[n3];
        return this;
    }

    @Override
    public FComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero;
        int n6 = this.offset + this._columnOffset(this._columnRank(n));
        int n7 = this.sliceStride;
        int n8 = this.rowStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.rowOffsets;
        return new SelectedSparseFComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    @Override
    public FComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._rowOffset(this._rowRank(n));
        int n7 = this.sliceStride;
        int n8 = this.columnStride;
        int[] nArray = this.sliceOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseFComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    @Override
    protected FComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseFComplexMatrix3D(this.elements, nArray, nArray2, nArray3, this.offset);
    }

    @Override
    public FComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero;
        int n6 = this.offset + this._sliceOffset(this._sliceRank(n));
        int n7 = this.rowStride;
        int n8 = this.columnStride;
        int[] nArray = this.rowOffsets;
        int[] nArray2 = this.columnOffsets;
        return new SelectedSparseFComplexMatrix2D(n2, n3, this.elements, n4, n5, n7, n8, nArray, nArray2, n6);
    }

    @Override
    public FloatMatrix3D getImaginaryPart() {
        throw new IllegalAccessError("This method is not supported.");
    }

    @Override
    public FloatMatrix3D getRealPart() {
        throw new IllegalAccessError("This method is not supported.");
    }
}

