/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.custom.DotStat;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.RestQueryBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

public class ABS
extends DotStat {
    protected static Logger logger = Configuration.getSdmxLogger();

    public ABS() throws URISyntaxException {
        super("ABS", new URI("http://stat.data.abs.gov.au/restsdmx/sdmx.ashx"), false);
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.endpoint != null && string != null && !string.isEmpty()) {
            try {
                return new RestQueryBuilder(this.endpoint).addPath("GetDataStructure").addPath(string).addPath("ABS").build();
            }
            catch (MalformedURLException malformedURLException) {
                throw SdmxExceptionFactory.wrap(malformedURLException);
            }
        }
        throw new RuntimeException("Invalid query parameters: dsd=" + string + " endpoint=" + this.endpoint);
    }

    @Override
    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        Sdmx21Queries sdmx21Queries = (Sdmx21Queries)new Sdmx21Queries(this.endpoint).addPath("GetData").addPath(dataflow.getId()).addPath(string).addPath("ABS");
        sdmx21Queries.addParams(null, null, false, null, false, this.format);
        if (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty()) {
            if (string2 != null) {
                sdmx21Queries.addParam("startTime", string2);
            }
            if (string3 != null) {
                sdmx21Queries.addParam("endTime", string3);
            }
        }
        return sdmx21Queries.buildSdmx21Query();
    }
}

