/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.keellatextables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.Visualization.keellatextables.ResultsProccessor;

public class KeelLateXTables {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("No config file expecified");
            return;
        }
        try {
            String traFile = "";
            String tstFile = "";
            String txtFuzzyFile = "";
            String path = "";
            String outputPath = "";
            File config = null;
            Matcher m = null;
            ArrayList<String> processedAlgorithms = new ArrayList<String>();
            if (!args[0].equals(".")) {
                System.out.println("\n\nOpening Config File " + args[0]);
                config = new File(args[0]);
                BufferedReader reader = new BufferedReader(new FileReader(config));
                String text = "";
                while ((text = reader.readLine()) != null) {
                    if (text.indexOf("inputData") > -1) {
                        m = Pattern.compile("\"[^\"]+").matcher(text);
                    }
                    if (text.indexOf("outputData") <= -1) continue;
                    Matcher p = Pattern.compile("\"[^\"]+").matcher(text);
                    if (p.find()) {
                        outputPath = p.group().substring(1);
                        outputPath = outputPath.replace(".stat", ".tex");
                        System.out.println("outputPath = " + outputPath);
                        continue;
                    }
                    outputPath = null;
                }
            }
            ResultsProccessor p = new ResultsProccessor();
            boolean filesToProccess = false;
            while (m.find()) {
                filesToProccess = false;
                int i = 0;
                System.out.println("");
                System.out.print("File found: " + m.group());
                if (m.group().indexOf(".tra") > -1) {
                    filesToProccess = true;
                    traFile = m.group().substring(1);
                    traFile = traFile.replace(".KeelToPMML", "");
                    traFile = traFile.replace("/[a-zA-Z0-9]+.tra", "/");
                    int lastSlash = m.group().lastIndexOf("/");
                    path = m.group().substring(1, lastSlash + 1);
                    System.out.print("[PROCCESSING]");
                } else {
                    System.out.print("[PASSING]");
                }
                while (filesToProccess && !processedAlgorithms.contains(path)) {
                    traFile = path + "result0s" + i + ".tra";
                    tstFile = path + "result0s" + i + ".tst";
                    txtFuzzyFile = path + "result0s" + i + "e0.txt";
                    config = new File(tstFile);
                    if (!config.exists()) {
                        traFile = path + "result" + i + ".tra";
                        tstFile = path + "result" + i + ".tst";
                        txtFuzzyFile = path + "result" + i + "e0.txt";
                        config = new File(tstFile);
                        if (!config.exists()) {
                            filesToProccess = false;
                            break;
                        }
                    }
                    System.out.println("TST: " + tstFile);
                    System.out.println("TRA: " + traFile);
                    System.out.println("Path: " + path);
                    File isFuzzy = new File(txtFuzzyFile);
                    try {
                        p.parseXmlFile(txtFuzzyFile, path);
                    }
                    catch (Exception e) {
                        try {
                            p.parseXmlFile(tstFile, path);
                        }
                        catch (Exception ee) {
                            ee.printStackTrace();
                        }
                    }
                    ++i;
                }
                processedAlgorithms.add(path);
            }
            if (outputPath == null) {
                outputPath = path;
            }
            p.writeToFile(outputPath);
            System.out.println("LaTeX file generated! On: " + outputPath);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

