/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree.rec;

import java.util.Comparator;
import net.sf.jclec.IPopulation;
import net.sf.jclec.syntaxtree.AbstractSyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.ISyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.NonTerminalNode;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sf.jclec.syntaxtree.SyntaxTreeNode;
import net.sf.jclec.syntaxtree.SyntaxTreeRecombinator;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NTCrossover<I extends SyntaxTreeIndividual>
extends SyntaxTreeRecombinator<I> {
    private static final long serialVersionUID = -6447244450691681809L;
    protected Comparator<SyntaxTreeNode> symbolsComparator = new Comparator<SyntaxTreeNode>(){

        @Override
        public int compare(SyntaxTreeNode o1, SyntaxTreeNode o2) {
            if (o1 instanceof NonTerminalNode && o2 instanceof NonTerminalNode) {
                NonTerminalNode co1 = (NonTerminalNode)o1;
                NonTerminalNode co2 = (NonTerminalNode)o2;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append(co1.getSymbol(), co2.getSymbol());
                if (eb.isEquals()) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };

    public NTCrossover() {
    }

    public NTCrossover(IPopulation<I> context) {
        this.contextualize(context);
    }

    public boolean equals(Object other) {
        return other instanceof NTCrossover;
    }

    @Override
    protected void recombine(SyntaxTree parentTree0, SyntaxTree parentTree1, SyntaxTree sonTree0, SyntaxTree sonTree1, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        boolean cond1;
        int p0_branchStart = this.selectSymbol(parentTree0, parentTree1, schema);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parentTree0.size()) {
                sonTree0.addNode(parentTree0.getNode(i));
                ++i;
            }
            i = 0;
            while (i < parentTree1.size()) {
                sonTree1.addNode(parentTree1.getNode(i));
                ++i;
            }
            return;
        }
        NonTerminalNode selectedSymbol = (NonTerminalNode)parentTree0.getNode(p0_branchStart);
        int p1_branchStart = this.searchSymbolIn(selectedSymbol, parentTree1);
        int p0_branchEnd = parentTree0.subTree(p0_branchStart);
        int p1_branchEnd = parentTree1.subTree(p1_branchStart);
        int p0_branchDepth = parentTree0.derivSize();
        int p0_swapBranch = 0;
        int i = p0_branchStart;
        while (i < p0_branchEnd) {
            if (parentTree1.getNode(i).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i;
        }
        int p1_branchDepth = parentTree1.derivSize();
        int p1_swapBranch = 0;
        int i2 = p1_branchStart;
        while (i2 < p1_branchEnd) {
            if (parentTree1.getNode(i2).arity() != 0) {
                ++p1_swapBranch;
            }
            ++i2;
        }
        int maxDerivSize = schema.getMaxDerivSize();
        boolean cond0 = p0_branchDepth - p0_swapBranch + p1_swapBranch > maxDerivSize;
        boolean bl = cond1 = p1_branchDepth - p1_swapBranch + p0_swapBranch > maxDerivSize;
        if (cond0 || cond1) {
            int i3 = 0;
            while (i3 < parentTree0.size()) {
                sonTree0.addNode(parentTree0.getNode(i3));
                ++i3;
            }
            i3 = 0;
            while (i3 < parentTree1.size()) {
                sonTree1.addNode(parentTree1.getNode(i3));
                ++i3;
            }
            return;
        }
        int i4 = 0;
        while (i4 < p0_branchStart) {
            sonTree0.addNode(parentTree0.getNode(i4).copy());
            ++i4;
        }
        i4 = 0;
        while (i4 < p1_branchStart) {
            sonTree1.addNode(parentTree1.getNode(i4).copy());
            ++i4;
        }
        i4 = p0_branchStart;
        while (i4 < p0_branchEnd) {
            sonTree1.addNode(parentTree0.getNode(i4).copy());
            ++i4;
        }
        i4 = p1_branchStart;
        while (i4 < p1_branchEnd) {
            sonTree0.addNode(parentTree1.getNode(i4).copy());
            ++i4;
        }
        int p0_length = parentTree0.size();
        int i5 = p0_branchEnd;
        while (i5 < p0_length) {
            sonTree0.addNode(parentTree0.getNode(i5).copy());
            ++i5;
        }
        int p1_length = parentTree1.size();
        int i6 = p1_branchEnd;
        while (i6 < p1_length) {
            sonTree1.addNode(parentTree1.getNode(i6).copy());
            ++i6;
        }
    }

    private final int selectSymbol(SyntaxTree tree0, SyntaxTree tree1, ISyntaxTreeSpecies.ISyntaxTreeSchema schema) {
        int startPos;
        int treeLength = tree0.size();
        int actPos = startPos = this.randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!((AbstractSyntaxTreeSpecies.SyntaxTreeSchema)schema).isTerminal(tree0.getNode(actPos).getSymbol()) && this.searchSymbolIn((NonTerminalNode)tree0.getNode(actPos), tree1) != -1) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }

    private final int searchSymbolIn(NonTerminalNode symbol, SyntaxTree tree) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = this.randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (this.symbolsComparator.compare(symbol, tree.getNode(actPos)) == 0) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }
}

