/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ReflectionToStringBuilder
extends ToStringBuilder {
    private static ThreadLocal registry = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashSet();
        }
    };
    private boolean appendTransients = false;
    private Class upToClass = null;

    static Set getRegistry() {
        return (Set)registry.get();
    }

    static boolean isRegistered(Object value) {
        return ReflectionToStringBuilder.getRegistry().contains(value);
    }

    static void register(Object value) {
        ReflectionToStringBuilder.getRegistry().add(value);
    }

    public static String toString(Object object) {
        return ReflectionToStringBuilder.toString(object, null, false, null);
    }

    public static String toString(Object object, ToStringStyle style) {
        return ReflectionToStringBuilder.toString(object, style, false, null);
    }

    public static String toString(Object object, ToStringStyle style, boolean outputTransients) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, null);
    }

    public static String toString(Object object, ToStringStyle style, boolean outputTransients, Class reflectUpToClass) {
        return new ReflectionToStringBuilder(object, style, null, reflectUpToClass, outputTransients).toString();
    }

    static void unregister(Object value) {
        ReflectionToStringBuilder.getRegistry().remove(value);
    }

    public ReflectionToStringBuilder(Object object) {
        super(object);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle style) {
        super(object, style);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer) {
        super(object, style, buffer);
    }

    public ReflectionToStringBuilder(Object object, ToStringStyle style, StringBuffer buffer, Class reflectUpToClass, boolean outputTransients) {
        super(object, style, buffer);
        this.setUpToClass(reflectUpToClass);
        this.setAppendTransients(outputTransients);
    }

    protected boolean accept(Field field) {
        String fieldName = field.getName();
        return fieldName.indexOf(36) == -1 && (this.isAppendTransients() || !Modifier.isTransient(field.getModifiers())) && !Modifier.isStatic(field.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendFieldsIn(Class clazz) {
        if (ReflectionToStringBuilder.isRegistered(this.getObject())) {
            this.appendAsObjectToString(this.getObject());
            return;
        }
        try {
            this.registerObject();
            if (clazz.isArray()) {
                this.reflectionAppendArray(this.getObject());
                return;
            }
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject field = fields[i];
                String fieldName = ((Field)field).getName();
                if (!this.accept((Field)field)) continue;
                try {
                    Object fieldValue = this.getValue((Field)field);
                    if (ReflectionToStringBuilder.isRegistered(fieldValue) && !((Field)field).getType().isPrimitive()) {
                        this.getStyle().appendFieldStart(this.getStringBuffer(), fieldName);
                        this.appendAsObjectToString(fieldValue);
                        continue;
                    }
                    try {
                        this.registerObject();
                        this.append(fieldName, fieldValue);
                        continue;
                    }
                    finally {
                        this.unregisterObject();
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
                }
            }
        }
        finally {
            this.unregisterObject();
        }
    }

    public Class getUpToClass() {
        return this.upToClass;
    }

    protected Object getValue(Field field) throws IllegalArgumentException, IllegalAccessException {
        return field.get(this.getObject());
    }

    public boolean isAppendTransients() {
        return this.appendTransients;
    }

    public ToStringBuilder reflectionAppendArray(Object array) {
        this.getStyle().reflectionAppendArrayDetail(this.getStringBuffer(), null, array);
        return this;
    }

    void registerObject() {
        ReflectionToStringBuilder.register(this.getObject());
    }

    public void setAppendTransients(boolean appendTransients) {
        this.appendTransients = appendTransients;
    }

    public void setUpToClass(Class clazz) {
        this.upToClass = clazz;
    }

    public String toString() {
        Class<?> clazz;
        if (this.getObject() == null) {
            return this.getStyle().getNullText();
        }
        this.appendFieldsIn(clazz);
        for (clazz = this.getObject().getClass(); clazz.getSuperclass() != null && clazz != this.getUpToClass(); clazz = clazz.getSuperclass()) {
            this.appendFieldsIn(clazz);
        }
        return super.toString();
    }

    void unregisterObject() {
        ReflectionToStringBuilder.unregister(this.getObject());
    }
}

