/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.IntDouble;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.Node;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeAssert;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeConsequent;

public class NodeRule
extends Node {
    double weight;

    public NodeRule(NodeAssert assert1, NodeConsequent consequent, double w) {
        super(2, 6);
        this.weight = w;
        this.children[0] = assert1.clone();
        this.children[1] = consequent.clone();
    }

    public NodeRule(NodeRule n) {
        super(n.children.length, 6);
        this.weight = n.weight;
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = n.children[i].clone();
        }
    }

    public void set(NodeRule n) {
        super.set(n);
        this.weight = n.weight;
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = n.children[i].clone();
        }
    }

    @Override
    protected boolean compatibleData(Node n) {
        return this.mytypeid == n.mytypeid;
    }

    @Override
    public Node clone() {
        return new NodeRule(this);
    }

    public IntDouble CrispEval() {
        IntDouble result = new IntDouble();
        NodeAssert tmp1 = (NodeAssert)this.children[0];
        NodeConsequent tmp2 = (NodeConsequent)this.children[1];
        result.weight = tmp1.CrispEval() * this.weight;
        result.consequent = tmp2.CrispEval();
        return result;
    }

    @Override
    public void debug() {
        System.out.print("IF ");
        this.children[0].debug();
        System.out.print(" THEN ");
        this.children[1].debug();
        if (this.weight != 1.0) {
            System.out.print(" W. WEIGHT " + this.weight);
        }
        System.out.println();
    }

    @Override
    public String output() {
        String rules = new String("");
        rules = "IF ";
        rules = rules + this.children[0].output();
        rules = rules + " THEN ";
        rules = rules + this.children[1].output();
        if (this.weight != 1.0) {
            rules = rules + " W. WEIGHT " + this.weight;
        }
        rules = rules + "\n";
        return rules;
    }
}

