/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.sourceforge.jclec.JCLEC;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.IPrimitive;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ExprTreeSchema
implements JCLEC {
    private static final long serialVersionUID = -2204221331549325549L;
    protected int minTreeSize;
    protected int maxTreeSize;
    protected Class<?> rootType;
    protected IPrimitive[] terminals;
    protected IPrimitive[] functions;
    protected HashMap<Class<?>, IPrimitive[]> allMap;
    protected HashMap<Class<?>, IPrimitive[]> termMap;
    protected HashMap<Class<?>, IPrimitive[]> funcMap;

    public final void setRootType(Class<?> rootType) {
        this.rootType = rootType;
    }

    public final void setMinTreeSize(int minTreeSize) {
        this.minTreeSize = minTreeSize;
    }

    public final void setMaxTreeSize(int maxTreeSize) {
        this.maxTreeSize = maxTreeSize;
    }

    public final void setTerminals(IPrimitive[] terminals) {
        this.terminals = terminals;
        if (this.functions != null) {
            this.generateBlockMaps();
        }
    }

    public void setFunctions(IPrimitive[] functions) {
        this.functions = functions;
        if (this.terminals != null) {
            this.generateBlockMaps();
        }
    }

    public Class<?> getRootType() {
        return this.rootType;
    }

    public int getMinTreeSize() {
        return this.minTreeSize;
    }

    public int getMaxTreeSize() {
        return this.maxTreeSize;
    }

    public int getNumFunctionBlocks(Class<?> rtype) {
        return this.funcMap.get(rtype).length;
    }

    public IPrimitive getTerminalBlock(Class<?> rtype, IRandGen randgen) {
        IPrimitive[] termBlocks = this.termMap.get(rtype);
        IPrimitive result = termBlocks[randgen.choose(0, termBlocks.length)];
        return result.instance();
    }

    public IPrimitive getFunctionBlock(Class<?> rtype, IRandGen randgen) {
        IPrimitive[] funcBlocks = this.funcMap.get(rtype);
        IPrimitive result = funcBlocks[randgen.choose(0, funcBlocks.length)];
        return result.instance();
    }

    public IPrimitive getFunctionBlock(Class<?> rtype, IRandGen randgen, int arity) {
        IPrimitive result;
        IPrimitive[] funcBlocks = this.funcMap.get(rtype);
        while ((result = funcBlocks[randgen.choose(0, funcBlocks.length)]).argumentTypes().length != arity) {
        }
        return result.instance();
    }

    public IPrimitive getFunctionBlockBetweenMinMaxArity(Class<?> rtype, IRandGen randgen, int minArity, int maxArity) {
        IPrimitive[] funcBlocks = this.funcMap.get(rtype);
        int initialIndex = 0;
        int finalIndex = 0;
        while (finalIndex < funcBlocks.length) {
            if (funcBlocks[finalIndex].argumentTypes().length < minArity) {
                ++initialIndex;
            }
            if (funcBlocks[finalIndex].argumentTypes().length > maxArity) break;
            ++finalIndex;
        }
        if (finalIndex == 0) {
            return null;
        }
        return funcBlocks[randgen.choose(initialIndex, finalIndex)];
    }

    public IPrimitive getAnyBlock(Class<?> rtype, IRandGen randgen) {
        IPrimitive[] allBlocks = this.allMap.get(rtype);
        IPrimitive result = allBlocks[randgen.choose(0, allBlocks.length)];
        return result.instance();
    }

    public IPrimitive getAnyBlock(Class<?> rtype, IRandGen randgen, int arity) {
        IPrimitive result;
        IPrimitive[] allBlocks = this.allMap.get(rtype);
        while ((result = allBlocks[randgen.choose(0, allBlocks.length)]).argumentTypes().length != arity) {
        }
        return result.instance();
    }

    public ExprTree createExprTree(int maxSize, IRandGen randgen) {
        ExprTree result = new ExprTree();
        this.fillExprBranch(result, this.rootType, maxSize, randgen);
        return result;
    }

    public void fillExprBranch(ExprTree exprTree, Class<?> returnType, int maxSize, IRandGen randgen) {
        IPrimitive root = maxSize == 1 ? this.getTerminalBlock(returnType, randgen) : this.getBranchBlock(returnType, randgen, maxSize - 1);
        exprTree.addBlock(root);
        Class<?>[] sonTypes = root.argumentTypes();
        int numberOfSons = sonTypes.length;
        if (numberOfSons != 0) {
            int newMaxSize = (maxSize - 1) / numberOfSons;
            if (newMaxSize < 1) {
                newMaxSize = 1;
            }
            int i = 0;
            while (i < numberOfSons) {
                this.fillExprBranch(exprTree, sonTypes[i], newMaxSize, randgen);
                ++i;
            }
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ExprTreeSchema) {
            ExprTreeSchema cother = (ExprTreeSchema)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.minTreeSize, cother.minTreeSize);
            eb.append(this.maxTreeSize, cother.maxTreeSize);
            eb.append(this.rootType, cother.rootType);
            eb.append(this.functions, cother.functions);
            eb.append(this.terminals, cother.terminals);
            return eb.isEquals();
        }
        return false;
    }

    protected final void generateBlockMaps() {
        Class<?> returnType;
        IPrimitive block;
        Comparator<IPrimitive> arityComparator = new Comparator<IPrimitive>(){

            @Override
            public int compare(IPrimitive one, IPrimitive two) {
                int twoarity;
                int onearity = one.argumentTypes().length;
                if (onearity > (twoarity = two.argumentTypes().length)) {
                    return 1;
                }
                if (onearity < twoarity) {
                    return -1;
                }
                return 0;
            }
        };
        HashMap allMapTmp = new HashMap();
        HashMap termMapTmp = new HashMap();
        HashMap funcMapTmp = new HashMap();
        IPrimitive[] iPrimitiveArray = this.terminals;
        int n = this.terminals.length;
        int n2 = 0;
        while (n2 < n) {
            block = iPrimitiveArray[n2];
            returnType = block.returnType();
            if (!allMapTmp.containsKey(returnType)) {
                allMapTmp.put(returnType, new ArrayList());
                termMapTmp.put(returnType, new ArrayList());
            }
            ((ArrayList)allMapTmp.get(returnType)).add(block);
            ((ArrayList)termMapTmp.get(returnType)).add(block);
            ++n2;
        }
        iPrimitiveArray = this.functions;
        n = this.functions.length;
        n2 = 0;
        while (n2 < n) {
            block = iPrimitiveArray[n2];
            returnType = block.returnType();
            if (!allMapTmp.containsKey(returnType)) {
                allMapTmp.put(returnType, new ArrayList());
            }
            ((ArrayList)allMapTmp.get(returnType)).add(block);
            if (!funcMapTmp.containsKey(returnType)) {
                funcMapTmp.put(returnType, new ArrayList());
            }
            ((ArrayList)funcMapTmp.get(returnType)).add(block);
            ++n2;
        }
        this.allMap = new HashMap();
        for (Class key : allMapTmp.keySet()) {
            IPrimitive[] aux = ((ArrayList)allMapTmp.get(key)).toArray(new IPrimitive[0]);
            Arrays.sort(aux, arityComparator);
            this.allMap.put(key, aux);
        }
        this.termMap = new HashMap();
        for (Class key : termMapTmp.keySet()) {
            IPrimitive[] aux = ((ArrayList)termMapTmp.get(key)).toArray(new IPrimitive[0]);
            Arrays.sort(aux, arityComparator);
            this.termMap.put(key, aux);
        }
        this.funcMap = new HashMap();
        for (Class key : funcMapTmp.keySet()) {
            IPrimitive[] aux = ((ArrayList)funcMapTmp.get(key)).toArray(new IPrimitive[0]);
            Arrays.sort(aux, arityComparator);
            this.funcMap.put(key, aux);
        }
    }

    protected final IPrimitive getBranchBlock(Class<?> returnType, IRandGen randgen, int arity) {
        IPrimitive[] funcBlocks = this.funcMap.get(returnType);
        int auxIndex = 0;
        while (auxIndex < funcBlocks.length) {
            if (funcBlocks[auxIndex].argumentTypes().length > arity) break;
            ++auxIndex;
        }
        if (auxIndex == 0) {
            return this.getTerminalBlock(returnType, randgen);
        }
        return funcBlocks[randgen.choose(0, auxIndex)];
    }
}

