/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.definitions.InternalKnowledgePackage;

public class MVELDialectConfiguration
implements DialectConfiguration {
    private KnowledgeBuilderConfigurationImpl conf;
    private boolean strict;
    private int langLevel;

    @Override
    public Dialect newDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        return new MVELDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
    }

    @Override
    public void init(KnowledgeBuilderConfigurationImpl conf) {
        this.conf = conf;
        this.setStrict(this.determineStrict());
        this.setLangLevel(this.determineLangLevel());
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getPackageBuilderConfiguration() {
        return this.conf;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setLangLevel(int langLevel) {
        this.langLevel = langLevel;
    }

    public int getLangLevel() {
        return this.langLevel;
    }

    private boolean determineStrict() {
        String prop = this.conf.getChainedProperties().getProperty("drools.dialect.mvel.strict", "true");
        return Boolean.valueOf(prop);
    }

    private int determineLangLevel() {
        String prop = this.conf.getChainedProperties().getProperty("drools.dialect.mvel.langLevel", "4");
        return Integer.valueOf(prop);
    }
}

