/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.subset.neigh.moves;

import java.util.Collections;
import java.util.Set;
import org.jamesframework.core.exceptions.SolutionModificationException;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.AbstractSubsetMove;

public class SwapMove
extends AbstractSubsetMove {
    private final int add;
    private final int delete;

    public SwapMove(int add, int delete) {
        if (add == delete) {
            throw new IllegalArgumentException("Error while creating swap move: added and deleted ID can not be equal.");
        }
        this.add = add;
        this.delete = delete;
    }

    @Override
    public void apply(SubsetSolution solution) {
        if (solution.select(this.add)) {
            if (!solution.deselect(this.delete)) {
                throw new SolutionModificationException("Error while applying swap move to subset solution: deleted ID currently not selected.", (Solution)solution);
            }
        } else {
            throw new SolutionModificationException("Error while applying swap move to subset solution: added ID already selected.", (Solution)solution);
        }
    }

    @Override
    public void undo(SubsetSolution solution) {
        solution.select(this.delete);
        solution.deselect(this.add);
    }

    @Override
    public Set<Integer> getAddedIDs() {
        return Collections.singleton(this.add);
    }

    public int getAddedID() {
        return this.add;
    }

    @Override
    public Set<Integer> getDeletedIDs() {
        return Collections.singleton(this.delete);
    }

    public int getDeletedID() {
        return this.delete;
    }

    @Override
    public int getNumAdded() {
        return 1;
    }

    @Override
    public int getNumDeleted() {
        return 1;
    }
}

