/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees.data;

import java.util.ArrayList;
import java.util.HashMap;
import org.extratrees.data.Array2D;
import org.extratrees.data.Row;

public class CSparseMatrix
implements Array2D {
    ArrayList<HashMap<Integer, Double>> cols;
    int nrows;

    public CSparseMatrix(int[] nArray, int[] nArray2, double[] dArray, int n, int n2) {
        int n3;
        if (nArray.length != nArray2.length) {
            throw new RuntimeException("Length of rows and cols does not equal.");
        }
        if (nArray.length != dArray.length) {
            throw new RuntimeException("Length of rows and values does not equal.");
        }
        this.cols = new ArrayList(n2);
        this.nrows = n;
        for (n3 = 0; n3 < n2; ++n3) {
            this.cols.add(new HashMap());
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (n2 <= nArray2[n3]) {
                throw new IllegalArgumentException(String.format("ncols (%d) is smaller or equal than cols[%d] (%d)", n2, n3, nArray2[n3]));
            }
            if (n <= nArray[n3]) {
                throw new IllegalArgumentException(String.format("nrows (%d) is smaller or equal than rows[%d] (%d)", n, n3, nArray[n3]));
            }
            this.cols.get(nArray2[n3]).put(nArray[n3], dArray[n3]);
        }
    }

    @Override
    public double get(int n, int n2) {
        Double d = this.cols.get(n2).get(n);
        return d == null ? 0.0 : d;
    }

    @Override
    public int ncols() {
        return this.cols.size();
    }

    @Override
    public int nrows() {
        return this.nrows;
    }

    @Override
    public Row getRow(int n) {
        return new SMRow(n);
    }

    public int getNumNonZero() {
        int n = 0;
        for (HashMap<Integer, Double> hashMap : this.cols) {
            n += hashMap.size();
        }
        return n;
    }

    public class SMRow
    implements Row {
        int row;

        public SMRow(int n) {
            this.row = n;
        }

        @Override
        public double get(int n) {
            return CSparseMatrix.this.get(this.row, n);
        }
    }
}

