/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeByte;
import it.geosolutions.jaiext.range.RangeDouble;
import it.geosolutions.jaiext.range.RangeFloat;
import it.geosolutions.jaiext.range.RangeInt;
import it.geosolutions.jaiext.range.RangeLong;
import it.geosolutions.jaiext.range.RangeShort;
import it.geosolutions.jaiext.range.RangeUshort;
import java.util.ArrayList;
import java.util.List;

public class RangeFactory {
    private static final double TOLERANCE = 1.0E-6;

    private RangeFactory() {
    }

    public static Range create(byte minValue, boolean minIncluded, byte maxValue, boolean maxIncluded) {
        return new RangeByte(minValue, minIncluded, maxValue, maxIncluded);
    }

    public static Range createU(short minValue, boolean minIncluded, short maxValue, boolean maxIncluded) {
        return new RangeUshort(minValue, minIncluded, maxValue, maxIncluded);
    }

    public static Range create(short minValue, boolean minIncluded, short maxValue, boolean maxIncluded) {
        return new RangeShort(minValue, minIncluded, maxValue, maxIncluded);
    }

    public static Range create(int minValue, boolean minIncluded, int maxValue, boolean maxIncluded) {
        return new RangeInt(minValue, minIncluded, maxValue, maxIncluded);
    }

    public static Range create(float minValue, boolean minIncluded, float maxValue, boolean maxIncluded, boolean nanIncluded) {
        return new RangeFloat(minValue, minIncluded, maxValue, maxIncluded, nanIncluded);
    }

    public static Range create(double minValue, boolean minIncluded, double maxValue, boolean maxIncluded, boolean nanIncluded) {
        return new RangeDouble(minValue, minIncluded, maxValue, maxIncluded, nanIncluded);
    }

    public static Range create(byte minValue, byte maxValue) {
        return new RangeByte(minValue, true, maxValue, true);
    }

    public static Range createU(short minValue, short maxValue) {
        return new RangeUshort(minValue, true, maxValue, true);
    }

    public static Range create(short minValue, short maxValue) {
        return new RangeShort(minValue, true, maxValue, true);
    }

    public static Range create(int minValue, int maxValue) {
        return new RangeInt(minValue, true, maxValue, true);
    }

    public static Range create(float minValue, float maxValue) {
        return new RangeFloat(minValue, true, maxValue, true, false);
    }

    public static Range create(double minValue, double maxValue) {
        return new RangeDouble(minValue, true, maxValue, true, false);
    }

    public static Range create(float minValue, boolean minIncluded, float maxValue, boolean maxIncluded) {
        return new RangeFloat(minValue, minIncluded, maxValue, maxIncluded, false);
    }

    public static Range create(double minValue, boolean minIncluded, double maxValue, boolean maxIncluded) {
        return new RangeDouble(minValue, minIncluded, maxValue, maxIncluded, false);
    }

    public static Range create(long minValue, boolean minIncluded, long maxValue, boolean maxIncluded) {
        return new RangeLong(minValue, minIncluded, maxValue, maxIncluded);
    }

    public static Range convertToDoubleRange(Range input) {
        if (input instanceof RangeDouble) {
            return input;
        }
        double min2 = input.getMin().doubleValue();
        double max = input.getMax().doubleValue();
        boolean minIncluded = input.isMinIncluded();
        boolean maxIncluded = input.isMaxIncluded();
        boolean nanIncluded = input.isNanIncluded();
        return new RangeDouble(min2, minIncluded, max, maxIncluded, nanIncluded);
    }

    public static Range convertToFloatRange(Range input) {
        if (input instanceof RangeFloat) {
            return input;
        }
        float min2 = input.getMin().floatValue();
        float max = input.getMax().floatValue();
        boolean minIncluded = input.isMinIncluded();
        boolean maxIncluded = input.isMaxIncluded();
        boolean nanIncluded = input.isNanIncluded();
        return new RangeFloat(min2, minIncluded, max, maxIncluded, nanIncluded);
    }

    public static Range convert(Range input, int dataType) {
        if (input == null) {
            return null;
        }
        if (input.getDataType().getDataType() == dataType) {
            return input;
        }
        switch (dataType) {
            case 0: {
                return RangeByte.FULL_RANGE.intersection(input);
            }
            case 1: {
                return RangeUshort.FULL_RANGE.intersection(input);
            }
            case 2: {
                return RangeShort.FULL_RANGE.intersection(input);
            }
            case 3: {
                return RangeInt.FULL_RANGE.intersection(input);
            }
            case 4: {
                return RangeFloat.FULL_RANGE.intersection(input);
            }
            case 5: {
                return RangeDouble.FULL_RANGE.intersection(input);
            }
        }
        return null;
    }

    public static Range convertToByteRange(Range input) {
        if (input instanceof RangeByte) {
            return input;
        }
        byte min2 = input.getMin().byteValue();
        byte max = input.getMax().byteValue();
        boolean minIncluded = input.isMinIncluded();
        boolean maxIncluded = input.isMaxIncluded();
        return new RangeByte(min2, minIncluded, max, maxIncluded);
    }

    public static List<Range> subtract(Range r1, Range r2) {
        ArrayList<Range> list = new ArrayList<Range>();
        if (r1.equals(r2)) {
            return list;
        }
        Range common = RangeFactory.intersect(r1, r2);
        if (common == null) {
            list.add(r2);
            return list;
        }
        if (common.equals(r2)) {
            return list;
        }
        double min1 = r1.getMin().doubleValue();
        double min2 = r2.getMin().doubleValue();
        double max1 = r1.getMax().doubleValue();
        double max2 = r2.getMax().doubleValue();
        boolean minmin = RangeFactory.equals(min1, min2);
        boolean maxmax = RangeFactory.equals(max1, max2);
        boolean minmax = RangeFactory.equals(min1, max2);
        boolean maxmin = RangeFactory.equals(max1, min2);
        if (minmax) {
            if (r1.isMinIncluded()) {
                Range r = RangeFactory.create(min2, r2.isMinIncluded(), max2, false);
                list.add(r);
                return list;
            }
            list.add(r2);
            return list;
        }
        if (maxmin) {
            if (r1.isMaxIncluded()) {
                Range r = RangeFactory.create(min2, false, max2, r2.isMinIncluded());
                list.add(r);
                return list;
            }
            list.add(r2);
            return list;
        }
        if (minmin && max2 > max1 && !maxmax) {
            Range r = RangeFactory.create(max1, !r1.isMaxIncluded(), max2, r2.isMaxIncluded());
            list.add(r);
            return list;
        }
        if (maxmax && min2 < min1 && !minmin) {
            Range r = RangeFactory.create(min2, r2.isMinIncluded(), min1, !r1.isMinIncluded());
            list.add(r);
            return list;
        }
        if (min2 < min1 && max2 < max1) {
            Range r = RangeFactory.create(min2, r2.isMinIncluded(), min1, !r1.isMinIncluded());
            list.add(r);
            return list;
        }
        if (min2 > min1 && max2 > max1) {
            Range r = RangeFactory.create(max1, !r1.isMaxIncluded(), max2, r2.isMaxIncluded());
            list.add(r);
            return list;
        }
        if (min2 < min1 && max2 > max1) {
            Range r1New = RangeFactory.create(min2, r2.isMinIncluded(), min1, !r1.isMinIncluded());
            Range r2New = RangeFactory.create(max1, !r1.isMaxIncluded(), max2, r2.isMaxIncluded());
            list.add(r1New);
            list.add(r2New);
            return list;
        }
        return list;
    }

    public static Range intersect(Range r1, Range r2) {
        return r1.intersection(r2);
    }

    public static boolean equals(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-6;
    }
}

