/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.GeoMath;
import net.sf.geographiclib.Pair;

public class Accumulator {
    private double _s;
    private double _t;

    public Accumulator(double y) {
        this._s = y;
        this._t = 0.0;
    }

    public Accumulator(Accumulator a2) {
        this._s = a2._s;
        this._t = a2._t;
    }

    public void Set(double y) {
        this._s = y;
        this._t = 0.0;
    }

    public double Sum() {
        return this._s;
    }

    public double Sum(double y) {
        Accumulator a2 = new Accumulator(this);
        a2.Add(y);
        return a2._s;
    }

    public void Add(double y) {
        Pair r = GeoMath.sum(y, this._t);
        y = r.first;
        double u = r.second;
        r = GeoMath.sum(y, this._s);
        this._s = r.first;
        this._t = r.second;
        if (this._s == 0.0) {
            this._s = u;
        } else {
            this._t += u;
        }
    }

    public void Negate() {
        this._s = -this._s;
        this._t = -this._t;
    }
}

