/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.learn;

import java.util.HashSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.clauses.ClauseBuilder;
import org.chocosolver.solver.constraints.nary.clauses.ClauseStore;
import org.chocosolver.solver.constraints.nary.clauses.PropSignedClause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.learn.IExplanation;
import org.chocosolver.solver.learn.Implications;
import org.chocosolver.solver.learn.XParameters;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.PoolManager;
import org.chocosolver.util.objects.ValueSortedMap;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class ExplanationForSignedClause
extends IExplanation {
    private final ValueSortedMap<IntVar> front = new ValueSortedMap();
    private final HashSet<IntVar> literals = new HashSet();
    private int assertLevel = 0;
    private final Implications mIG;
    private final PoolManager<IntIterableRangeSet> manager = new PoolManager();

    public ExplanationForSignedClause(Implications ig) {
        this.mIG = ig;
    }

    @Override
    public void extractConstraint(Model mModel, ClauseStore ngstore) {
        ClauseBuilder ngb = mModel.getClauseBuilder();
        this.literals.forEach(v -> ngb.put((IntVar)v, v.getLit().export()));
        ngb.buildNogood(mModel);
    }

    @Override
    public void recycle() {
        this.front.clear();
        this.literals.forEach(IntVar::flushLit);
        this.literals.clear();
        this.assertLevel = Integer.MAX_VALUE;
    }

    public void learnSolution(DecisionPath path) {
        this.recycle();
        if (path.size() > 1) {
            int i = path.size() - 1;
            IntDecision dec = (IntDecision)path.getDecision(i);
            while (i > 1 && !dec.hasNext() && dec.getArity() > 1) {
                dec = (IntDecision)path.getDecision(--i);
            }
            while (i > 0) {
                dec = (IntDecision)path.getDecision(i);
                IntIterableRangeSet dom = null;
                IntVar var = (IntVar)dec.getDecisionVariable();
                if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntEq())) {
                    if (dec.hasNext() || dec.getArity() == 1) {
                        dom = this.universe();
                        dom.remove(dec.getDecisionValue());
                    } else {
                        dom = this.empty();
                        dom.add(dec.getDecisionValue());
                    }
                } else if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntNeq())) {
                    if (dec.hasNext() || dec.getArity() == 1) {
                        dom = this.empty();
                        dom.add(dec.getDecisionValue());
                    } else {
                        dom = this.universe();
                        dom.remove(dec.getDecisionValue());
                    }
                } else if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntSplit())) {
                    dom = this.universe();
                    if (dec.hasNext() || dec.getArity() == 1) {
                        dom.retainBetween(dec.getDecisionValue() + 1, 0x3FFFFFFF);
                    } else {
                        dom.retainBetween(-1073741823, dec.getDecisionValue());
                    }
                } else if (dec.getDecOp().equals(DecisionOperatorFactory.makeIntReverseSplit())) {
                    dom = this.universe();
                    if (dec.hasNext() || dec.getArity() == 1) {
                        dom.retainBetween(-1073741823, dec.getDecisionValue() - 1);
                    } else {
                        dom.retainBetween(dec.getDecisionValue(), 0x3FFFFFFF);
                    }
                }
                var.unionLit(dom, this);
                --i;
            }
        }
    }

    public void learnSignedClause(ContradictionException cex) {
        this.recycle();
        if (XParameters.PROOF) {
            System.out.print("<-----");
        }
        this.initFront(cex);
        this.loop();
        if (XParameters.PROOF) {
            System.out.print(">\n");
        }
    }

    private void initFront(ContradictionException cex) {
        this.mIG.collectNodesFromConflict(cex, this.front);
        if (cex.v == null) {
            if (Propagator.class.isAssignableFrom(cex.c.getClass())) {
                if (XParameters.PROOF) {
                    System.out.printf("\nCstr: %s\n", cex.c);
                    System.out.print("Pivot: none\n");
                }
                this.explain(cex.c, -1);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void loop() {
        do {
            int current = this.front.pollLastValue();
            this.mIG.predecessorsOf(current, this.front);
            if (XParameters.PROOF) {
                System.out.printf("\nCstr: %s\n", this.mIG.getCauseAt(current));
                System.out.printf("Pivot: %s = %s\n", this.mIG.getIntVarAt(current).getName(), this.mIG.getDomainAt(current));
            }
            this.explain(this.mIG.getCauseAt(current), current);
            if (XParameters.PROOF) {
                System.out.print("Expl: {");
                this.literals.stream().forEach(v -> System.out.printf("%s \u2208 %s,", v, v.getLit()));
                System.out.print("}\n-----");
            }
            this.relax();
        } while (!this.stop());
    }

    private void explain(ICause cause, int p) {
        if (p == -1 || XParameters.DEFAULT_X && Propagator.class.isAssignableFrom(cause.getClass()) && !PropSignedClause.class.isAssignableFrom(cause.getClass()) && !ClauseStore.SignedClause.class.isAssignableFrom(cause.getClass())) {
            Propagator propagator = (Propagator)cause;
            Propagator.defaultExplain(propagator, p, this);
        } else {
            cause.explain(p, this);
        }
        this.checkReification(cause, p);
    }

    private void checkReification(ICause cause, int p) {
        Propagator propagator;
        if (Propagator.class.isAssignableFrom(cause.getClass()) && (propagator = (Propagator)cause).isReified()) {
            BoolVar b2 = propagator.reifiedWith();
            assert (!propagator.isReifiedAndSilent());
            this.mIG.findPredecessor(this.front, b2, p == -1 ? this.mIG.size() : p);
            if (b2.isInstantiated()) {
                if (XParameters.FINE_PROOF) {
                    System.out.print("Reif: ");
                }
                b2.unionLit(1 - b2.getValue(), this);
            } else {
                throw new UnsupportedOperationException("Oh nooo!");
            }
        }
    }

    private void relax() {
        int l;
        int k = -1;
        while (!this.front.isEmpty() && (l = this.front.getLastValue()) != k) {
            if (!this.literals.contains(this.mIG.getIntVarAt(l))) {
                this.front.pollLastValue();
            } else {
                IntVar var = this.mIG.getIntVarAt(l);
                int p = this.mIG.getPredecessorOf(l);
                if (p < l && var.getLit().disjoint(this.mIG.getDomainAt(p))) {
                    this.front.replace(var, p);
                }
            }
            k = l;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean stop() {
        if (this.front.isEmpty()) ** GOTO lbl-1000
        max = this.front.getLastValue();
        if (IntEventType.VOID.getMask() == this.mIG.getEventMaskAt(max) || this.mIG.getDecisionLevelAt(max) == 1) lbl-1000:
        // 2 sources

        {
            if (XParameters.PROOF) {
                System.out.print("\nbacktrack to ROOT\n-----");
            }
            this.assertLevel = this.mIG.getIntVarAt(0).getModel().getSolver().getDecisionPath().getDecision(0).getPosition();
        } else if (IntDecision.class.isAssignableFrom(this.mIG.getCauseAt(max).getClass())) {
            if (XParameters.PROOF) {
                System.out.printf("\nbacktrack to %s\n-----", new Object[]{this.mIG.getCauseAt(max)});
            }
            if (XParameters.ASSERT_NO_LEFT_BRANCH && !((IntDecision)this.mIG.getCauseAt(max)).hasNext()) {
                throw new SolverException("Weak explanation found. Try to backjump to :" + this.mIG.getCauseAt(max) + "\n" + this.literals);
            }
            this.assertLevel = ((IntDecision)this.mIG.getCauseAt(max)).getPosition();
        }
        return this.assertLevel != 0x7FFFFFFF;
    }

    @Deprecated
    public void addLiteral(IntVar var, IntIterableRangeSet dom, boolean pivot) {
        if (pivot) {
            var.intersectLit(dom, this);
        } else {
            var.unionLit(dom, this);
        }
    }

    public void removeLit(IntVar var) {
        this.literals.remove(var);
        this.front.remove(var);
    }

    public void addLit(IntVar var) {
        this.literals.add(var);
    }

    public boolean contains(IntVar var) {
        return this.literals.contains(var);
    }

    public int getCardinality() {
        return this.literals.size();
    }

    public int getAssertingLevel() {
        return this.assertLevel;
    }

    public IntIterableRangeSet empty() {
        IntIterableRangeSet set = this.manager.getE();
        if (set == null) {
            return new IntIterableRangeSet();
        }
        set.unlock();
        return set;
    }

    public void returnSet(IntIterableRangeSet set) {
        set.clear();
        set.lock();
        this.manager.returnE(set);
    }

    public IntIterableRangeSet domain(IntVar var) {
        IntIterableRangeSet set = this.empty();
        set.copyFrom(this.readDom(var));
        return set;
    }

    public IntIterableRangeSet complement(IntVar var) {
        IntIterableRangeSet set = this.root(var);
        set.removeAll(this.readDom(var));
        return set;
    }

    public IntIterableRangeSet setDiffVal(int val) {
        IntIterableRangeSet set = this.universe();
        set.remove(val);
        return set;
    }

    public IntIterableRangeSet universe() {
        IntIterableRangeSet set = this.empty();
        set.addBetween(-1073741823, 0x3FFFFFFF);
        return set;
    }

    public IntIterableRangeSet root(IntVar var) {
        IntIterableRangeSet set = this.empty();
        set.copyFrom(this.mIG.getRootDomain(var));
        return set;
    }

    public ValueSortedMap<IntVar> getFront() {
        return this.front;
    }

    public Implications getImplicationGraph() {
        return this.mIG;
    }

    public IntVar readVar(int p) {
        return this.mIG.getIntVarAt(p);
    }

    public int readMask(int p) {
        return this.mIG.getEventMaskAt(p);
    }

    public int readValue(int p) {
        return this.mIG.getValueAt(p);
    }

    public IntIterableRangeSet readDom(int p) {
        return this.mIG.getDomainAt(p);
    }

    public IntIterableRangeSet readDom(IntVar var) {
        return this.mIG.getDomainAt(this.front.getValue(var));
    }

    public HashSet<IntVar> getLiterals() {
        return this.literals;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append('{');
        this.literals.stream().forEach(v -> st.append(v.getName()).append('\u2208').append(v.getLit()).append(','));
        st.append('}');
        return st.toString();
    }
}

