/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.function.Predicate;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.variables.Variable;

public class AntiLastConflict<V extends Variable>
implements IMonitorRestart,
IMonitorSolution,
IMonitorContradiction,
Predicate<V> {
    protected Model model;
    protected boolean active;
    private V conflictingVariable;

    public AntiLastConflict(Model model) {
        this.model = model;
        this.conflictingVariable = null;
        this.active = false;
        model.getSolver().plugMonitor(this);
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        Object curDecVar = this.model.getSolver().getDecisionPath().getLastDecision().getDecisionVariable();
        this.conflictingVariable = curDecVar;
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        this.active = false;
    }

    @Override
    public void onSolution() {
        this.active = false;
    }

    @Override
    public boolean test(V v) {
        return v != this.conflictingVariable;
    }
}

