/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryEntry;
import org.geotools.data.memory.MemoryState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;

public class MemoryFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    MemoryState state;
    SimpleFeatureType featureType;
    Name typeName;
    Iterator<SimpleFeature> iterator;
    SimpleFeature live = null;
    SimpleFeature current = null;

    public MemoryFeatureWriter(MemoryState state, Query query) throws IOException {
        this.state = state;
        this.typeName = state.getEntry().getName();
        this.featureType = state.getFeatureType();
        MemoryEntry entry = state.getEntry();
        this.iterator = entry.getMemory().values().iterator();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    @Override
    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.hasNext()) {
            this.live = this.iterator.next();
            try {
                this.current = SimpleFeatureBuilder.copy((SimpleFeature)this.live);
            }
            catch (IllegalAttributeException e2) {
                throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + this.typeName);
            }
        }
        this.live = null;
        try {
            this.current = SimpleFeatureBuilder.template((SimpleFeatureType)this.featureType, null);
        }
        catch (IllegalAttributeException e3) {
            throw new DataSourceException("Unable to add additional Features of " + this.typeName);
        }
        return this.current;
    }

    @Override
    public void remove() throws IOException {
        if (this.iterator == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to remove");
        }
        if (this.live != null) {
            this.iterator.remove();
            this.live = null;
            this.current = null;
        } else {
            this.current = null;
        }
    }

    @Override
    public void write() throws IOException {
        if (this.iterator == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to write");
        }
        if (Boolean.TRUE.equals(this.current.getUserData().get(Hints.USE_PROVIDED_FID)) && this.current.getUserData().containsKey(Hints.PROVIDED_FID)) {
            String fid = (String)this.current.getUserData().get(Hints.PROVIDED_FID);
            FeatureIdImpl id = new FeatureIdImpl(fid);
            this.current = new SimpleFeatureImpl(this.current.getAttributes(), this.current.getFeatureType(), (FeatureId)id);
        }
        if (this.live != null) {
            if (this.live.equals(this.current)) {
                this.live = null;
                this.current = null;
            } else {
                try {
                    this.live.setAttributes(this.current.getAttributes());
                }
                catch (Exception e2) {
                    throw new DataSourceException("Unable to accept modifications to " + this.live.getID() + " on " + this.typeName);
                }
                ReferencedEnvelope bounds = new ReferencedEnvelope();
                bounds.expandToInclude(new ReferencedEnvelope(this.live.getBounds()));
                bounds.expandToInclude(new ReferencedEnvelope(this.current.getBounds()));
                this.live = null;
                this.current = null;
            }
        } else {
            MemoryEntry entry = this.state.getEntry();
            entry.addFeature(this.current);
            this.current = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.iterator == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator = null;
        }
        if (this.featureType != null) {
            this.featureType = null;
        }
        this.current = null;
        this.live = null;
    }
}

