/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.geom.Rectangle2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.util.Classes;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ReferencedEnvelope
extends Envelope
implements org.opengis.geometry.Envelope,
BoundingBox {
    public static ReferencedEnvelope EVERYTHING = new ReferencedEnvelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null){
        private static final long serialVersionUID = -3188702602373537164L;

        @Override
        public boolean contains(BoundingBox bbox) {
            return true;
        }

        @Override
        public boolean contains(Coordinate p) {
            return true;
        }

        @Override
        public boolean contains(DirectPosition pos) {
            return true;
        }

        @Override
        public boolean contains(double x, double y) {
            return true;
        }

        @Override
        public boolean contains(Envelope other) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public double getArea() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void setBounds(BoundingBox arg0) {
            throw new IllegalStateException("Cannot modify ReferencedEnvelope.EVERYTHING");
        }

        @Override
        public Coordinate centre() {
            return new Coordinate();
        }

        @Override
        public void setToNull() {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == EVERYTHING) {
                return true;
            }
            if (obj instanceof ReferencedEnvelope) {
                ReferencedEnvelope other = (ReferencedEnvelope)obj;
                if (other.crs != 1.EVERYTHING.crs) {
                    return false;
                }
                if (other.getMinX() != EVERYTHING.getMinX()) {
                    return false;
                }
                if (other.getMinY() != EVERYTHING.getMinY()) {
                    return false;
                }
                if (other.getMaxX() != EVERYTHING.getMaxX()) {
                    return false;
                }
                return other.getMaxY() == EVERYTHING.getMaxY();
            }
            return super.equals(obj);
        }

        @Override
        public String toString() {
            return "ReferencedEnvelope.EVERYTHING";
        }
    };
    private static final long serialVersionUID = -3188702602373537163L;
    protected CoordinateReferenceSystem crs;

    public ReferencedEnvelope() {
        this((CoordinateReferenceSystem)null);
    }

    public ReferencedEnvelope(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(double x1, double x2, double y1, double y2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(x1, x2, y1, y2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Rectangle2D rectangle, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY(), crs);
    }

    public ReferencedEnvelope(ReferencedEnvelope envelope) throws MismatchedDimensionException {
        super(envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(BoundingBox bbox) throws MismatchedDimensionException {
        this(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), bbox.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope(org.opengis.geometry.Envelope envelope) throws MismatchedDimensionException {
        super(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1));
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public void init(BoundingBox bounds) {
        super.init(bounds.getMinimum(0), bounds.getMaximum(0), bounds.getMinimum(1), bounds.getMaximum(1));
        this.crs = bounds.getCoordinateReferenceSystem();
    }

    private static Envelope getJTSEnvelope(BoundingBox bbox) {
        if (bbox == null) {
            throw new NullPointerException("Provided bbox envelope was null");
        }
        if (bbox instanceof Envelope) {
            return (Envelope)((Object)bbox);
        }
        return ReferencedEnvelope.create(bbox, bbox.getCoordinateReferenceSystem());
    }

    protected void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int expected = this.getDimension();
            int dimension = this.crs.getCoordinateSystem().getDimension();
            if (dimension > expected) {
                throw new MismatchedDimensionException(Errors.format(94, this.crs.getName().getCode(), dimension, expected));
            }
        }
    }

    protected void ensureCompatibleReferenceSystem(BoundingBox bbox) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = bbox.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException(Errors.format(92));
        }
    }

    protected void ensureCompatibleReferenceSystem(DirectPosition location) {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = location.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException(Errors.format(92));
        }
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getMedian(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public DirectPosition getLowerCorner() {
        return new DirectPosition2D(this.crs, this.getMinX(), this.getMinY());
    }

    @Override
    public DirectPosition getUpperCorner() {
        return new DirectPosition2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    @Override
    public boolean isEmpty() {
        return super.isNull();
    }

    @Override
    public boolean contains(DirectPosition pos) {
        this.ensureCompatibleReferenceSystem(pos);
        return super.contains(pos.getOrdinate(0), pos.getOrdinate(1));
    }

    @Override
    public boolean contains(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.contains(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    @Override
    public boolean intersects(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.intersects(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    @Override
    public ReferencedEnvelope intersection(Envelope env) {
        if (env instanceof BoundingBox) {
            BoundingBox bbox = (BoundingBox)((Object)env);
            this.ensureCompatibleReferenceSystem(bbox);
        }
        return new ReferencedEnvelope(super.intersection(env), this.getCoordinateReferenceSystem());
    }

    @Override
    public void include(BoundingBox bbox) {
        if (this.crs == null) {
            this.crs = bbox.getCoordinateReferenceSystem();
        } else {
            this.ensureCompatibleReferenceSystem(bbox);
        }
        this.expandToInclude(ReferencedEnvelope.reference(bbox));
    }

    public void expandToInclude(DirectPosition pt) {
        Coordinate coordinate = new Coordinate(pt.getOrdinate(0), pt.getOrdinate(1));
        this.expandToInclude(coordinate);
    }

    @Override
    public void expandToInclude(Envelope other) {
        if (other instanceof BoundingBox) {
            if (other.isNull()) {
                return;
            }
            BoundingBox bbox = (BoundingBox)((Object)other);
            this.ensureCompatibleReferenceSystem(bbox);
            this.expandToInclude(bbox.getLowerCorner());
            this.expandToInclude(bbox.getUpperCorner());
        } else {
            super.expandToInclude(other);
        }
    }

    @Override
    public void include(double x, double y) {
        super.expandToInclude(x, y);
    }

    @Override
    public void setBounds(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        super.init(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    @Override
    public BoundingBox toBounds(CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return this.transform(targetCRS, true);
        }
        catch (FactoryException e2) {
            throw new TransformException(e2.getLocalizedMessage(), e2);
        }
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient) throws TransformException, FactoryException {
        return this.transform(targetCRS, lenient, 5);
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient, int numPointsForTransformation) throws TransformException, FactoryException {
        if (this.crs == null) {
            if (this.isEmpty()) {
                return new ReferencedEnvelope(targetCRS);
            }
            throw new NullPointerException("Unable to transform referenced envelope, crs has not yet been provided.");
        }
        if (this.getDimension() != targetCRS.getCoordinateSystem().getDimension()) {
            if (lenient) {
                return JTS.transformTo3D(this, targetCRS, lenient, numPointsForTransformation);
            }
            throw new MismatchedDimensionException(Errors.format(94, this.crs.getName().getCode(), this.getDimension(), targetCRS.getCoordinateSystem().getDimension()));
        }
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(lenient);
        CoordinateOperation operation = coordinateOperationFactory.createOperation(this.crs, targetCRS);
        GeneralEnvelope transformed = CRS.transform(operation, (org.opengis.geometry.Envelope)this);
        transformed.setCoordinateReferenceSystem(targetCRS);
        ReferencedEnvelope target = new ReferencedEnvelope(transformed);
        MathTransform transform = operation.getMathTransform();
        JTS.transform(this, target, transform, numPointsForTransformation);
        return target;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem otherCRS = object instanceof ReferencedEnvelope ? ((ReferencedEnvelope)object).crs : null;
            return CRS.equalsIgnoreMetadata(this.crs, otherCRS);
        }
        return false;
    }

    public boolean boundsEquals2D(org.opengis.geometry.Envelope other, double eps) {
        eps *= 0.5 * (this.getWidth() + this.getHeight());
        double[] delta = new double[]{this.getMinimum(0) - other.getMinimum(0), this.getMaximum(0) - other.getMaximum(0), this.getMinimum(1) - other.getMinimum(1), this.getMaximum(1) - other.getMaximum(1)};
        for (int i = 0; i < delta.length; ++i) {
            if (Math.abs(delta[i]) <= eps) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this)).append('[');
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getMinimum(i)).append(" : ").append(this.getMaximum(i));
        }
        return buffer.append(']').toString();
    }

    public static ReferencedEnvelope create(ReferencedEnvelope original) {
        if (original instanceof ReferencedEnvelope3D) {
            return new ReferencedEnvelope3D((ReferencedEnvelope3D)original);
        }
        return new ReferencedEnvelope(original);
    }

    public static ReferencedEnvelope create(CoordinateReferenceSystem crs) {
        if (crs != null && crs.getCoordinateSystem().getDimension() > 2) {
            return new ReferencedEnvelope3D(crs);
        }
        return new ReferencedEnvelope(crs);
    }

    public static ReferencedEnvelope create(org.opengis.geometry.Envelope env, CoordinateReferenceSystem crs) {
        if (env == null) {
            return null;
        }
        if (env.getDimension() >= 3) {
            return new ReferencedEnvelope3D((ReferencedEnvelope3D)ReferencedEnvelope.reference(env), crs);
        }
        return new ReferencedEnvelope(ReferencedEnvelope.reference(env), crs);
    }

    public static ReferencedEnvelope create(ReferencedEnvelope env, CoordinateReferenceSystem crs) {
        return ReferencedEnvelope.create((org.opengis.geometry.Envelope)env, crs);
    }

    public static ReferencedEnvelope create(Envelope env, CoordinateReferenceSystem crs) {
        if (env == null) {
            return null;
        }
        if (crs != null && crs.getCoordinateSystem().getDimension() >= 3) {
            if (env.isNull()) {
                return new ReferencedEnvelope3D(crs);
            }
            return new ReferencedEnvelope3D(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), Double.NaN, Double.NaN, crs);
        }
        if (env.isNull()) {
            return new ReferencedEnvelope(crs);
        }
        return new ReferencedEnvelope(env, crs);
    }

    public static ReferencedEnvelope reference(Envelope e2) {
        if (e2 == null) {
            return null;
        }
        if (e2 instanceof ReferencedEnvelope3D) {
            return (ReferencedEnvelope3D)e2;
        }
        if (e2 instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)e2;
        }
        return new ReferencedEnvelope(e2, null);
    }

    public static ReferencedEnvelope reference(ReferencedEnvelope e2) {
        return ReferencedEnvelope.reference((org.opengis.geometry.Envelope)e2);
    }

    public static ReferencedEnvelope reference(org.opengis.geometry.Envelope env) {
        if (env == null) {
            return null;
        }
        if (env instanceof ReferencedEnvelope3D) {
            return (ReferencedEnvelope3D)env;
        }
        if (env instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)env;
        }
        if (env.getDimension() >= 3) {
            if (env.getMaximum(0) < env.getMinimum(0)) {
                return new ReferencedEnvelope3D(env.getCoordinateReferenceSystem());
            }
            return new ReferencedEnvelope3D(env);
        }
        if (env.getMaximum(0) < env.getMinimum(0)) {
            return new ReferencedEnvelope(env.getCoordinateReferenceSystem());
        }
        return new ReferencedEnvelope(env);
    }

    public static ReferencedEnvelope create(Rectangle2D rectangle, CoordinateReferenceSystem crs) {
        if (rectangle.isEmpty()) {
            return new ReferencedEnvelope(crs);
        }
        return new ReferencedEnvelope(rectangle, crs);
    }
}

