/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils.shape;

import java.awt.geom.AffineTransform;
import org.jaitools.imageutils.shape.AbstractLiteIterator;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

public final class LineIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private CoordinateSequence coordinates = null;
    private int currentCoord = 0;
    private boolean done = false;
    private boolean isClosed;
    private int coordinateCount;
    private static final AffineTransform NO_TRANSFORM = new AffineTransform();

    public LineIterator() {
    }

    public LineIterator(LineString ls, AffineTransform at) {
        this.init(ls, at);
    }

    public void init(LineString ls, AffineTransform at) {
        if (at == null) {
            at = NO_TRANSFORM;
        }
        this.at = at;
        this.coordinates = ls.getCoordinateSequence();
        this.coordinateCount = this.coordinates.size();
        this.isClosed = ls instanceof LinearRing;
        this.done = false;
        this.currentCoord = 0;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void next() {
        if (this.currentCoord == this.coordinateCount - 1 && !this.isClosed || this.currentCoord == this.coordinateCount && this.isClosed) {
            this.done = true;
        } else {
            ++this.currentCoord;
        }
    }

    @Override
    public int currentSegment(double[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = this.coordinates.getX(0);
            coords[1] = this.coordinates.getY(0);
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentCoord == this.coordinateCount && this.isClosed) {
            return 4;
        }
        coords[0] = this.coordinates.getX(this.currentCoord);
        coords[1] = this.coordinates.getY(this.currentCoord);
        this.at.transform(coords, 0, coords, 0, 1);
        return 1;
    }
}

