/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.ArbitraryBranchRates;
import dr.evomodel.branchratemodel.AutoCorrelatedBranchRatesDistribution;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.Reportable;

public class AutoCorrelatedGradientWrtIncrements
implements GradientWrtParameterProvider,
Reportable {
    private final AutoCorrelatedBranchRatesDistribution distribution;
    private final ArbitraryBranchRates branchRates;
    private final Tree tree;
    private final AutoCorrelatedBranchRatesDistribution.BranchVarianceScaling scaling;
    private final AutoCorrelatedBranchRatesDistribution.BranchRateUnits units;
    private Parameter parameter;
    private double[] cachedIncrements;

    public AutoCorrelatedGradientWrtIncrements(AutoCorrelatedBranchRatesDistribution autoCorrelatedBranchRatesDistribution) {
        this.distribution = autoCorrelatedBranchRatesDistribution;
        this.branchRates = autoCorrelatedBranchRatesDistribution.getBranchRateModel();
        this.tree = autoCorrelatedBranchRatesDistribution.getTree();
        this.scaling = autoCorrelatedBranchRatesDistribution.getScaling();
        this.units = autoCorrelatedBranchRatesDistribution.getUnits();
    }

    @Override
    public Likelihood getLikelihood() {
        return this.distribution.getLikelihood();
    }

    @Override
    public Parameter getParameter() {
        if (this.parameter == null) {
            this.parameter = this.createParameter();
        }
        return this.parameter;
    }

    @Override
    public int getDimension() {
        return this.distribution.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = this.distribution.getGradientWrtIncrements();
        if (this.units.needsIncrementCorrection()) {
            this.recursePostOrderToCorrectGradient(this.tree.getRoot(), dArray);
        }
        return dArray;
    }

    public AutoCorrelatedBranchRatesDistribution getDistribution() {
        return this.distribution;
    }

    private int recursePostOrderToCorrectGradient(NodeRef nodeRef, double[] dArray) {
        int n = 1;
        if (!this.tree.isExternal(nodeRef)) {
            n += this.recursePostOrderToCorrectGradient(this.tree.getChild(nodeRef, 0), dArray);
            n += this.recursePostOrderToCorrectGradient(this.tree.getChild(nodeRef, 1), dArray);
        }
        if (!this.tree.isRoot(nodeRef)) {
            int n2;
            int n3 = n2 = this.branchRates.getParameterIndexFromNode(nodeRef);
            dArray[n3] = dArray[n3] - this.scaling.inverseRescaleIncrement(1.0 * (double)n, this.tree.getBranchLength(nodeRef));
        }
        return n;
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null);
    }

    private Parameter createParameter() {
        return new Parameter.Proxy("increments", this.distribution.getDimension()){

            @Override
            public double getParameterValue(int n) {
                return AutoCorrelatedGradientWrtIncrements.this.distribution.getIncrement(n);
            }

            @Override
            public void setParameterValue(int n, double d) {
                throw new RuntimeException("Do not set single value at a time");
            }

            @Override
            public void setParameterValueQuietly(int n, double d) {
                if (AutoCorrelatedGradientWrtIncrements.this.cachedIncrements == null) {
                    AutoCorrelatedGradientWrtIncrements.access$102(AutoCorrelatedGradientWrtIncrements.this, new double[this.getDimension()]);
                }
                ((AutoCorrelatedGradientWrtIncrements)AutoCorrelatedGradientWrtIncrements.this).cachedIncrements[n] = d;
            }

            @Override
            public void setParameterValueNotifyChangedAll(int n, double d) {
                throw new RuntimeException("Do not set single value at a time");
            }

            @Override
            public void fireParameterChangedEvent(int n, Variable.ChangeType changeType) {
                double[] dArray = new double[this.getDimension()];
                AutoCorrelatedGradientWrtIncrements.this.recurse(AutoCorrelatedGradientWrtIncrements.this.tree.getRoot(), dArray, AutoCorrelatedGradientWrtIncrements.this.cachedIncrements, 0.0);
                Parameter parameter = AutoCorrelatedGradientWrtIncrements.this.distribution.getParameter();
                for (int i = 0; i < dArray.length; ++i) {
                    parameter.setParameterValueQuietly(i, dArray[i]);
                }
                parameter.fireParameterChangedEvent();
            }

            @Override
            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getParameterValue(0)));
                for (int i = 1; i < this.dim; ++i) {
                    stringBuilder.append(", ").append(this.getParameterValue(i));
                }
                return stringBuilder.toString();
            }
        };
    }

    private void recurse(NodeRef nodeRef, double[] dArray, double[] dArray2, double d) {
        double d2 = d;
        if (!this.tree.isRoot(nodeRef)) {
            int n = this.branchRates.getParameterIndexFromNode(nodeRef);
            dArray[n] = this.units.inverseTransform(d2 += this.scaling.inverseRescaleIncrement(dArray2[n], this.tree.getBranchLength(nodeRef)));
        }
        if (!this.tree.isExternal(nodeRef)) {
            this.recurse(this.tree.getChild(nodeRef, 0), dArray, dArray2, d2);
            this.recurse(this.tree.getChild(nodeRef, 1), dArray, dArray2, d2);
        }
    }

    static /* synthetic */ double[] access$102(AutoCorrelatedGradientWrtIncrements autoCorrelatedGradientWrtIncrements, double[] dArray) {
        autoCorrelatedGradientWrtIncrements.cachedIncrements = dArray;
        return dArray;
    }
}

