/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import java.util.ArrayList;
import java.util.List;

public class AlternatingOperatorSchedule
implements OperatorSchedule {
    private final List<OperatorSchedule> operatorSchedules = new ArrayList<OperatorSchedule>();
    private final List<Long> operatorCounts = new ArrayList<Long>();
    private int currentSchedule = 0;
    private long scheduleCount = 0L;

    public void addOperatorSchedule(OperatorSchedule operatorSchedule, long l) {
        this.operatorSchedules.add(operatorSchedule);
        this.operatorCounts.add(l);
    }

    @Override
    public int getNextOperatorIndex() {
        if (this.scheduleCount >= this.operatorCounts.get(this.currentSchedule)) {
            ++this.currentSchedule;
            if (this.currentSchedule >= this.operatorSchedules.size()) {
                this.currentSchedule = 0;
            }
            this.scheduleCount = 0L;
        }
        ++this.scheduleCount;
        int n = 0;
        for (int i = 0; i < this.currentSchedule; ++i) {
            n += this.operatorSchedules.get(i).getOperatorCount();
        }
        return n + this.operatorSchedules.get(this.currentSchedule).getNextOperatorIndex();
    }

    public void reset() {
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
                operatorSchedule.getOperator(i).reset();
            }
        }
    }

    @Override
    public int getOperatorCount() {
        int n = 0;
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            n += operatorSchedule.getOperatorCount();
        }
        return n;
    }

    @Override
    public MCMCOperator getOperator(int n) {
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            int n2 = operatorSchedule.getOperatorCount();
            if (n < n2) {
                return operatorSchedule.getOperator(n);
            }
            n -= n2;
        }
        return null;
    }

    @Override
    public void addOperator(MCMCOperator mCMCOperator) {
        System.err.println("ERROR: addOperator() should not be called on AlternatingOperatorSchedule, use individual operator schedules to add operators. This call will have no affect!");
    }

    @Override
    public void addOperators(List<MCMCOperator> list) {
        System.err.println("ERROR: addOperators() should not be called on AlternatingOperatorSchedule, use individual operator schedules to add operators. This call will have no affect!");
    }

    @Override
    public void operatorsHasBeenUpdated() {
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            operatorSchedule.operatorsHasBeenUpdated();
        }
    }

    @Override
    public OperatorSchedule.OptimizationTransform getOptimizationTransform() {
        if (this.operatorSchedules.size() > 0) {
            return this.operatorSchedules.get(0).getOptimizationTransform();
        }
        return null;
    }

    @Override
    public long getMinimumAcceptAndRejectCount() {
        long l = Integer.MAX_VALUE;
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            if (operatorSchedule.getMinimumAcceptAndRejectCount() >= l) continue;
            l = operatorSchedule.getMinimumAcceptAndRejectCount();
        }
        return l;
    }
}

