/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.file;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.utilities.NameManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import jd2.datatypes.sa.SaProcessingType;
import jd2.workspace.WorkspaceFamily;
import jd2.workspace.WorkspaceItem;
import jd2.workspace.file.FileWorkspace;
import jd2.workspace.util.Paths;

public final class FileRepository {
    public static void storeSaProcessing(FileWorkspace ws, WorkspaceItem item, SaProcessingType processing) throws IOException {
        FileRepository.makeSaProcessingBackup(ws, item);
        ws.store(item, processing);
    }

    public static Map<WorkspaceItem, SaProcessingType> loadAllSaProcessing(FileWorkspace ws, ProcessingContext context) throws IOException {
        LinkedHashMap<WorkspaceItem, SaProcessingType> result = new LinkedHashMap<WorkspaceItem, SaProcessingType>();
        for (WorkspaceItem item : ws.getItems()) {
            WorkspaceFamily family = item.getFamily();
            if (!family.equals((Object)WorkspaceFamily.SA_MULTI)) continue;
            result.put(item, (SaProcessingType)ws.load(item));
        }
        return result;
    }

    public static Map<WorkspaceItem, GregorianCalendarManager> loadAllCalendars(FileWorkspace ws, ProcessingContext context) throws IOException {
        LinkedHashMap<WorkspaceItem, GregorianCalendarManager> result = new LinkedHashMap<WorkspaceItem, GregorianCalendarManager>();
        for (WorkspaceItem item : ws.getItems()) {
            WorkspaceFamily family = item.getFamily();
            if (!family.equals((Object)WorkspaceFamily.UTIL_CAL)) continue;
            GregorianCalendarManager calendar = (GregorianCalendarManager)ws.load(item);
            result.put(item, calendar);
            FileRepository.applyCalendars(context, calendar);
        }
        return result;
    }

    public static Map<WorkspaceItem, TsVariables> loadAllVariables(FileWorkspace ws, ProcessingContext context) throws IOException {
        LinkedHashMap<WorkspaceItem, TsVariables> result = new LinkedHashMap<WorkspaceItem, TsVariables>();
        for (WorkspaceItem item : ws.getItems()) {
            WorkspaceFamily family = item.getFamily();
            if (!family.equals((Object)WorkspaceFamily.UTIL_VAR)) continue;
            TsVariables vars = (TsVariables)ws.load(item);
            result.put(item, vars);
            FileRepository.applyVariables(context, item.getLabel(), vars);
        }
        return result;
    }

    private static void makeSaProcessingBackup(FileWorkspace ws, WorkspaceItem item) throws IOException {
        Path source = ws.getFile(item);
        Path target = source.getParent().resolve(Paths.changeExtension(source.getFileName().toString(), "bak"));
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void applyVariables(ProcessingContext context, String id, TsVariables value) {
        NameManager manager = context.getTsVariableManagers();
        manager.set(id, (Object)value);
        manager.resetDirty();
    }

    private static void applyCalendars(ProcessingContext context, GregorianCalendarManager value) {
        GregorianCalendarManager manager = context.getGregorianCalendars();
        for (String s : value.getNames()) {
            if (manager.contains(s)) continue;
            IGregorianCalendarProvider cal = (IGregorianCalendarProvider)value.get(s);
            manager.set(s, (Object)cal);
        }
        manager.resetDirty();
    }

    private FileRepository() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

