/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.CenterNN;

import keel.Algorithms.Lazy_Learning.LazyAlgorithm;

public class CenterNN
extends LazyAlgorithm {
    double[][] centers;
    double[][] diferences;
    double[] quads;
    double[] classDistance;
    double[] projection;
    double[] separation;

    public CenterNN(String script) {
        this.readDataFiles(script);
        this.name = "Center NN";
        this.classDistance = new double[this.nClasses];
        this.diferences = new double[this.trainData.length][this.inputAtt];
        this.quads = new double[this.trainData.length];
        this.projection = new double[this.inputAtt];
        this.separation = new double[this.inputAtt];
        this.centers = new double[this.nClasses][this.inputAtt];
        for (int i = 0; i < this.nClasses; ++i) {
            for (int j = 0; j < this.inputAtt; ++j) {
                this.centers[i][j] = 0.0;
            }
        }
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
    }

    public void precalculateParameters() {
        this.calculateCenters();
        this.calculateDiferences();
    }

    private void calculateCenters() {
        int j;
        int i;
        for (i = 0; i < this.trainData.length; ++i) {
            int insClass = this.trainOutput[i];
            for (j = 0; j < this.inputAtt; ++j) {
                double[] dArray = this.centers[insClass];
                int n = j;
                dArray[n] = dArray[n] + this.trainData[i][j];
            }
        }
        for (i = 0; i < this.nClasses; ++i) {
            j = 0;
            while (j < this.inputAtt) {
                double[] dArray = this.centers[i];
                int n = j++;
                dArray[n] = dArray[n] / (double)this.nInstances[i];
            }
        }
    }

    private void calculateDiferences() {
        for (int i = 0; i < this.trainData.length; ++i) {
            double sum = 0.0;
            int insClass = this.trainOutput[i];
            for (int j = 0; j < this.inputAtt; ++j) {
                this.diferences[i][j] = this.centers[insClass][j] - this.trainData[i][j];
                sum += this.diferences[i][j] * this.diferences[i][j];
            }
            this.quads[i] = sum;
        }
    }

    @Override
    protected int evaluate(double[] example) {
        int i;
        int output = -1;
        for (i = 0; i < this.nClasses; ++i) {
            this.classDistance[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            if (!(this.euclideanDistance(example, this.trainData[i]) > 0.0)) continue;
            int insClass = this.trainOutput[i];
            double MU = this.calculateMu(example, i);
            for (int j = 0; j < this.inputAtt; ++j) {
                this.projection[j] = this.trainData[i][j] + MU * this.diferences[i][j];
            }
            double distance = this.euclideanDistance(example, this.projection);
            if (!(this.classDistance[insClass] > distance)) continue;
            this.classDistance[insClass] = distance;
        }
        double min = Double.MAX_VALUE;
        for (i = 0; i < this.nClasses; ++i) {
            if (!(min > this.classDistance[i])) continue;
            min = this.classDistance[i];
            output = i;
        }
        return output;
    }

    private double calculateMu(double[] example, int instance) {
        double sum = 0.0;
        for (int i = 0; i < this.inputAtt; ++i) {
            this.separation[i] = example[i] - this.trainData[instance][i];
            sum += this.separation[i] * this.diferences[instance][i];
        }
        double mu = sum / this.quads[instance];
        return mu;
    }
}

