/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import java.io.Serializable;
import java.util.Enumeration;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.AttributeWeka;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.FastVector;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instance;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.UnassignedClassException;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Utils;
import org.core.Randomize;

public class Instances
implements Serializable {
    static final long serialVersionUID = -19412345060742748L;
    public static final String FILE_EXTENSION = ".arff";
    public static final String SERIALIZED_OBJ_FILE_EXTENSION = ".bsi";
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    protected String m_RelationName;
    protected FastVector m_Attributes;
    protected FastVector m_Instances;
    protected int m_ClassIndex;
    protected int m_Lines = 0;
    private int attIdx4Randomization = -1;
    private double[] attIdxOrigValues;

    public Instances(Instances dataset) {
        this(dataset, dataset.numInstances());
        dataset.copyInstances(0, this, dataset.numInstances());
    }

    public Instances(Instances dataset, int capacity) {
        this.initialize(dataset, capacity);
    }

    protected void initialize(Instances dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.m_ClassIndex = dataset.m_ClassIndex;
        this.m_RelationName = dataset.m_RelationName;
        this.m_Attributes = dataset.m_Attributes;
        this.m_Instances = new FastVector(capacity);
    }

    public Instances(Instances source, int first, int toCopy) {
        this(source, toCopy);
        if (first < 0 || first + toCopy > source.numInstances()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        source.copyInstances(first, this, toCopy);
    }

    public Instances(String name, FastVector attInfo, int capacity) {
        this.m_RelationName = name;
        this.m_ClassIndex = -1;
        this.m_Attributes = attInfo;
        for (int i = 0; i < this.numAttributes(); ++i) {
            this.attribute(i).setIndex(i);
        }
        this.m_Instances = new FastVector(capacity);
    }

    public Instances stringFreeStructure() {
        FastVector newAtts = new FastVector();
        for (int i = 0; i < this.m_Attributes.size(); ++i) {
            AttributeWeka att = (AttributeWeka)this.m_Attributes.elementAt(i);
            if (att.type() == 2) {
                newAtts.addElement(new AttributeWeka(att.name(), (FastVector)null, i));
                continue;
            }
            if (att.type() != 4) continue;
            newAtts.addElement(new AttributeWeka(att.name(), new Instances(att.relation(), 0), i));
        }
        if (newAtts.size() == 0) {
            return new Instances(this, 0);
        }
        FastVector atts = (FastVector)this.m_Attributes.copy();
        for (int i = 0; i < newAtts.size(); ++i) {
            atts.setElementAt(newAtts.elementAt(i), ((AttributeWeka)newAtts.elementAt(i)).index());
        }
        Instances result = new Instances(this, 0);
        result.m_Attributes = atts;
        return result;
    }

    public void add(Instance instance) {
        Instance newInstance = (Instance)instance.copy();
        newInstance.setDataset(this);
        this.m_Instances.addElement(newInstance);
    }

    public AttributeWeka attribute(int index) {
        return (AttributeWeka)this.m_Attributes.elementAt(index);
    }

    public AttributeWeka attribute(String name) {
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (!this.attribute(i).name().equals(name)) continue;
            return this.attribute(i);
        }
        return null;
    }

    public boolean checkForAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i++).type() != attType) continue;
            return true;
        }
        return false;
    }

    public boolean checkForStringAttributes() {
        return this.checkForAttributeType(2);
    }

    public boolean checkInstance(Instance instance) {
        if (instance.numAttributes() != this.numAttributes()) {
            return false;
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (instance.isMissing(i) || !this.attribute(i).isNominal() && !this.attribute(i).isString()) continue;
            if (!Utils.eq(instance.value(i), (int)instance.value(i))) {
                return false;
            }
            if (!Utils.sm(instance.value(i), 0.0) && !Utils.gr(instance.value(i), this.attribute(i).numValues())) continue;
            return false;
        }
        return true;
    }

    public AttributeWeka classAttribute() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        return this.attribute(this.m_ClassIndex);
    }

    public int classIndex() {
        return this.m_ClassIndex;
    }

    public void compactify() {
        this.m_Instances.trimToSize();
    }

    public void delete() {
        this.m_Instances = new FastVector();
    }

    public void delete(int index) {
        this.m_Instances.removeElementAt(index);
    }

    public void deleteAttributeAt(int position) {
        int i;
        if (position < 0 || position >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (position == this.m_ClassIndex) {
            throw new IllegalArgumentException("Can't delete class attribute");
        }
        this.freshAttributeInfo();
        if (this.m_ClassIndex > position) {
            --this.m_ClassIndex;
        }
        this.m_Attributes.removeElementAt(position);
        for (i = position; i < this.m_Attributes.size(); ++i) {
            AttributeWeka current = (AttributeWeka)this.m_Attributes.elementAt(i);
            current.setIndex(current.index() - 1);
        }
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).forceDeleteAttributeAt(position);
        }
    }

    public void deleteAttributeType(int attType) {
        int i = 0;
        while (i < this.m_Attributes.size()) {
            if (this.attribute(i).type() == attType) {
                this.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    public void deleteStringAttributes() {
        this.deleteAttributeType(2);
    }

    public void deleteWithMissing(int attIndex) {
        FastVector newInstances = new FastVector(this.numInstances());
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(attIndex)) continue;
            newInstances.addElement(this.instance(i));
        }
        this.m_Instances = newInstances;
    }

    public void deleteWithMissing(AttributeWeka att) {
        this.deleteWithMissing(att.index());
    }

    public void deleteWithMissingClass() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        this.deleteWithMissing(this.m_ClassIndex);
    }

    public Enumeration enumerateAttributes() {
        return this.m_Attributes.elements(this.m_ClassIndex);
    }

    public Enumeration enumerateInstances() {
        return this.m_Instances.elements();
    }

    public boolean equalHeaders(Instances dataset) {
        if (this.m_ClassIndex != dataset.m_ClassIndex) {
            return false;
        }
        if (this.m_Attributes.size() != dataset.m_Attributes.size()) {
            return false;
        }
        for (int i = 0; i < this.m_Attributes.size(); ++i) {
            if (this.attribute(i).equals(dataset.attribute(i))) continue;
            return false;
        }
        return true;
    }

    public Instance firstInstance() {
        return (Instance)this.m_Instances.firstElement();
    }

    public void insertAttributeAt(AttributeWeka att, int position) {
        int i;
        if (position < 0 || position > this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        att = (AttributeWeka)att.copy();
        this.freshAttributeInfo();
        att.setIndex(position);
        this.m_Attributes.insertElementAt(att, position);
        for (i = position + 1; i < this.m_Attributes.size(); ++i) {
            AttributeWeka current = (AttributeWeka)this.m_Attributes.elementAt(i);
            current.setIndex(current.index() + 1);
        }
        for (i = 0; i < this.numInstances(); ++i) {
            this.instance(i).forceInsertAttributeAt(position);
        }
        if (this.m_ClassIndex >= position) {
            ++this.m_ClassIndex;
        }
    }

    public Instance instance(int index) {
        return (Instance)this.m_Instances.elementAt(index);
    }

    public double kthSmallestValue(AttributeWeka att, int k) {
        return this.kthSmallestValue(att.index(), k);
    }

    public double kthSmallestValue(int attIndex, int k) {
        if (!this.attribute(attIndex).isNumeric()) {
            throw new IllegalArgumentException("Instances: attribute must be numeric to compute kth-smallest value.");
        }
        int j = this.numInstances() - 1;
        int i = 0;
        while (i <= j) {
            if (this.instance(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.instance(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        if (k < 1 || k > j + 1) {
            throw new IllegalArgumentException("Instances: value for k for computing kth-smallest value too large.");
        }
        return this.instance(this.select(attIndex, 0, j, k)).value(attIndex);
    }

    public Instance lastInstance() {
        return (Instance)this.m_Instances.lastElement();
    }

    public double meanOrMode(int attIndex) {
        if (this.attribute(attIndex).isNumeric()) {
            double found = 0.0;
            double result = 0.0;
            for (int j = 0; j < this.numInstances(); ++j) {
                if (this.instance(j).isMissing(attIndex)) continue;
                found += this.instance(j).weight();
                result += this.instance(j).weight() * this.instance(j).value(attIndex);
            }
            if (found <= 0.0) {
                return 0.0;
            }
            return result / found;
        }
        if (this.attribute(attIndex).isNominal()) {
            int[] counts = new int[this.attribute(attIndex).numValues()];
            for (int j = 0; j < this.numInstances(); ++j) {
                if (this.instance(j).isMissing(attIndex)) continue;
                int n = (int)this.instance(j).value(attIndex);
                counts[n] = (int)((double)counts[n] + this.instance(j).weight());
            }
            return Utils.maxIndex(counts);
        }
        return 0.0;
    }

    public double meanOrMode(AttributeWeka att) {
        return this.meanOrMode(att.index());
    }

    public int numAttributes() {
        return this.m_Attributes.size();
    }

    public int numClasses() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (!this.classAttribute().isNominal()) {
            return 1;
        }
        return this.classAttribute().numValues();
    }

    public int numDistinctValues(int attIndex) {
        if (this.attribute(attIndex).isNumeric()) {
            Instance current;
            double[] attVals = this.attributeToDoubleArray(attIndex);
            int[] sorted = Utils.sort(attVals);
            double prev = 0.0;
            int counter = 0;
            for (int i = 0; i < sorted.length && !(current = this.instance(sorted[i])).isMissing(attIndex); ++i) {
                if (i != 0 && !(current.value(attIndex) > prev)) continue;
                prev = current.value(attIndex);
                ++counter;
            }
            return counter;
        }
        return this.attribute(attIndex).numValues();
    }

    public int numDistinctValues(AttributeWeka att) {
        return this.numDistinctValues(att.index());
    }

    public int numInstances() {
        return this.m_Instances.size();
    }

    public void randomize(Randomize random) {
        for (int j = this.numInstances() - 1; j > 0; --j) {
            this.swap(j, Randomize.RandintClosed(0, j));
        }
    }

    public void undoRandomizeAttribute() throws Exception {
        if (this.attIdx4Randomization < 0) {
            throw new Exception("no randomization to undo!");
        }
        if (this.attIdxOrigValues.length != this.numInstances()) {
            throw new Exception("meanwhile number of attributes has changed, can't undo!");
        }
        for (int i = 0; i < this.attIdxOrigValues.length; ++i) {
            Instance instance = (Instance)this.m_Instances.elementAt(i);
            instance.modifyValue(this.attIdx4Randomization, this.attIdxOrigValues[i]);
        }
    }

    public void randomizeAttribute(int attIdx, Randomize random, int rounds) {
        this.attIdx4Randomization = attIdx;
        this.attIdxOrigValues = this.attributeToDoubleArray(attIdx);
        int n = this.numInstances();
        for (int j = 0; j < rounds; ++j) {
            for (int i = 0; i < n; ++i) {
                int r = Randomize.RandintClosed(0, n - 1);
                Instance iOne = (Instance)this.m_Instances.elementAt(i);
                Instance iTwo = (Instance)this.m_Instances.elementAt(r);
                double helper = iOne.value(attIdx);
                iOne.modifyValue(attIdx, iTwo.value(attIdx));
                iTwo.modifyValue(attIdx, helper);
            }
        }
    }

    public String relationName() {
        return this.m_RelationName;
    }

    public void renameAttribute(int att, String name) {
        AttributeWeka newAtt = this.attribute(att).copy(name);
        FastVector newVec = new FastVector(this.numAttributes());
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == att) {
                newVec.addElement(newAtt);
                continue;
            }
            newVec.addElement(this.attribute(i));
        }
        this.m_Attributes = newVec;
    }

    public void renameAttribute(AttributeWeka att, String name) {
        this.renameAttribute(att.index(), name);
    }

    public void renameAttributeValue(int att, int val, String name) {
        AttributeWeka newAtt = (AttributeWeka)this.attribute(att).copy();
        FastVector newVec = new FastVector(this.numAttributes());
        newAtt.setValue(val, name);
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == att) {
                newVec.addElement(newAtt);
                continue;
            }
            newVec.addElement(this.attribute(i));
        }
        this.m_Attributes = newVec;
    }

    public void renameAttributeValue(AttributeWeka att, String val, String name) {
        int v = att.indexOfValue(val);
        if (v == -1) {
            throw new IllegalArgumentException(val + " not found");
        }
        this.renameAttributeValue(att.index(), v, name);
    }

    public Instances resample(Randomize random) {
        Instances newData = new Instances(this, this.numInstances());
        while (newData.numInstances() < this.numInstances()) {
            newData.add(this.instance(Randomize.RandintClosed(0, this.numInstances() - 1)));
        }
        return newData;
    }

    public Instances resampleWithWeights(Randomize random) {
        double[] weights = new double[this.numInstances()];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = this.instance(i).weight();
        }
        return this.resampleWithWeights(random, weights);
    }

    public Instances resampleWithWeights(Randomize random, double[] weights) {
        if (weights.length != this.numInstances()) {
            throw new IllegalArgumentException("weights.length != numInstances.");
        }
        Instances newData = new Instances(this, this.numInstances());
        if (this.numInstances() == 0) {
            return newData;
        }
        double[] probabilities = new double[this.numInstances()];
        double sumProbs = 0.0;
        double sumOfWeights = Utils.sum(weights);
        for (int i = 0; i < this.numInstances(); ++i) {
            probabilities[i] = sumProbs += random.Rand();
        }
        Utils.normalize(probabilities, sumProbs / sumOfWeights);
        probabilities[this.numInstances() - 1] = sumOfWeights;
        int k = 0;
        sumProbs = 0.0;
        for (int l = 0; k < this.numInstances() && l < this.numInstances(); ++l) {
            if (weights[l] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            sumProbs += weights[l];
            while (k < this.numInstances() && probabilities[k] <= sumProbs) {
                newData.add(this.instance(l));
                newData.instance(k).setWeight(1.0);
                ++k;
            }
        }
        return newData;
    }

    public void setClass(AttributeWeka att) {
        this.m_ClassIndex = att.index();
    }

    public void setClassIndex(int classIndex) {
        if (classIndex >= this.numAttributes()) {
            throw new IllegalArgumentException("Invalid class index: " + classIndex);
        }
        this.m_ClassIndex = classIndex;
    }

    public void setRelationName(String newName) {
        this.m_RelationName = newName;
    }

    public void sort(int attIndex) {
        int j = this.numInstances() - 1;
        int i = 0;
        while (i <= j) {
            if (this.instance(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.instance(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        this.quickSort(attIndex, 0, j);
    }

    public void sort(AttributeWeka att) {
        this.sort(att.index());
    }

    public void stratify(int numFolds) {
        if (numFolds <= 0) {
            throw new IllegalArgumentException("Number of folds must be greater than 1");
        }
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (this.classAttribute().isNominal()) {
            for (int index = 1; index < this.numInstances(); ++index) {
                Instance instance1 = this.instance(index - 1);
                for (int j = index; j < this.numInstances(); ++j) {
                    Instance instance2 = this.instance(j);
                    if (instance1.classValue() != instance2.classValue() && (!instance1.classIsMissing() || !instance2.classIsMissing())) continue;
                    this.swap(index, j);
                    ++index;
                }
            }
            this.stratStep(numFolds);
        }
    }

    public double sumOfWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.numInstances(); ++i) {
            sum += this.instance(i).weight();
        }
        return sum;
    }

    public Instances testCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances test = new Instances(this, numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(first, test, numInstForFold);
        return test;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_RELATION).append(" ").append(Utils.quote(this.m_RelationName)).append("\n\n");
        for (int i = 0; i < this.numAttributes(); ++i) {
            text.append(this.attribute(i)).append("\n");
        }
        text.append("\n").append(ARFF_DATA).append("\n");
        text.append(this.stringWithoutHeader());
        return text.toString();
    }

    protected String stringWithoutHeader() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i));
            if (i >= this.numInstances() - 1) continue;
            text.append('\n');
        }
        return text.toString();
    }

    public Instances trainCV(int numFolds, int numFold) {
        int offset;
        if (numFolds < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (numFolds > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int numInstForFold = this.numInstances() / numFolds;
        if (numFold < this.numInstances() % numFolds) {
            ++numInstForFold;
            offset = numFold;
        } else {
            offset = this.numInstances() % numFolds;
        }
        Instances train = new Instances(this, this.numInstances() - numInstForFold);
        int first = numFold * (this.numInstances() / numFolds) + offset;
        this.copyInstances(0, train, first);
        this.copyInstances(first + numInstForFold, train, this.numInstances() - first - numInstForFold);
        return train;
    }

    public Instances trainCV(int numFolds, int numFold, Randomize random) {
        Instances train = this.trainCV(numFolds, numFold);
        train.randomize(random);
        return train;
    }

    public double variance(int attIndex) {
        double sum = 0.0;
        double sumSquared = 0.0;
        double sumOfWeights = 0.0;
        if (!this.attribute(attIndex).isNumeric()) {
            throw new IllegalArgumentException("Can't compute variance because attribute is not numeric!");
        }
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(attIndex)) continue;
            sum += this.instance(i).weight() * this.instance(i).value(attIndex);
            sumSquared += this.instance(i).weight() * this.instance(i).value(attIndex) * this.instance(i).value(attIndex);
            sumOfWeights += this.instance(i).weight();
        }
        if (sumOfWeights <= 1.0) {
            return 0.0;
        }
        double result = (sumSquared - sum * sum / sumOfWeights) / (sumOfWeights - 1.0);
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public double variance(AttributeWeka att) {
        return this.variance(att.index());
    }

    public double[] attributeToDoubleArray(int index) {
        double[] result = new double[this.numInstances()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.instance(i).value(index);
        }
        return result;
    }

    protected void copyInstances(int from, Instances dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.add(this.instance(from + i));
        }
    }

    protected void freshAttributeInfo() {
        this.m_Attributes = (FastVector)this.m_Attributes.copyElements();
    }

    protected String instancesAndWeights() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            text.append(this.instance(i) + " " + this.instance(i).weight());
            if (i >= this.numInstances() - 1) continue;
            text.append("\n");
        }
        return text.toString();
    }

    protected int partition(int attIndex, int l, int r) {
        double pivot = this.instance((l + r) / 2).value(attIndex);
        while (l < r) {
            while (this.instance(l).value(attIndex) < pivot && l < r) {
                ++l;
            }
            while (this.instance(r).value(attIndex) > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            this.swap(l, r);
            ++l;
            --r;
        }
        if (l == r && this.instance(r).value(attIndex) > pivot) {
            --r;
        }
        return r;
    }

    protected void quickSort(int attIndex, int left, int right) {
        if (left < right) {
            int middle = this.partition(attIndex, left, right);
            this.quickSort(attIndex, left, middle);
            this.quickSort(attIndex, middle + 1, right);
        }
    }

    protected int select(int attIndex, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(attIndex, left, right);
        if (middle - left + 1 >= k) {
            return this.select(attIndex, left, middle, k);
        }
        return this.select(attIndex, middle + 1, right, k - (middle - left + 1));
    }

    protected void stratStep(int numFolds) {
        FastVector newVec = new FastVector(this.m_Instances.capacity());
        int start = 0;
        while (newVec.size() < this.numInstances()) {
            for (int j = start; j < this.numInstances(); j += numFolds) {
                newVec.addElement(this.instance(j));
            }
            ++start;
        }
        this.m_Instances = newVec;
    }

    public void swap(int i, int j) {
        this.m_Instances.swap(i, j);
    }

    public static Instances mergeInstances(Instances first, Instances second) {
        int i;
        if (first.numInstances() != second.numInstances()) {
            throw new IllegalArgumentException("Instance sets must be of the same size");
        }
        FastVector newAttributes = new FastVector();
        for (i = 0; i < first.numAttributes(); ++i) {
            newAttributes.addElement(first.attribute(i));
        }
        for (i = 0; i < second.numAttributes(); ++i) {
            newAttributes.addElement(second.attribute(i));
        }
        Instances merged = new Instances(first.relationName() + '_' + second.relationName(), newAttributes, first.numInstances());
        for (int i2 = 0; i2 < first.numInstances(); ++i2) {
            merged.add(first.instance(i2).mergeInstance(second.instance(i2)));
        }
        return merged;
    }
}

