/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO;

import keel.Algorithms.SVM.SMO.core.Instance;
import keel.Algorithms.SVM.SMO.core.Instances;
import keel.Algorithms.SVM.SMO.core.SelectedTag;
import keel.Algorithms.SVM.SMO.core.Tag;
import keel.Algorithms.SVM.SMO.core.TechnicalInformation;
import keel.Algorithms.SVM.SMO.core.TechnicalInformationHandler;
import keel.Algorithms.SVM.SMO.core.WeightedInstancesHandler;
import keel.Algorithms.SVM.SMO.supportVector.Kernel;
import keel.Algorithms.SVM.SMO.supportVector.PolyKernel;
import keel.Algorithms.SVM.SMO.supportVector.SMOset;

public class SMOreg
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 5783729368717679645L;
    protected Kernel m_kernel = new PolyKernel();
    protected int m_classIndex = -1;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected int m_filterType = 0;
    protected boolean m_checksTurnedOff = false;
    protected Instances m_data;
    protected double m_C = 1.0;
    protected double[] m_alpha;
    protected double[] m_alpha_;
    protected double m_b;
    protected double m_bLow;
    protected double m_bUp;
    protected int m_iLow;
    protected int m_iUp;
    protected double[] m_weights;
    protected double[] m_fcache;
    protected SMOset m_I0;
    protected SMOset m_I1;
    protected SMOset m_I2;
    protected SMOset m_I3;
    protected double m_epsilon = 0.001;
    protected double m_tol = 0.001;
    protected double m_eps = 1.0E-12;
    protected static double m_Del = 1.0E-10;
    protected double m_Alin;
    protected double m_Blin;
    protected double[] m_sparseWeights;
    protected int[] m_sparseIndices;
    protected boolean m_KernelIsLinear = false;

    public String globalInfo() {
        return "Implements Alex Smola and Bernhard Scholkopf's sequential minimal optimization algorithm for training a support vector regression model. This implementation globally replaces all missing values and transforms nominal attributes into binary ones. It also normalizes all attributes by default. (Note that the coefficients in the output are based on the normalized/standardized data, not the original data.)\n\nFor more information on the SMO algorithm, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Alex J. Smola and Bernhard Schoelkopf");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "A Tutorial on Support Vector Regression");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "NeuroCOLT2 Technical Report Series");
        result.setValue(TechnicalInformation.Field.NOTE, "NC2-TR-1998-030");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.TECHREPORT);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "S.K. Shevade and S.S. Keerthi and C. Bhattacharyya and K.R.K. Murthy");
        additional.setValue(TechnicalInformation.Field.YEAR, "1999");
        additional.setValue(TechnicalInformation.Field.TITLE, "Improvements to SMO Algorithm for SVM Regression");
        additional.setValue(TechnicalInformation.Field.INSTITUTION, "National University of Singapore");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Control Division Dept of Mechanical and Production Engineering, National University of Singapore");
        additional.setValue(TechnicalInformation.Field.NOTE, "Technical Report CD-99-16");
        return result;
    }

    public void buildClassifier(Instances insts) throws Exception {
        this.m_classIndex = insts.classIndex();
        this.m_data = insts;
        this.m_Alin = 1.0;
        this.m_Blin = 0.0;
        this.m_kernel.buildKernel(this.m_data);
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        this.m_weights = (double[])(this.m_KernelIsLinear ? new double[this.m_data.numAttributes()] : null);
        this.m_fcache = new double[this.m_data.numInstances()];
        this.m_I0 = new SMOset(this.m_data.numInstances());
        this.m_I1 = new SMOset(this.m_data.numInstances());
        this.m_I2 = new SMOset(this.m_data.numInstances());
        this.m_I3 = new SMOset(this.m_data.numInstances());
        this.m_alpha = new double[this.m_data.numInstances()];
        this.m_alpha_ = new double[this.m_data.numInstances()];
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            this.m_I1.insert(i);
        }
        this.m_bUp = this.m_data.instance(0).classValue() + this.m_epsilon;
        this.m_bLow = this.m_data.instance(0).classValue() - this.m_epsilon;
        this.m_iLow = 0;
        this.m_iUp = 0;
        int numChanged = 0;
        boolean examineAll = true;
        while (numChanged > 0 || examineAll) {
            int I;
            numChanged = 0;
            if (examineAll) {
                for (I = 0; I < this.m_alpha.length; ++I) {
                    numChanged += this.examineExample(I);
                }
            } else {
                I = this.m_I0.getNext(-1);
                while (I != -1) {
                    numChanged += this.examineExample(I);
                    if (this.m_bUp > this.m_bLow - 2.0 * this.m_tol) {
                        numChanged = 0;
                        break;
                    }
                    I = this.m_I0.getNext(I);
                }
            }
            if (examineAll) {
                examineAll = false;
                continue;
            }
            if (numChanged != 0) continue;
            examineAll = true;
        }
        this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
        this.m_kernel.clean();
        this.m_fcache = null;
        this.m_I3 = null;
        this.m_I2 = null;
        this.m_I1 = null;
        this.m_I0 = null;
        if (this.m_KernelIsLinear) {
            for (int j = 0; j < this.m_weights.length; ++j) {
                this.m_weights[j] = 0.0;
            }
            for (int k = 0; k < this.m_alpha.length; ++k) {
                for (int j = 0; j < this.m_weights.length; ++j) {
                    if (j == this.m_data.classIndex()) continue;
                    int n = j;
                    this.m_weights[n] = this.m_weights[n] + (this.m_alpha[k] - this.m_alpha_[k]) * this.m_data.instance(k).value(j);
                }
            }
            double[] sparseWeights = new double[this.m_weights.length];
            int[] sparseIndices = new int[this.m_weights.length];
            int counter = 0;
            for (int ii = 0; ii < this.m_weights.length; ++ii) {
                if (this.m_weights[ii] == 0.0) continue;
                sparseWeights[counter] = this.m_weights[ii];
                sparseIndices[counter] = ii;
                ++counter;
            }
            this.m_sparseWeights = new double[counter];
            this.m_sparseIndices = new int[counter];
            System.arraycopy(sparseWeights, 0, this.m_sparseWeights, 0, counter);
            System.arraycopy(sparseIndices, 0, this.m_sparseIndices, 0, counter);
            this.m_data = !this.m_checksTurnedOff ? new Instances(this.m_data, 0) : null;
            this.m_weights = null;
            this.m_alpha = null;
            this.m_alpha_ = null;
        }
    }

    protected int examineExample(int i2) throws Exception {
        double alpha2 = this.m_alpha[i2];
        double alpha2_ = this.m_alpha_[i2];
        double F2 = 0.0;
        if (this.m_I0.contains(i2)) {
            F2 = this.m_fcache[i2];
        } else {
            F2 = this.m_data.instance(i2).classValue();
            for (int j = 0; j < this.m_alpha.length; ++j) {
                F2 -= (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i2, j, this.m_data.instance(i2));
            }
            this.m_fcache[i2] = F2;
            if (this.m_I1.contains(i2)) {
                if (F2 + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = F2 + this.m_epsilon;
                    this.m_iUp = i2;
                } else if (F2 - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = F2 - this.m_epsilon;
                    this.m_iLow = i2;
                }
            } else if (this.m_I2.contains(i2) && F2 + this.m_epsilon > this.m_bLow) {
                this.m_bLow = F2 + this.m_epsilon;
                this.m_iLow = i2;
            } else if (this.m_I3.contains(i2) && F2 - this.m_epsilon < this.m_bUp) {
                this.m_bUp = F2 - this.m_epsilon;
                this.m_iUp = i2;
            }
        }
        boolean optimality = true;
        int i1 = -1;
        if (this.m_I0.contains(i2) && 0.0 < alpha2 && alpha2 < this.m_C * this.m_data.instance(i2).weight()) {
            if (this.m_bLow - (F2 - this.m_epsilon) > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iLow;
                if (F2 - this.m_epsilon - this.m_bUp > this.m_bLow - (F2 - this.m_epsilon)) {
                    i1 = this.m_iUp;
                }
            } else if (F2 - this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iUp;
                if (this.m_bLow - (F2 - this.m_epsilon) > F2 - this.m_epsilon - this.m_bUp) {
                    i1 = this.m_iLow;
                }
            }
        } else if (this.m_I0.contains(i2) && 0.0 < alpha2_ && alpha2_ < this.m_C * this.m_data.instance(i2).weight()) {
            if (this.m_bLow - (F2 + this.m_epsilon) > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iLow;
                if (F2 + this.m_epsilon - this.m_bUp > this.m_bLow - (F2 + this.m_epsilon)) {
                    i1 = this.m_iUp;
                }
            } else if (F2 + this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iUp;
                if (this.m_bLow - (F2 + this.m_epsilon) > F2 + this.m_epsilon - this.m_bUp) {
                    i1 = this.m_iLow;
                }
            }
        } else if (this.m_I1.contains(i2)) {
            if (this.m_bLow - (F2 + this.m_epsilon) > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iLow;
                if (F2 + this.m_epsilon - this.m_bUp > this.m_bLow - (F2 + this.m_epsilon)) {
                    i1 = this.m_iUp;
                }
            } else if (F2 - this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iUp;
                if (this.m_bLow - (F2 - this.m_epsilon) > F2 - this.m_epsilon - this.m_bUp) {
                    i1 = this.m_iLow;
                }
            }
        } else if (this.m_I2.contains(i2)) {
            if (F2 + this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iUp;
            }
        } else if (this.m_I3.contains(i2)) {
            if (this.m_bLow - (F2 - this.m_epsilon) > 2.0 * this.m_tol) {
                optimality = false;
                i1 = this.m_iLow;
            }
        } else {
            throw new RuntimeException("Inconsistent state ! I0, I1, I2 and I3 must cover the whole set of indices.");
        }
        if (optimality) {
            return 0;
        }
        if (this.takeStep(i1, i2)) {
            return 1;
        }
        return 0;
    }

    protected boolean takeStep(int i1, int i2) throws Exception {
        if (i1 == i2) {
            return false;
        }
        double alpha1 = this.m_alpha[i1];
        double alpha1_ = this.m_alpha_[i1];
        double alpha2 = this.m_alpha[i2];
        double alpha2_ = this.m_alpha_[i2];
        double F1 = this.m_fcache[i1];
        double F2 = this.m_fcache[i2];
        double k11 = this.m_kernel.eval(i1, i1, this.m_data.instance(i1));
        double k12 = this.m_kernel.eval(i1, i2, this.m_data.instance(i1));
        double k22 = this.m_kernel.eval(i2, i2, this.m_data.instance(i2));
        double eta = -2.0 * k12 + k11 + k22;
        double gamma = alpha1 - alpha1_ + alpha2 - alpha2_;
        if (eta < 0.0) {
            eta = 0.0;
        }
        boolean case1 = false;
        boolean case2 = false;
        boolean case3 = false;
        boolean case4 = false;
        boolean finished = false;
        double deltaphi = F1 - F2;
        boolean changed = false;
        while (!finished) {
            double a1;
            double Hobj;
            double Lobj;
            double a2;
            double H;
            double L;
            if (!case1 && (alpha1 > 0.0 || alpha1_ == 0.0 && deltaphi > 0.0) && (alpha2 > 0.0 || alpha2_ == 0.0 && deltaphi < 0.0)) {
                L = Math.max(0.0, gamma - this.m_C * this.m_data.instance(i1).weight());
                if (L < (H = Math.min(this.m_C * this.m_data.instance(i2).weight(), gamma))) {
                    if (eta > 0.0) {
                        a2 = alpha2 - deltaphi / eta;
                        if (a2 > H) {
                            a2 = H;
                        } else if (a2 < L) {
                            a2 = L;
                        }
                    } else {
                        Lobj = -L * deltaphi;
                        Hobj = -H * deltaphi;
                        a2 = Lobj > Hobj ? L : H;
                    }
                    a1 = alpha1 - (a2 - alpha2);
                    if (Math.abs(a1 - alpha1) > this.m_eps || Math.abs(a2 - alpha2) > this.m_eps) {
                        alpha1 = a1;
                        alpha2 = a2;
                        changed = true;
                    }
                } else {
                    finished = true;
                }
                case1 = true;
            } else if (!case2 && (alpha1 > 0.0 || alpha1_ == 0.0 && deltaphi > 2.0 * this.m_epsilon) && (alpha2_ > 0.0 || alpha2 == 0.0 && deltaphi > 2.0 * this.m_epsilon)) {
                L = Math.max(0.0, -gamma);
                if (L < (H = Math.min(this.m_C * this.m_data.instance(i2).weight(), -gamma + this.m_C * this.m_data.instance(i1).weight()))) {
                    if (eta > 0.0) {
                        a2 = alpha2_ + (deltaphi - 2.0 * this.m_epsilon) / eta;
                        if (a2 > H) {
                            a2 = H;
                        } else if (a2 < L) {
                            a2 = L;
                        }
                    } else {
                        Lobj = L * (-2.0 * this.m_epsilon + deltaphi);
                        Hobj = H * (-2.0 * this.m_epsilon + deltaphi);
                        a2 = Lobj > Hobj ? L : H;
                    }
                    a1 = alpha1 + (a2 - alpha2_);
                    if (Math.abs(a1 - alpha1) > this.m_eps || Math.abs(a2 - alpha2_) > this.m_eps) {
                        alpha1 = a1;
                        alpha2_ = a2;
                        changed = true;
                    }
                } else {
                    finished = true;
                }
                case2 = true;
            } else if (!case3 && (alpha1_ > 0.0 || alpha1 == 0.0 && deltaphi < -2.0 * this.m_epsilon) && (alpha2 > 0.0 || alpha2_ == 0.0 && deltaphi < -2.0 * this.m_epsilon)) {
                L = Math.max(0.0, gamma);
                if (L < (H = Math.min(this.m_C * this.m_data.instance(i2).weight(), this.m_C * this.m_data.instance(i1).weight() + gamma))) {
                    if (eta > 0.0) {
                        a2 = alpha2 - (deltaphi + 2.0 * this.m_epsilon) / eta;
                        if (a2 > H) {
                            a2 = H;
                        } else if (a2 < L) {
                            a2 = L;
                        }
                    } else {
                        Lobj = -L * (2.0 * this.m_epsilon + deltaphi);
                        Hobj = -H * (2.0 * this.m_epsilon + deltaphi);
                        a2 = Lobj > Hobj ? L : H;
                    }
                    a1 = alpha1_ + (a2 - alpha2);
                    if (Math.abs(a1 - alpha1_) > this.m_eps || Math.abs(a2 - alpha2) > this.m_eps) {
                        alpha1_ = a1;
                        alpha2 = a2;
                        changed = true;
                    }
                } else {
                    finished = true;
                }
                case3 = true;
            } else if (!case4 && (alpha1_ > 0.0 || alpha1 == 0.0 && deltaphi < 0.0) && (alpha2_ > 0.0 || alpha2 == 0.0 && deltaphi > 0.0)) {
                L = Math.max(0.0, -gamma - this.m_C * this.m_data.instance(i1).weight());
                if (L < (H = Math.min(this.m_C * this.m_data.instance(i2).weight(), -gamma))) {
                    if (eta > 0.0) {
                        a2 = alpha2_ + deltaphi / eta;
                        if (a2 > H) {
                            a2 = H;
                        } else if (a2 < L) {
                            a2 = L;
                        }
                    } else {
                        Lobj = L * deltaphi;
                        Hobj = H * deltaphi;
                        a2 = Lobj > Hobj ? L : H;
                    }
                    a1 = alpha1_ - (a2 - alpha2_);
                    if (Math.abs(a1 - alpha1_) > this.m_eps || Math.abs(a2 - alpha2_) > this.m_eps) {
                        alpha1_ = a1;
                        alpha2_ = a2;
                        changed = true;
                    }
                } else {
                    finished = true;
                }
                case4 = true;
            } else {
                finished = true;
            }
            deltaphi += eta * (alpha2 - alpha2_ - (this.m_alpha[i2] - this.m_alpha_[i2]));
        }
        if (changed) {
            int i = this.m_I0.getNext(-1);
            while (i != -1) {
                if (i != i1 && i != i2) {
                    int n = i;
                    this.m_fcache[n] = this.m_fcache[n] + ((this.m_alpha[i1] - this.m_alpha_[i1] - (alpha1 - alpha1_)) * this.m_kernel.eval(i1, i, this.m_data.instance(i1)) + (this.m_alpha[i2] - this.m_alpha_[i2] - (alpha2 - alpha2_)) * this.m_kernel.eval(i2, i, this.m_data.instance(i2)));
                }
                i = this.m_I0.getNext(i);
            }
            int n = i1;
            this.m_fcache[n] = this.m_fcache[n] + ((this.m_alpha[i1] - this.m_alpha_[i1] - (alpha1 - alpha1_)) * k11 + (this.m_alpha[i2] - this.m_alpha_[i2] - (alpha2 - alpha2_)) * k12);
            int n2 = i2;
            this.m_fcache[n2] = this.m_fcache[n2] + ((this.m_alpha[i1] - this.m_alpha_[i1] - (alpha1 - alpha1_)) * k12 + (this.m_alpha[i2] - this.m_alpha_[i2] - (alpha2 - alpha2_)) * k22);
            if (alpha1 > this.m_C * this.m_data.instance(i1).weight() - m_Del * this.m_C * this.m_data.instance(i1).weight()) {
                alpha1 = this.m_C * this.m_data.instance(i1).weight();
            } else if (alpha1 <= m_Del * this.m_C * this.m_data.instance(i1).weight()) {
                alpha1 = 0.0;
            }
            if (alpha1_ > this.m_C * this.m_data.instance(i1).weight() - m_Del * this.m_C * this.m_data.instance(i1).weight()) {
                alpha1_ = this.m_C * this.m_data.instance(i1).weight();
            } else if (alpha1_ <= m_Del * this.m_C * this.m_data.instance(i1).weight()) {
                alpha1_ = 0.0;
            }
            if (alpha2 > this.m_C * this.m_data.instance(i2).weight() - m_Del * this.m_C * this.m_data.instance(i2).weight()) {
                alpha2 = this.m_C * this.m_data.instance(i2).weight();
            } else if (alpha2 <= m_Del * this.m_C * this.m_data.instance(i2).weight()) {
                alpha2 = 0.0;
            }
            if (alpha2_ > this.m_C * this.m_data.instance(i2).weight() - m_Del * this.m_C * this.m_data.instance(i2).weight()) {
                alpha2_ = this.m_C * this.m_data.instance(i2).weight();
            } else if (alpha2_ <= m_Del * this.m_C * this.m_data.instance(i2).weight()) {
                alpha2_ = 0.0;
            }
            this.m_alpha[i1] = alpha1;
            this.m_alpha_[i1] = alpha1_;
            this.m_alpha[i2] = alpha2;
            this.m_alpha_[i2] = alpha2_;
            if (0.0 < alpha1 && alpha1 < this.m_C * this.m_data.instance(i1).weight() || 0.0 < alpha1_ && alpha1_ < this.m_C * this.m_data.instance(i1).weight()) {
                this.m_I0.insert(i1);
            } else {
                this.m_I0.delete(i1);
            }
            if (alpha1 == 0.0 && alpha1_ == 0.0) {
                this.m_I1.insert(i1);
            } else {
                this.m_I1.delete(i1);
            }
            if (alpha1 == 0.0 && alpha1_ == this.m_C * this.m_data.instance(i1).weight()) {
                this.m_I2.insert(i1);
            } else {
                this.m_I2.delete(i1);
            }
            if (alpha1 == this.m_C * this.m_data.instance(i1).weight() && alpha1_ == 0.0) {
                this.m_I3.insert(i1);
            } else {
                this.m_I3.delete(i1);
            }
            if (0.0 < alpha2 && alpha2 < this.m_C * this.m_data.instance(i2).weight() || 0.0 < alpha2_ && alpha2_ < this.m_C * this.m_data.instance(i2).weight()) {
                this.m_I0.insert(i2);
            } else {
                this.m_I0.delete(i2);
            }
            if (alpha2 == 0.0 && alpha2_ == 0.0) {
                this.m_I1.insert(i2);
            } else {
                this.m_I1.delete(i2);
            }
            if (alpha2 == 0.0 && alpha2_ == this.m_C * this.m_data.instance(i2).weight()) {
                this.m_I2.insert(i2);
            } else {
                this.m_I2.delete(i2);
            }
            if (alpha2 == this.m_C * this.m_data.instance(i2).weight() && alpha2_ == 0.0) {
                this.m_I3.insert(i2);
            } else {
                this.m_I3.delete(i2);
            }
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            i = this.m_I0.getNext(-1);
            while (i != -1) {
                if (0.0 < this.m_alpha_[i] && this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight() && this.m_fcache[i] + this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[i] + this.m_epsilon;
                    this.m_iLow = i;
                } else if (0.0 < this.m_alpha[i] && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight() && this.m_fcache[i] - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[i] - this.m_epsilon;
                    this.m_iLow = i;
                }
                if (0.0 < this.m_alpha[i] && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight() && this.m_fcache[i] - this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[i] - this.m_epsilon;
                    this.m_iUp = i;
                } else if (0.0 < this.m_alpha_[i] && this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight() && this.m_fcache[i] + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[i] + this.m_epsilon;
                    this.m_iUp = i;
                }
                i = this.m_I0.getNext(i);
            }
            if (!this.m_I0.contains(i1)) {
                if (this.m_I2.contains(i1) && this.m_fcache[i1] + this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[i1] + this.m_epsilon;
                    this.m_iLow = i1;
                } else if (this.m_I1.contains(i1) && this.m_fcache[i1] - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[i1] - this.m_epsilon;
                    this.m_iLow = i1;
                }
                if (this.m_I3.contains(i1) && this.m_fcache[i1] - this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[i1] - this.m_epsilon;
                    this.m_iUp = i1;
                } else if (this.m_I1.contains(i1) && this.m_fcache[i1] + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[i1] + this.m_epsilon;
                    this.m_iUp = i1;
                }
            }
            if (!this.m_I0.contains(i2)) {
                if (this.m_I2.contains(i2) && this.m_fcache[i2] + this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[i2] + this.m_epsilon;
                    this.m_iLow = i2;
                } else if (this.m_I1.contains(i2) && this.m_fcache[i2] - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[i2] - this.m_epsilon;
                    this.m_iLow = i2;
                }
                if (this.m_I3.contains(i2) && this.m_fcache[i2] - this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[i2] - this.m_epsilon;
                    this.m_iUp = i2;
                } else if (this.m_I1.contains(i2) && this.m_fcache[i2] + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[i2] + this.m_epsilon;
                    this.m_iUp = i2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new RuntimeException("Fatal error! The program failled to initialize i_Low, iUp.");
            }
            return true;
        }
        return false;
    }

    public double classifyInstance(Instance inst) throws Exception {
        double result = this.m_b;
        if (this.m_KernelIsLinear) {
            if (this.m_sparseWeights == null) {
                int n1 = inst.numValues();
                for (int p = 0; p < n1; ++p) {
                    if (inst.index(p) == this.m_classIndex) continue;
                    result += this.m_weights[inst.index(p)] * inst.valueSparse(p);
                }
            } else {
                int n1 = inst.numValues();
                int n2 = this.m_sparseWeights.length;
                int p1 = 0;
                int p2 = 0;
                while (p1 < n1 && p2 < n2) {
                    int ind2;
                    int ind1 = inst.index(p1);
                    if (ind1 == (ind2 = this.m_sparseIndices[p2])) {
                        if (ind1 != this.m_classIndex) {
                            result += inst.valueSparse(p1) * this.m_sparseWeights[p2];
                        }
                        ++p1;
                        ++p2;
                        continue;
                    }
                    if (ind1 > ind2) {
                        ++p2;
                        continue;
                    }
                    ++p1;
                }
            }
        } else {
            for (int i = 0; i < this.m_alpha.length; ++i) {
                result += (this.m_alpha[i] - this.m_alpha_[i]) * this.m_kernel.eval(-1, i, inst);
            }
        }
        return (result - this.m_Blin) / this.m_Alin;
    }

    public void setChecksTurnedOff(boolean value) {
        if (value) {
            this.turnChecksOff();
        } else {
            this.turnChecksOn();
        }
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String cTipText() {
        return "The complexity parameter C.";
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double v) {
        this.m_C = v;
    }

    public String toleranceParameterTipText() {
        return "The tolerance parameter (shouldn't be changed).";
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double v) {
        this.m_tol = v;
    }

    public String epsTipText() {
        return "The epsilon for round-off error (shouldn't be changed).";
    }

    public double getEps() {
        return this.m_eps;
    }

    public void setEps(double v) {
        this.m_eps = v;
    }

    public String epsilonTipText() {
        return "The amount up to which deviations are tolerated. Watch out, the value of epsilon is used with the (normalized/standardized) data.";
    }

    public double getEpsilon() {
        return this.m_epsilon;
    }

    public void setEpsilon(double v) {
        this.m_epsilon = v;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    protected double objFun() throws Exception {
        double res = 0.0;
        double t = 0.0;
        double t2 = 0.0;
        for (int i = 0; i < this.m_alpha.length; ++i) {
            for (int j = 0; j < this.m_alpha.length; ++j) {
                t += (this.m_alpha[i] - this.m_alpha_[i]) * (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            t2 += this.m_data.instance(i).classValue() * (this.m_alpha[i] - this.m_alpha_[i]) - this.m_epsilon * (this.m_alpha[i] + this.m_alpha_[i]);
        }
        return res += -0.5 * t + t2;
    }

    protected double objFun(int i1, int i2, double alpha1, double alpha1_, double alpha2, double alpha2_) throws Exception {
        double res = 0.0;
        double t = 0.0;
        double t2 = 0.0;
        for (int i = 0; i < this.m_alpha.length; ++i) {
            double alphai_;
            double alphai;
            if (i == i1) {
                alphai = alpha1;
                alphai_ = alpha1_;
            } else if (i == i2) {
                alphai = alpha2;
                alphai_ = alpha2_;
            } else {
                alphai = this.m_alpha[i];
                alphai_ = this.m_alpha_[i];
            }
            for (int j = 0; j < this.m_alpha.length; ++j) {
                double alphaj_;
                double alphaj;
                if (j == i1) {
                    alphaj = alpha1;
                    alphaj_ = alpha1_;
                } else if (j == i2) {
                    alphaj = alpha2;
                    alphaj_ = alpha2_;
                } else {
                    alphaj = this.m_alpha[j];
                    alphaj_ = this.m_alpha_[j];
                }
                t += (alphai - alphai_) * (alphaj - alphaj_) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            t2 += this.m_data.instance(i).classValue() * (alphai - alphai_) - this.m_epsilon * (alphai + alphai_);
        }
        return res += -0.5 * t + t2;
    }

    protected void checkSets() throws Exception {
        boolean[] test = new boolean[this.m_data.numInstances()];
        int i = this.m_I0.getNext(-1);
        while (i != -1) {
            if (test[i]) {
                throw new Exception("Fatal error! indice " + i + " appears in two different sets.");
            }
            test[i] = true;
            if (!(0.0 < this.m_alpha[i] && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight() || 0.0 < this.m_alpha_[i] && this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight())) {
                throw new Exception("Warning! I0 contains an incorrect indice.");
            }
            i = this.m_I0.getNext(i);
        }
        i = this.m_I1.getNext(-1);
        while (i != -1) {
            if (test[i]) {
                throw new Exception("Fatal error! indice " + i + " appears in two different sets.");
            }
            test[i] = true;
            if (this.m_alpha[i] != 0.0 || this.m_alpha_[i] != 0.0) {
                throw new Exception("Fatal error! I1 contains an incorrect indice.");
            }
            i = this.m_I1.getNext(i);
        }
        i = this.m_I2.getNext(-1);
        while (i != -1) {
            if (test[i]) {
                throw new Exception("Fatal error! indice " + i + " appears in two different sets.");
            }
            test[i] = true;
            if (this.m_alpha[i] != 0.0 || this.m_alpha_[i] != this.m_C * this.m_data.instance(i).weight()) {
                throw new Exception("Fatal error! I2 contains an incorrect indice.");
            }
            i = this.m_I2.getNext(i);
        }
        i = this.m_I3.getNext(-1);
        while (i != -1) {
            if (test[i]) {
                throw new Exception("Fatal error! indice " + i + " appears in two different sets.");
            }
            test[i] = true;
            if (this.m_alpha_[i] != 0.0 || this.m_alpha[i] != this.m_C * this.m_data.instance(i).weight()) {
                throw new Exception("Fatal error! I3 contains an incorrect indice.");
            }
            i = this.m_I3.getNext(i);
        }
        for (i = 0; i < test.length; ++i) {
            if (test[i]) continue;
            throw new Exception("Fatal error! indice " + i + " doesn't belong to any set.");
        }
    }

    protected void checkAlphas() throws Exception {
        double sum = 0.0;
        for (int i = 0; i < this.m_alpha.length; ++i) {
            if (0.0 != this.m_alpha[i] && this.m_alpha_[i] != 0.0) {
                throw new Exception("Fatal error! Inconsistent alphas!");
            }
            sum += this.m_alpha[i] - this.m_alpha_[i];
        }
        if (sum > 1.0E-10) {
            throw new Exception("Fatal error! Inconsistent alphas' sum = " + sum);
        }
    }

    protected void displayStat(int i1, int i2) throws Exception {
        System.err.println("\n-------- Status : ---------");
        System.err.println("\n i, alpha, alpha'\n");
        for (int i = 0; i < this.m_alpha.length; ++i) {
            double result = (this.m_bLow + this.m_bUp) / 2.0;
            for (int j = 0; j < this.m_alpha.length; ++j) {
                result += (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            System.err.print(" " + i + ":  (" + this.m_alpha[i] + ", " + this.m_alpha_[i] + "),       " + (this.m_data.instance(i).classValue() - this.m_epsilon) + " <= " + result + " <= " + (this.m_data.instance(i).classValue() + this.m_epsilon));
            if (i == i1) {
                System.err.print(" <-- i1");
            }
            if (i == i2) {
                System.err.print(" <-- i2");
            }
            System.err.println();
        }
        System.err.println("bLow = " + this.m_bLow + "  bUp = " + this.m_bUp);
        System.err.println("---------------------------\n");
    }

    protected void displayB() throws Exception {
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            double Fi = this.m_data.instance(i).classValue();
            for (int j = 0; j < this.m_alpha.length; ++j) {
                Fi -= (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            System.err.print("(" + this.m_alpha[i] + ", " + this.m_alpha_[i] + ") : ");
            System.err.print(Fi - this.m_epsilon + ",  " + (Fi + this.m_epsilon));
            double fim = Fi - this.m_epsilon;
            double fip = Fi + this.m_epsilon;
            String s = "";
            if (this.m_I0.contains(i)) {
                if (0.0 < this.m_alpha[i] && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight()) {
                    s = s + "(in I0a) bUp = min(bUp, " + fim + ")   bLow = max(bLow, " + fim + ")";
                }
                if (0.0 < this.m_alpha_[i] && this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight()) {
                    s = s + "(in I0a) bUp = min(bUp, " + fip + ")   bLow = max(bLow, " + fip + ")";
                }
            }
            if (this.m_I1.contains(i)) {
                s = s + "(in I1) bUp = min(bUp, " + fip + ")   bLow = max(bLow, " + fim + ")";
            }
            if (this.m_I2.contains(i)) {
                s = s + "(in I2) bLow = max(bLow, " + fip + ")";
            }
            if (this.m_I3.contains(i)) {
                s = s + "(in I3) bUp = min(bUp, " + fim + ")";
            }
            System.err.println(" " + s + " {" + (this.m_alpha[i] - 1.0) + ", " + (this.m_alpha_[i] - 1.0) + "}");
        }
        System.err.println("\n\n");
    }

    protected void checkOptimality() throws Exception {
        double bUp = Double.POSITIVE_INFINITY;
        double bLow = Double.NEGATIVE_INFINITY;
        int iUp = -1;
        int iLow = -1;
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            double Fi = this.m_data.instance(i).classValue();
            for (int j = 0; j < this.m_alpha.length; ++j) {
                Fi -= (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            double fitilde = 0.0;
            double fibarre = 0.0;
            if (this.m_I0.contains(i) && 0.0 < this.m_alpha[i] && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight()) {
                fitilde = Fi - this.m_epsilon;
                fibarre = Fi - this.m_epsilon;
            }
            if (this.m_I0.contains(i) && 0.0 < this.m_alpha_[i] && this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight()) {
                fitilde = Fi + this.m_epsilon;
                fibarre = Fi + this.m_epsilon;
            }
            if (this.m_I1.contains(i)) {
                fitilde = Fi - this.m_epsilon;
                fibarre = Fi + this.m_epsilon;
            }
            if (this.m_I2.contains(i)) {
                fitilde = Fi + this.m_epsilon;
                fibarre = Double.POSITIVE_INFINITY;
            }
            if (this.m_I3.contains(i)) {
                fitilde = Double.NEGATIVE_INFINITY;
                fibarre = Fi - this.m_epsilon;
            }
            if (fibarre < bUp) {
                bUp = fibarre;
                iUp = i;
            }
            if (!(fitilde > bLow)) continue;
            bLow = fitilde;
            iLow = i;
        }
        if (!(bLow <= bUp + 2.0 * this.m_tol)) {
            System.err.println("Warning! Optimality not reached : inequation (6) doesn't hold!");
        }
        boolean noPb = true;
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            double Fi = this.m_data.instance(i).classValue();
            for (int j = 0; j < this.m_alpha.length; ++j) {
                Fi -= (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            double Ei = Fi - (this.m_bUp + this.m_bLow) / 2.0;
            if (this.m_alpha[i] > 0.0 && !(Ei >= this.m_epsilon - this.m_tol)) {
                System.err.println("Warning! Optimality not reached : inequation (8a) doesn't hold for " + i);
                noPb = false;
            }
            if (this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight() && !(Ei <= this.m_epsilon + this.m_tol)) {
                System.err.println("Warning! Optimality not reached : inequation (8b) doesn't hold for " + i);
                noPb = false;
            }
            if (this.m_alpha_[i] > 0.0 && !(Ei <= -this.m_epsilon + this.m_tol)) {
                System.err.println("Warning! Optimality not reached : inequation (8c) doesn't hold for " + i);
                noPb = false;
            }
            if (!(this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight()) || Ei >= -this.m_epsilon - this.m_tol) continue;
            System.err.println("Warning! Optimality not reached : inequation (8d) doesn't hold for " + i);
            noPb = false;
        }
        if (!noPb) {
            System.err.println();
        }
    }
}

