/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.ISystem;
import net.sourceforge.jclec.base.DecoratedMutator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class RepeatMutator
extends DecoratedMutator {
    private static final long serialVersionUID = 7926409688402274090L;
    protected int numberOfRepetitions;

    public RepeatMutator() {
    }

    public RepeatMutator(ISystem system) {
        super(system);
    }

    public final int getNumberOfRepetitions() {
        return this.numberOfRepetitions;
    }

    public final void setNumberOfRepetitions(int numberOfRepetitions) {
        this.numberOfRepetitions = numberOfRepetitions;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        int numberOfRepetitions = settings.getInt("number-of-repetitions");
        this.setNumberOfRepetitions(numberOfRepetitions);
    }

    @Override
    public List<IIndividual> mutate(List<IIndividual> parents) {
        ArrayList<IIndividual> result = new ArrayList<IIndividual>();
        int i = 0;
        while (i < this.numberOfRepetitions) {
            result.addAll(this.decorated.mutate(parents));
            ++i;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof RepeatMutator) {
            RepeatMutator o = (RepeatMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.decorated, o.decorated);
            eb.append(this.numberOfRepetitions, o.numberOfRepetitions);
            return eb.isEquals();
        }
        return false;
    }
}

