/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropMixed
extends Propagator<Variable> {
    RealVar x;
    IntVar y;

    public PropMixed(RealVar x, IntVar y) {
        super(new Variable[]{x, y}, (Priority)PropagatorPriority.BINARY, false);
        this.x = x;
        this.y = y;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.y.updateLowerBound((int)Math.ceil(this.x.getLB()), this);
        this.y.updateUpperBound((int)Math.floor(this.x.getUB()), this);
        this.x.intersect(this.y.getLB(), this.y.getUB(), this);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval((double)this.y.getLB() <= this.x.getUB() && this.x.getLB() <= (double)this.y.getUB());
        }
        return ESat.UNDEFINED;
    }
}

