/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.search;

import java.util.ArrayList;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.restopt.RestoptProblem;
import org.restopt.search.AbstractRestoptSearchStrategy;

public class OrderedRestorableAreaStrategy
extends AbstractRestoptSearchStrategy {
    boolean increasingOrder;
    boolean UB;

    public OrderedRestorableAreaStrategy(RestoptProblem problem, boolean increasingOrder, boolean UB) {
        super(problem);
        this.increasingOrder = increasingOrder;
        this.UB = UB;
    }

    @Override
    public void setSearch() {
        int[] pus = this.problem.getAvailablePlanningUnits();
        ArrayList<Integer> a2 = new ArrayList<Integer>();
        for (int i2 = 0; i2 < pus.length; ++i2) {
            a2.add(i2);
        }
        a2.sort((i, j) -> {
            int jr;
            int ir;
            if (this.problem.hasRestorableAreaConstraint()) {
                ir = this.problem.getRestorableAreaConstraint().getMinArea(pus[i]);
                jr = this.problem.getRestorableAreaConstraint().getMinArea(pus[j]);
            } else {
                ir = this.problem.getRestorableArea(pus[i]);
                jr = this.problem.getRestorableArea(pus[j]);
            }
            if (this.increasingOrder) {
                return ir - jr;
            }
            return jr - ir;
        });
        IntVar[] boolVars = new BoolVar[pus.length];
        for (int i3 = 0; i3 < a2.size(); ++i3) {
            boolVars[i3] = this.problem.getModel().setBoolView(this.problem.getRestoreSetVar(), pus[(Integer)a2.get(i3)]);
        }
        if (this.UB) {
            this.problem.getModel().getSolver().setSearch(Search.inputOrderUBSearch(boolVars));
        } else {
            this.problem.getModel().getSolver().setSearch(Search.inputOrderLBSearch(boolVars));
        }
    }
}

