/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TipBranchRateModel
extends AbstractBranchRateModel {
    public static final String TIP_BRANCH_RATE_MODEL = "tipBranchRateModel";
    public static final String EXTERNAL_RATE = "externalRate";
    public static final String INTERNAL_RATE = "internalRate";
    private Parameter internalRateParameter;
    private Parameter externalRateParameter;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("externalRate", Parameter.class, "The molecular evolutionary rate parameter for external branches", false), new ElementRule("internalRate", Parameter.class, "The molecular evolutionary rate parameter for internal branches", false)};

        @Override
        public String getParserName() {
            return TipBranchRateModel.TIP_BRANCH_RATE_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(TipBranchRateModel.EXTERNAL_RATE);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(TipBranchRateModel.INTERNAL_RATE);
            TipBranchRateModel tipBranchRateModel = new TipBranchRateModel(parameter, parameter2);
            System.out.println("Using tip branch rate model.");
            return tipBranchRateModel;
        }

        @Override
        public String getParserDescription() {
            return "This element returns a branch rate model that has a different rate for external branches than internal.";
        }

        @Override
        public Class getReturnType() {
            return TipBranchRateModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TipBranchRateModel(Parameter parameter, Parameter parameter2) {
        super(TIP_BRANCH_RATE_MODEL);
        this.internalRateParameter = parameter2;
        this.addVariable(parameter2);
        this.externalRateParameter = parameter;
        this.addVariable(parameter);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double getBranchRate(Tree tree, NodeRef nodeRef) {
        if (tree.isExternal(nodeRef)) {
            return this.externalRateParameter.getParameterValue(0);
        }
        return this.internalRateParameter.getParameterValue(0);
    }
}

