/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treelikelihood.SaddlePointExpansion;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.math.distributions.GammaDistribution;
import dr.xml.Reportable;

public class ApproximatePoissonTreeLikelihood
extends AbstractModelLikelihood
implements Reportable {
    private final TreeModel treeModel;
    private final BranchRateModel branchRateModel;
    private final int sequenceLength;
    private final double[] branchLengths;
    private final GammaDistribution gamma;
    protected boolean[] updateNode;
    private double logLikelihood;
    private double storedLogLikelihood;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown = false;
    private double[] branchLogL;
    private double[] storedBranchLogL;

    public ApproximatePoissonTreeLikelihood(String string, Tree tree, int n, TreeModel treeModel, BranchRateModel branchRateModel) {
        super(string);
        this.sequenceLength = n;
        this.treeModel = treeModel;
        this.addModel(treeModel);
        this.branchRateModel = branchRateModel;
        this.addModel(branchRateModel);
        this.updateNode = new boolean[treeModel.getNodeCount()];
        this.branchLengths = new double[treeModel.getNodeCount()];
        for (int i = 0; i < treeModel.getNodeCount(); ++i) {
            this.updateNode[i] = true;
            if (tree.isRoot(tree.getNode(i))) continue;
            double d = tree.getBranchLength(tree.getNode(i)) * (double)n;
            this.branchLengths[i] = Math.round(d);
        }
        this.branchLogL = new double[treeModel.getNodeCount()];
        this.storedBranchLogL = new double[treeModel.getNodeCount()];
        this.likelihoodKnown = false;
        this.gamma = new GammaDistribution(1.0, 1.0);
    }

    protected void updateNode(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndChildren(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNode[nodeRef2.getNumber()] = true;
        }
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndDescendents(NodeRef nodeRef) {
        this.updateNode[nodeRef.getNumber()] = true;
        for (int i = 0; i < this.treeModel.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.treeModel.getChild(nodeRef, i);
            this.updateNodeAndDescendents(nodeRef2);
        }
        this.likelihoodKnown = false;
    }

    protected void updateAllNodes() {
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            this.updateNode[i] = true;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                } else if (((TreeChangedEvent)object).isTreeChanged()) {
                    this.updateAllNodes();
                }
            }
        } else if (model == this.branchRateModel) {
            if (n == -1) {
                this.updateAllNodes();
            } else {
                this.updateNode(this.treeModel.getNode(n));
            }
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        System.arraycopy(this.branchLogL, 0, this.storedBranchLogL, 0, this.branchLogL.length);
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        System.arraycopy(this.storedBranchLogL, 0, this.branchLogL, 0, this.branchLogL.length);
    }

    @Override
    protected void acceptState() {
    }

    private double calculateLogLikelihood() {
        int n = this.treeModel.getRoot().getNumber();
        int n2 = this.treeModel.getChild(this.treeModel.getRoot(), 0).getNumber();
        int n3 = this.treeModel.getChild(this.treeModel.getRoot(), 1).getNumber();
        this.updateNode[n2] = this.updateNode[n2] || this.updateNode[n3];
        double d = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            if (this.updateNode[i] && i != n && i != n3) {
                NodeRef nodeRef = this.treeModel.getNode(i);
                double d2 = this.treeModel.getBranchLength(nodeRef) * this.branchRateModel.getBranchRate(this.treeModel, nodeRef);
                double d3 = this.branchLengths[i];
                if (i == n2) {
                    NodeRef nodeRef2 = this.treeModel.getNode(n3);
                    d2 += this.treeModel.getBranchLength(nodeRef2) * this.branchRateModel.getBranchRate(this.treeModel, nodeRef2);
                    d3 += this.branchLengths[n3];
                }
                double d4 = d2 * (double)this.sequenceLength;
                this.branchLogL[i] = SaddlePointExpansion.logBinomialProbability((int)d3, this.sequenceLength, d2, 1.0 - d2);
            }
            this.updateNode[i] = false;
            d += this.branchLogL[i];
        }
        return d;
    }

    private void calculateLogLikelihood(NodeRef nodeRef) {
        NodeRef nodeRef2;
        NodeRef nodeRef3 = this.treeModel.getChild(nodeRef, 0);
        if (!this.treeModel.isExternal(nodeRef3)) {
            this.calculateLogLikelihood(nodeRef3);
        }
        if (!this.treeModel.isExternal(nodeRef2 = this.treeModel.getChild(nodeRef, 1))) {
            this.calculateLogLikelihood(nodeRef2);
        }
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.updateAllNodes();
    }

    @Override
    public String getReport() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }
}

