/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.distribution.LatentFactorModelInterface;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.Matrix;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class LatentFactorModel
extends AbstractModelLikelihood
implements Citable,
LatentFactorModelInterface {
    private final MatrixParameterInterface data;
    private final MatrixParameterInterface factors;
    private final MatrixParameterInterface loadings;
    private MatrixParameterInterface sData;
    private final DiagonalMatrix rowPrecision;
    private final DiagonalMatrix colPrecision;
    private final Parameter continuous;
    private final boolean scaleData;
    private final int dimFactors;
    private final int dimData;
    private final int nTaxa;
    private boolean newModel;
    private boolean likelihoodKnown = false;
    private boolean isDataScaled = false;
    private boolean storedLikelihoodKnown;
    private boolean residualKnown = false;
    private boolean dataKnown = false;
    private boolean storedDataKnown;
    private boolean LxFKnown = false;
    private boolean storedResidualKnown = false;
    private boolean storedLxFKnown;
    private boolean traceKnown = false;
    private boolean storedTraceKnown;
    private boolean logDetColKnown = false;
    private boolean storedLogDetColKnown;
    private double trace;
    private double storedTrace;
    private double logLikelihood;
    private double storedLogLikelihood;
    private double logDetCol;
    private double storedLogDetCol;
    private boolean[][] changed;
    private boolean[][] storedChanged;
    private boolean RecomputeResiduals;
    private boolean RecomputeFactors;
    private boolean RecomputeLoadings;
    private Vector<Integer> changedValues;
    private Vector<Integer> storedChangedValues;
    private boolean factorsKnown = false;
    private boolean storedFactorsKnown = false;
    private boolean loadingsKnown = false;
    private boolean storedLoadingsKnown = false;
    private boolean totalRecompute = true;
    private boolean storedTotalRecompute = false;
    private double[] residual;
    private double[] LxF;
    private double[] storedResidual;
    private double[] storedLxF;
    private double pathParameter = 1.0;
    private final Parameter missingIndicator;
    private final int[] rowCount;
    private final int nmeasurements;

    public LatentFactorModel(MatrixParameterInterface matrixParameterInterface, MatrixParameterInterface matrixParameterInterface2, MatrixParameterInterface matrixParameterInterface3, DiagonalMatrix diagonalMatrix, DiagonalMatrix diagonalMatrix2, Parameter parameter, boolean bl, Parameter parameter2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super("");
        int n;
        int n2;
        int n3;
        this.RecomputeResiduals = bl3;
        this.RecomputeFactors = bl4;
        this.RecomputeLoadings = bl5;
        this.changedValues = new Vector();
        for (n3 = 0; n3 < matrixParameterInterface.getDimension(); ++n3) {
            this.changedValues.add(n3);
        }
        this.storedChangedValues = new Vector();
        this.newModel = bl2;
        this.scaleData = bl;
        this.data = matrixParameterInterface;
        this.factors = matrixParameterInterface2;
        if (matrixParameterInterface2 instanceof MatrixParameter) {
            for (n3 = 0; n3 < matrixParameterInterface2.getColumnDimension(); ++n3) {
                Parameter parameter3 = matrixParameterInterface2.getParameter(n3);
                System.err.println(parameter3.getId() + " " + parameter3.getDimension());
                parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, parameter3.getDimension()));
            }
        }
        this.continuous = parameter2;
        this.loadings = matrixParameterInterface3;
        this.missingIndicator = parameter;
        this.rowCount = new int[diagonalMatrix2.getRowDimension()];
        if (parameter != null) {
            for (n3 = 0; n3 < matrixParameterInterface.getRowDimension(); ++n3) {
                for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
                    if (parameter.getParameterValue(i * matrixParameterInterface.getRowDimension() + n3) != 0.0) continue;
                    int n4 = n3;
                    this.rowCount[n4] = this.rowCount[n4] + 1;
                }
            }
        } else {
            for (n3 = 0; n3 < matrixParameterInterface.getRowDimension(); ++n3) {
                this.rowCount[n3] = matrixParameterInterface.getColumnDimension();
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.rowCount.length; ++n2) {
            n3 += this.rowCount[n2];
        }
        this.nmeasurements = n3;
        this.changed = new boolean[matrixParameterInterface3.getRowDimension()][matrixParameterInterface2.getColumnDimension()];
        this.storedChanged = new boolean[matrixParameterInterface3.getRowDimension()][matrixParameterInterface2.getColumnDimension()];
        for (n2 = 0; n2 < matrixParameterInterface3.getRowDimension(); ++n2) {
            for (n = 0; n < matrixParameterInterface2.getColumnDimension(); ++n) {
                this.changed[n2][n] = true;
            }
        }
        this.rowPrecision = diagonalMatrix;
        this.colPrecision = diagonalMatrix2;
        this.addVariable(matrixParameterInterface);
        this.addVariable(matrixParameterInterface2);
        this.addVariable(matrixParameterInterface3);
        this.addVariable(diagonalMatrix);
        this.addVariable(diagonalMatrix2);
        this.dimFactors = matrixParameterInterface2.getRowDimension();
        this.dimData = matrixParameterInterface3.getRowDimension();
        this.nTaxa = matrixParameterInterface2.getColumnDimension();
        if (this.nTaxa != matrixParameterInterface.getColumnDimension()) {
            throw new RuntimeException("DATA COLUMNS MUST HAVE THE SAME DIMENSION AS FACTOR COLUMNS\n");
        }
        if (this.dimData != matrixParameterInterface.getRowDimension()) {
            System.out.println(this.dimData);
            System.out.println(matrixParameterInterface.getRowDimension());
            System.out.println(matrixParameterInterface3.getRowDimension());
            throw new RuntimeException("DATA ROWS MUST HAVE THE SAME DIMENSION AS LOADINGS ROWS\n");
        }
        if (matrixParameterInterface2.getRowDimension() != matrixParameterInterface3.getColumnDimension()) {
            System.out.println(this.getModelName());
            throw new RuntimeException("LOADINGS AND FACTORS MUST HAVE THE SAME NUMBER OF FACTORS\n");
        }
        if (this.dimData < this.dimFactors) {
            throw new RuntimeException("MUST HAVE FEWER FACTORS THAN DATA POINTS\n");
        }
        this.residual = new double[matrixParameterInterface3.getRowDimension() * matrixParameterInterface2.getColumnDimension()];
        this.LxF = new double[matrixParameterInterface3.getRowDimension() * matrixParameterInterface2.getColumnDimension()];
        this.storedResidual = new double[this.residual.length];
        this.storedLxF = new double[this.LxF.length];
        if (!this.isDataScaled & !bl) {
            this.sData = this.data;
            this.isDataScaled = true;
        }
        if (!this.isDataScaled) {
            this.sData = this.computeScaledData();
            this.isDataScaled = true;
            for (n2 = 0; n2 < this.sData.getRowDimension(); ++n2) {
                for (n = 0; n < this.sData.getColumnDimension(); ++n) {
                    this.data.setParameterValue(n2, n, this.sData.getParameterValue(n2, n));
                }
            }
            matrixParameterInterface.fireParameterChangedEvent();
        }
        double d = 0.0;
        for (int i = 0; i < this.sData.getRowDimension(); ++i) {
            for (int j = 0; j < this.sData.getColumnDimension(); ++j) {
                if (parameter2.getParameterValue(i) != 1.0 || this.sData.getParameterValue(i, j) == 0.0) continue;
                d += -0.5 * Math.log(Math.PI * 2) - 0.5 * this.sData.getParameterValue(i, j) * this.sData.getParameterValue(i, j);
            }
        }
        System.out.println("Constant Value for Path Sampling (normal 0,1): " + -1.0 * d);
        this.computeResiduals();
    }

    @Override
    public MatrixParameterInterface getFactors() {
        return this.factors;
    }

    @Override
    public MatrixParameter getColumnPrecision() {
        return this.colPrecision;
    }

    @Override
    public MatrixParameterInterface getLoadings() {
        return this.loadings;
    }

    public MatrixParameterInterface getData() {
        return this.data;
    }

    public Parameter returnIntermediate() {
        if (!this.residualKnown && this.checkLoadings()) {
            this.computeResiduals();
        }
        return this.data;
    }

    @Override
    public MatrixParameterInterface getScaledData() {
        return this.data;
    }

    public Parameter getContinuous() {
        return this.continuous;
    }

    @Override
    public int getFactorDimension() {
        return this.factors.getRowDimension();
    }

    public double[] getResidual() {
        this.computeResiduals();
        return this.residual;
    }

    @Override
    public Parameter getMissingIndicator() {
        return this.missingIndicator;
    }

    public int getRowCount(int n) {
        return this.rowCount[n];
    }

    private void Multiply(MatrixParameterInterface matrixParameterInterface, MatrixParameterInterface matrixParameterInterface2, double[] dArray) {
        int n = matrixParameterInterface.getColumnDimension();
        int n2 = matrixParameterInterface.getRowDimension();
        int n3 = matrixParameterInterface2.getColumnDimension();
        if ((!this.factorsKnown && !this.RecomputeFactors || !this.dataKnown && !this.RecomputeResiduals || !this.loadingsKnown && !this.RecomputeLoadings) && !this.totalRecompute) {
            ListIterator<Integer> listIterator = this.changedValues.listIterator();
            while (listIterator.hasNext()) {
                int n4 = listIterator.next();
                int n5 = n4 % n2;
                int n6 = n4 / n2;
                if (this.missingIndicator != null && this.missingIndicator.getParameterValue(n6 * n2 + n5) == 1.0) continue;
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += matrixParameterInterface.getParameterValue(n5, i) * matrixParameterInterface2.getParameterValue(i, n6);
                }
                dArray[n6 * n2 + n5] = d;
            }
        } else {
            int n7;
            for (n7 = 0; n7 < dArray.length; ++n7) {
                dArray[n7] = 0.0;
            }
            for (n7 = 0; n7 < n2; ++n7) {
                for (int i = 0; i < n; ++i) {
                    if (matrixParameterInterface.getParameterValue(n7, i) == 0.0) continue;
                    for (int j = 0; j < n3; ++j) {
                        if (this.missingIndicator != null && this.missingIndicator.getParameterValue(j * n2 + n7) == 1.0 || (!this.changed[n7][j] || this.continuous.getParameterValue(n7) == 0.0) && !this.newModel) continue;
                        double d = 0.0;
                        int n8 = j * n2 + n7;
                        dArray[n8] = dArray[n8] + (d += matrixParameterInterface.getParameterValue(n7, i) * matrixParameterInterface2.getParameterValue(i, j));
                    }
                }
            }
        }
    }

    private void add(MatrixParameter matrixParameter, MatrixParameter matrixParameter2, double[] dArray) {
        int n = matrixParameter.getRowDimension();
        int n2 = matrixParameter.getColumnDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i * n2 + j] = matrixParameter.getParameterValue(i, j) + matrixParameter2.getParameterValue(i, j);
            }
        }
    }

    private void subtract(MatrixParameterInterface matrixParameterInterface, double[] dArray, double[] dArray2) {
        int n = matrixParameterInterface.getRowDimension();
        int n2 = matrixParameterInterface.getColumnDimension();
        if ((!this.RecomputeResiduals && !this.dataKnown || !this.RecomputeFactors && !this.factorsKnown || !this.RecomputeLoadings && !this.loadingsKnown) && !this.totalRecompute) {
            int n3 = this.changedValues.size();
            for (int i = 0; i < n3; ++i) {
                int n4 = this.changedValues.get(i);
                int n5 = n4 / n;
                int n6 = n4 % n;
                if (this.missingIndicator != null && this.missingIndicator.getParameterValue(n5 * n + n6) == 1.0) continue;
                dArray2[n5 * n + n6] = matrixParameterInterface.getParameterValue(n4) - dArray[n5 * n + n6];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (this.continuous.getParameterValue(i) == 0.0 && !this.newModel) continue;
                for (int j = 0; j < n2; ++j) {
                    if (this.missingIndicator != null && this.missingIndicator.getParameterValue(j * n + i) == 1.0) continue;
                    dArray2[j * n + i] = matrixParameterInterface.getParameterValue(i, j) - dArray[j * n + i];
                }
            }
        }
        this.changedValues.clear();
    }

    private double TDTTrace(double[] dArray, DiagonalMatrix diagonalMatrix) {
        int n = diagonalMatrix.getRowDimension();
        int n2 = dArray.length / n;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.continuous.getParameterValue(i) == 0.0 && !this.newModel) continue;
            for (int j = 0; j < n2; ++j) {
                if (this.missingIndicator != null && this.missingIndicator.getParameterValue(j * n + i) == 1.0) continue;
                double d2 = dArray[j * n + i];
                double d3 = diagonalMatrix.getParameterValue(i, i);
                d += d2 * d2 * d3;
            }
        }
        return d;
    }

    private MatrixParameter computeScaledData() {
        int n;
        int n2;
        int n3;
        MatrixParameter matrixParameter = new MatrixParameter(this.data.getParameterName() + ".scaled");
        matrixParameter.setDimensions(this.data.getRowDimension(), this.data.getColumnDimension());
        double[][] dArray = this.data.getParameterAsMatrix();
        double[] dArray2 = new double[this.data.getRowDimension()];
        double[] dArray3 = new double[this.data.getRowDimension()];
        double[] dArray4 = new double[this.data.getRowDimension()];
        for (n3 = 0; n3 < this.data.getColumnDimension(); ++n3) {
            for (n2 = 0; n2 < this.data.getRowDimension(); ++n2) {
                if (this.data.getParameterValue(n2, n3) == 0.0) continue;
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + this.data.getParameterValue(n2, n3);
                int n5 = n2;
                dArray4[n5] = dArray4[n5] + 1.0;
            }
        }
        for (n3 = 0; n3 < this.data.getRowDimension(); ++n3) {
            dArray2[n3] = this.continuous.getParameterValue(n3) == 1.0 ? dArray2[n3] / dArray4[n3] : 0.0;
        }
        double[][] dArray5 = new double[this.data.getRowDimension()][this.data.getColumnDimension()];
        for (n2 = 0; n2 < this.data.getColumnDimension(); ++n2) {
            for (n = 0; n < this.data.getRowDimension(); ++n) {
                if (dArray[n][n2] == 0.0) continue;
                dArray5[n][n2] = dArray[n][n2] - dArray2[n];
            }
        }
        for (n2 = 0; n2 < this.data.getColumnDimension(); ++n2) {
            for (n = 0; n < this.data.getRowDimension(); ++n) {
                int n6 = n;
                dArray3[n6] = dArray3[n6] + dArray5[n][n2] * dArray5[n][n2];
            }
        }
        for (n2 = 0; n2 < this.data.getRowDimension(); ++n2) {
            if (this.continuous.getParameterValue(n2) == 1.0) {
                dArray3[n2] = dArray3[n2] / (dArray4[n2] - 1.0);
                dArray3[n2] = StrictMath.sqrt(dArray3[n2]);
                continue;
            }
            dArray3[n2] = 1.0;
        }
        for (n2 = 0; n2 < this.data.getColumnDimension(); ++n2) {
            for (n = 0; n < this.data.getRowDimension(); ++n) {
                matrixParameter.setParameterValue(n, n2, dArray5[n][n2] / dArray3[n]);
            }
        }
        return matrixParameter;
    }

    private Matrix copy(CompoundParameter compoundParameter, int n, int n2) {
        return new Matrix(compoundParameter.getParameterValues(), n, n2);
    }

    private void computeResiduals() {
        if (!this.LxFKnown) {
            this.Multiply(this.loadings, this.factors, this.LxF);
        }
        this.subtract(this.data, this.LxF, this.residual);
        this.LxFKnown = true;
        this.residualKnown = true;
        this.factorsKnown = true;
        this.loadingsKnown = true;
        this.dataKnown = true;
        this.totalRecompute = false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogDetColKnown = this.logDetColKnown;
        this.storedLogDetCol = this.logDetCol;
        this.storedTrace = this.trace;
        this.storedTraceKnown = this.traceKnown;
        this.storedResidualKnown = this.residualKnown;
        this.storedLxFKnown = this.LxFKnown;
        this.storedFactorsKnown = this.factorsKnown;
        this.storedLoadingsKnown = this.loadingsKnown;
        this.storedDataKnown = this.dataKnown;
        this.storedTotalRecompute = this.totalRecompute;
        System.arraycopy(this.residual, 0, this.storedResidual, 0, this.residual.length);
        System.arraycopy(this.LxF, 0, this.storedLxF, 0, this.residual.length);
        System.arraycopy(this.changed, 0, this.storedChanged, 0, this.changed.length);
        this.storedChangedValues = (Vector)this.changedValues.clone();
    }

    @Override
    protected void restoreState() {
        this.changed = this.storedChanged;
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.trace = this.storedTrace;
        this.traceKnown = this.storedTraceKnown;
        this.residualKnown = this.storedResidualKnown;
        this.LxFKnown = this.storedLxFKnown;
        double[] dArray = this.residual;
        this.residual = this.storedResidual;
        this.storedResidual = dArray;
        dArray = this.LxF;
        this.LxF = this.storedLxF;
        this.storedLxF = dArray;
        this.logDetCol = this.storedLogDetCol;
        this.logDetColKnown = this.storedLogDetColKnown;
        this.factorsKnown = this.storedFactorsKnown;
        this.loadingsKnown = this.storedLoadingsKnown;
        this.dataKnown = this.storedDataKnown;
        this.totalRecompute = this.storedTotalRecompute;
        this.changedValues = this.storedChangedValues;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        int n2;
        int n3;
        if (variable == this.getScaledData()) {
            this.residualKnown = false;
            this.traceKnown = false;
            this.likelihoodKnown = false;
            if (!this.RecomputeResiduals) {
                if (n != -1 && !this.changedValues.contains(n)) {
                    this.changedValues.add(n);
                } else {
                    this.totalRecompute = true;
                    this.changedValues.clear();
                }
                this.dataKnown = false;
            }
        }
        if (variable == this.factors) {
            if (!this.RecomputeFactors) {
                this.factorsKnown = false;
                n3 = n / this.factors.getRowDimension();
                if (n != -1) {
                    for (n2 = 0; n2 < this.data.getRowDimension(); ++n2) {
                        if (this.changedValues.contains(n3 * this.data.getRowDimension() + n2)) continue;
                        this.changedValues.add(n3 * this.data.getRowDimension() + n2);
                    }
                } else {
                    this.totalRecompute = true;
                    this.changedValues.clear();
                }
            }
            this.LxFKnown = false;
            this.residualKnown = false;
            this.traceKnown = false;
            this.likelihoodKnown = false;
        }
        if (variable == this.loadings) {
            if (!this.RecomputeLoadings) {
                this.loadingsKnown = false;
                n3 = n % this.loadings.getRowDimension();
                if (n != -1) {
                    for (n2 = 0; n2 < this.data.getColumnDimension(); ++n2) {
                        if (this.changedValues.contains(n2 * this.data.getRowDimension() + n3)) continue;
                        this.changedValues.add(n2 * this.data.getRowDimension() + n3);
                    }
                } else {
                    this.totalRecompute = true;
                    this.changedValues.clear();
                }
            }
            this.LxFKnown = false;
            this.residualKnown = false;
            this.traceKnown = false;
            this.likelihoodKnown = false;
        }
        if (variable == this.colPrecision) {
            this.logDetColKnown = false;
            this.traceKnown = false;
            this.likelihoodKnown = false;
        }
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Latent factor model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.CYBIS_2015_ASSESSING);
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        this.likelihoodKnown = false;
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.factorsKnown = false;
        this.loadingsKnown = false;
        this.residualKnown = false;
        this.totalRecompute = true;
        this.changedValues.clear();
        this.LxFKnown = false;
        this.logDetColKnown = false;
        this.traceKnown = false;
        this.dataKnown = false;
    }

    private boolean checkLoadings() {
        for (int i = 0; i < StrictMath.min(this.loadings.getRowDimension(), this.loadings.getColumnDimension()); ++i) {
            if (!(this.loadings.getParameterValue(i, i) < 0.0)) continue;
            return false;
        }
        return true;
    }

    private double calculateLogLikelihood() {
        if (!this.residualKnown) {
            this.computeResiduals();
        }
        if (!this.logDetColKnown) {
            this.logDetColKnown = true;
            this.logDetCol = 0.0;
            for (int i = 0; i < this.colPrecision.getRowDimension(); ++i) {
                if (this.continuous.getParameterValue(i) == 0.0) continue;
                this.logDetCol += Math.log(this.colPrecision.getParameterValue(i, i)) * (double)this.rowCount[i];
            }
        }
        if (!this.traceKnown) {
            this.traceKnown = true;
            this.trace = this.TDTTrace(this.residual, this.colPrecision);
        }
        return -0.5 * this.trace + 0.5 * this.logDetCol - 0.5 * (double)this.nmeasurements * Math.log(Math.PI * 2);
    }

    public double[] getLxF() {
        if (!this.LxFKnown) {
            this.computeResiduals();
        }
        return this.LxF;
    }
}

