/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import java.util.Observable;
import umontreal.iro.lecuyer.simevents.LinkedListStat;
import umontreal.iro.lecuyer.simevents.Simulator;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.simprocs.UserRecord;

public class Condition
extends Observable {
    private String name;
    private LinkedListStat<UserRecord> waitingList;
    private boolean state;
    private boolean broadcasting;
    private ProcessSimulator sim;

    public Condition(boolean bl) {
        this(bl, "");
    }

    public Condition(ProcessSimulator processSimulator, boolean bl) {
        this(processSimulator, bl, "");
    }

    public Condition(boolean bl, String string) {
        try {
            ProcessSimulator.initDefault();
            this.sim = (ProcessSimulator)Simulator.getDefaultSimulator();
            this.waitingList = new LinkedListStat(this.sim);
            this.name = string;
            this.broadcasting = false;
            this.state = bl;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Wrong default Simulator type");
        }
    }

    public Condition(ProcessSimulator processSimulator, boolean bl, String string) {
        this.sim = processSimulator;
        this.waitingList = new LinkedListStat(processSimulator);
        this.name = string;
        this.broadcasting = false;
        this.state = bl;
    }

    public void init(boolean bl) {
        this.waitingList.clear();
        this.state = bl;
        if (this.broadcasting) {
            this.setChanged();
            this.notifyObservers(new Boolean(this.state));
        }
    }

    public void set(boolean bl) {
        this.state = bl;
        if (this.state) {
            while (!this.waitingList.isEmpty()) {
                UserRecord userRecord = this.waitingList.removeLast();
                userRecord.process.resume();
            }
        }
        if (this.broadcasting) {
            this.setChanged();
            this.notifyObservers(new Boolean(bl));
        }
    }

    public boolean state() {
        return this.state;
    }

    public void waitFor() {
        SimProcess simProcess = this.sim.currentProcess();
        if (this.state) {
            if (this.waitingList.statSojourn() != null) {
                this.waitingList.statSojourn().add(0.0);
            }
            return;
        }
        UserRecord userRecord = new UserRecord(1, simProcess, this.sim.time());
        this.waitingList.addLast(userRecord);
        simProcess.suspend();
    }

    public LinkedListStat waitList() {
        return this.waitingList;
    }

    public String getName() {
        return this.name;
    }

    public void setBroadcasting(boolean bl) {
        this.broadcasting = bl;
    }
}

