/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm;

import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IEvaluator;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IPopulation;
import net.sourceforge.jclec.IProvider;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.algorithm.AbstractAlgorithm;
import net.sourceforge.jclec.util.random.IRandGen;
import net.sourceforge.jclec.util.random.IRandGenFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public abstract class PopulationAlgorithm
extends AbstractAlgorithm
implements IPopulation {
    protected IRandGenFactory randGenFactory;
    protected ISpecies species;
    protected IEvaluator evaluator;
    protected IProvider provider;
    protected int populationSize;
    protected int maxOfGenerations;
    protected int maxOfEvaluations;
    protected int generation;
    protected List<IIndividual> bset;
    protected transient List<IIndividual> pset;
    protected transient List<IIndividual> cset;
    protected transient List<IIndividual> rset;

    @Override
    public final ISpecies getSpecies() {
        return this.species;
    }

    @Override
    public final IEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public final int getGeneration() {
        return this.generation;
    }

    @Override
    public List<IIndividual> getInhabitants() {
        return this.bset;
    }

    public void setSpecies(ISpecies species) {
        this.species = species;
    }

    public void setEvaluator(IEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public final void setGeneration(int generation) {
        this.generation = generation;
    }

    public final void setInhabitants(List<IIndividual> inhabitants) {
        this.bset = inhabitants;
    }

    public IRandGenFactory getRandGenFactory() {
        return this.randGenFactory;
    }

    public void setRandGenFactory(IRandGenFactory randGenFactory) {
        this.randGenFactory = randGenFactory;
    }

    public final IProvider getProvider() {
        return this.provider;
    }

    public final void setProvider(IProvider provider) {
        this.provider = provider;
        provider.contextualize(this);
    }

    public final int getPopulationSize() {
        return this.populationSize;
    }

    public final void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public final int getMaxOfGenerations() {
        return this.maxOfGenerations;
    }

    public final void setMaxOfGenerations(int maxOfGenerations) {
        this.maxOfGenerations = maxOfGenerations;
    }

    public final int getMaxOfEvaluations() {
        return this.maxOfEvaluations;
    }

    public final void setMaxOfEvaluations(int maxOfEvaluations) {
        this.maxOfEvaluations = maxOfEvaluations;
    }

    @Override
    public IRandGen createRandGen() {
        return this.randGenFactory.createRandGen();
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        try {
            String randGenFactoryClassname = configuration.getString("rand-gen-factory[@type]");
            Class<?> randGenFactoryClass = Class.forName(randGenFactoryClassname);
            IRandGenFactory randGenFactory = (IRandGenFactory)randGenFactoryClass.newInstance();
            if (randGenFactory instanceof IConfigure) {
                ((IConfigure)((Object)randGenFactory)).configure(configuration.subset("rand-gen-factory"));
            }
            this.setRandGenFactory(randGenFactory);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal random generators factory classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of random generators factory", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of random generators factory", e);
        }
        try {
            String speciesClassname = configuration.getString("species[@type]");
            Class<?> speciesClass = Class.forName(speciesClassname);
            ISpecies species = (ISpecies)speciesClass.newInstance();
            if (species instanceof IConfigure) {
                ((IConfigure)((Object)species)).configure(configuration.subset("species"));
            }
            this.setSpecies(species);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal species classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of species", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of species", e);
        }
        try {
            String evaluatorClassname = configuration.getString("evaluator[@type]");
            Class<?> evaluatorClass = Class.forName(evaluatorClassname);
            IEvaluator evaluator = (IEvaluator)evaluatorClass.newInstance();
            if (evaluator instanceof IConfigure) {
                ((IConfigure)((Object)evaluator)).configure(configuration.subset("evaluator"));
            }
            this.setEvaluator(evaluator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal evaluator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of evaluator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of evaluator", e);
        }
        int populationSize = configuration.getInt("population-size");
        this.setPopulationSize(populationSize);
        int maxOfGenerations = configuration.getInt("max-of-generations", Integer.MAX_VALUE);
        this.setMaxOfGenerations(maxOfGenerations);
        int maxOfEvaluations = configuration.getInt("max-of-evaluations", Integer.MAX_VALUE);
        this.setMaxOfEvaluations(maxOfEvaluations);
        try {
            String providerClassname = configuration.getString("provider[@type]");
            Class<?> providerClass = Class.forName(providerClassname);
            IProvider provider = (IProvider)providerClass.newInstance();
            if (provider instanceof IConfigure) {
                ((IConfigure)((Object)provider)).configure(configuration.subset("provider"));
            }
            this.setProvider(provider);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal provider classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of provider", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of provider", e);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof PopulationAlgorithm) {
            PopulationAlgorithm cother = (PopulationAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.randGenFactory, cother.randGenFactory);
            eb.append(this.species, cother.species);
            eb.append(this.evaluator, cother.evaluator);
            eb.append(this.populationSize, cother.populationSize);
            eb.append(this.maxOfGenerations, cother.maxOfGenerations);
            eb.append(this.provider, cother.provider);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doInit() {
        this.bset = this.provider.provide(this.populationSize);
        this.evaluator.evaluate(this.bset);
        this.doControl();
    }

    @Override
    protected void doIterate() {
        ++this.generation;
        this.doSelection();
        this.doGeneration();
        this.doReplacement();
        this.doUpdate();
        this.doControl();
    }

    protected abstract void doSelection();

    protected abstract void doGeneration();

    protected abstract void doReplacement();

    protected abstract void doUpdate();

    protected void doControl() {
        if (this.generation >= this.maxOfGenerations) {
            this.state = 3;
            return;
        }
        if (this.evaluator.getNumberOfEvaluations() > this.maxOfEvaluations) {
            this.state = 3;
            return;
        }
        for (IIndividual individual : this.bset) {
            if (!individual.getFitness().isAcceptable()) continue;
            this.state = 3;
            return;
        }
    }
}

