/*
 * Decompiled with CFR 0.152.
 */
package vu.co.kaiyin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;

public class Utils {
    public static int[] seq(int start, int end) {
        if (end < start) {
            end = start;
        }
        int[] res = new int[end - start + 1];
        for (int i = start; i <= end; ++i) {
            res[i - start] = i;
        }
        return res;
    }

    public static int countLines(String filename) throws IOException {
        int lines = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            while (reader.readLine() != null) {
                ++lines;
            }
        }
        return lines;
    }

    public static int countLines(File file) throws IOException {
        return Utils.countLines(file.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readDelimitedFile(File file, String regex, int nSkip, int[] columnIndices) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        int maxIndex = -1;
        if (columnIndices != null && columnIndices.length > 0) {
            for (int i : columnIndices) {
                if (i <= maxIndex) continue;
                maxIndex = i;
            }
        }
        ArrayList<String[]> res = new ArrayList<String[]>();
        try {
            String line;
            for (int nSkipCounter = 0; nSkipCounter < nSkip && (line = reader.readLine()) != null; ++nSkipCounter) {
            }
            line = reader.readLine();
            if (line == null) {
                String[][] nSkipCounter = (String[][])res.toArray();
                return nSkipCounter;
            }
            String[] cols = line.split(regex);
            if (cols.length <= maxIndex) {
                throw new Exception(String.format("%s has less than %d columns", file.toString(), maxIndex + 1));
            }
            String[] columnsSelected = new String[columnIndices.length];
            Utils.fillArrayByIndex(cols, columnsSelected, columnIndices);
            res.add(columnsSelected);
            while ((line = reader.readLine()) != null) {
                String[] lineSplit = maxIndex < 0 ? line.split(regex) : line.split(regex, maxIndex + 2);
                columnsSelected = new String[columnIndices.length];
                Utils.fillArrayByIndex(lineSplit, columnsSelected, columnIndices);
                res.add(columnsSelected);
            }
        }
        finally {
            reader.close();
        }
        return (String[][])res.stream().toArray(x$0 -> new String[x$0][]);
    }

    public static <E> void fillArrayByIndex(E[] source, E[] target, int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            target[i] = source[indices[i]];
        }
    }

    public static String shiftedFilename(String filename, int nShift) {
        String ext = FilenameUtils.getExtension(filename);
        return String.format("%s_shift_%04d.%s", FilenameUtils.removeExtension(filename), nShift, ext);
    }

    public static <E> void printMat(E[][] x, int startRow, int endRow, int startColumn, int endColumn) {
        int j;
        int i;
        if (x.length == 0 || x[0].length == 0) {
            return;
        }
        if (startRow < 0) {
            startRow = 0;
        }
        if (startRow >= x.length) {
            startRow = x.length - 1;
        }
        if (endRow < startRow) {
            endRow = startRow + 1;
        }
        if (endRow > x.length) {
            endRow = x.length;
        }
        if (startColumn < 0) {
            startColumn = 0;
        }
        if (startColumn >= x[0].length) {
            startColumn = x[0].length - 1;
        }
        if (endColumn < startColumn) {
            endColumn = startColumn + 1;
        }
        if (endColumn > x[0].length) {
            endColumn = x[0].length;
        }
        int nCols = endColumn - startColumn;
        int[] colWidths = new int[nCols];
        for (i = startRow; i < endRow; ++i) {
            for (j = startColumn; j < endColumn; ++j) {
                int colLength = x[i][j].toString().length();
                if (colLength <= colWidths[j]) continue;
                colWidths[j] = colLength;
            }
        }
        for (i = startRow; i < endRow; ++i) {
            for (j = startColumn; j < endColumn; ++j) {
                System.out.printf(String.format("%%%ds", colWidths[j] + 2), x[i][j].toString());
            }
            System.out.println();
        }
        System.out.println();
    }

    public static <E> void printMat(E[][] x) {
        Utils.printMat(x, 0, x.length, 0, x[0].length);
    }

    public static void printMat(int[][] x, int startRow, int endRow, int startColumn, int endColumn) {
        String[][] y = new String[x.length][x[0].length];
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[0].length; ++j) {
                y[i][j] = Integer.toString(x[i][j]);
            }
        }
        Utils.printMat(y, startRow, endRow, startColumn, endColumn);
    }

    public static void printMat(int[][] x) {
        Utils.printMat(x, 0, x.length, 0, x[0].length);
    }

    public static void truncateFromEnd(File filename, int n) throws Exception {
        if (n < 0) {
            throw new Exception("Can't truncate by a negative number");
        }
        try (RandomAccessFile raf = new RandomAccessFile(filename, "rw");){
            long originalLength = raf.length();
            long newLength = originalLength - (long)n;
            if (newLength < 0L) {
                newLength = 0L;
            }
            raf.setLength(newLength);
        }
    }

    public static void truncateFromEnd(String filename, int n) throws Exception {
        Utils.truncateFromEnd(new File(filename), n);
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream fo = new FileOutputStream("/tmp/bin.out");
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        fo.write(data);
        fo.close();
        File file = new File("/Users/kaiyin/workspace/BedWorks/src/test/resources/test.bim");
        Utils.printMat(Utils.readDelimitedFile(file, "\\s+", 0, new int[]{0, 1, 2}));
    }
}

