/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.MathUtils;

public final class PropGreaterOrEqualXY_C
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final int cste;

    public PropGreaterOrEqualXY_C(IntVar[] vars, int c) {
        super((Variable[])vars, (Priority)PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.INSTANTIATE.getMask() + IntEventType.DECUPP.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(MathUtils.safeSubstract(this.cste, this.y.getUB()), (ICause)this);
        this.y.updateLowerBound(MathUtils.safeSubstract(this.cste, this.x.getUB()), (ICause)this);
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.y.updateLowerBound(this.cste - this.x.getUB(), (ICause)this);
        } else {
            this.x.updateLowerBound(this.cste - this.y.getUB(), (ICause)this);
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste) {
            return ESat.FALSE;
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (explanation.readVar(p) == ((IntVar[])this.vars)[0]) {
            int m = explanation.readDom(((IntVar[])this.vars)[1]).max();
            IntIterableRangeSet set = explanation.complement(((IntVar[])this.vars)[1]);
            set.retainBetween(m + 1, 0x3FFFFFFF);
            ((IntVar[])this.vars)[0].intersectLit(this.cste - m, 0x3FFFFFFF, explanation);
            ((IntVar[])this.vars)[1].unionLit(set, explanation);
        } else {
            assert (explanation.readVar(p) == ((IntVar[])this.vars)[1]);
            int m = explanation.readDom(((IntVar[])this.vars)[0]).max();
            IntIterableRangeSet set = explanation.complement(((IntVar[])this.vars)[0]);
            set.retainBetween(m + 1, 0x3FFFFFFF);
            ((IntVar[])this.vars)[0].unionLit(set, explanation);
            ((IntVar[])this.vars)[1].intersectLit(this.cste - m, 0x3FFFFFFF, explanation);
        }
    }

    @Override
    public String toString() {
        return this.x.getName() + " + " + this.y.getName() + " >= " + this.cste;
    }
}

