ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
              
sidebarLayout(
   sidebarPanel(width = 3,
      selectInput('rv.func', 
                  label = 'Random Variable',
                  choices = c('Sum of Rolls', 
                              'Product of Rolls', 
                              'Difference of Rolls'), 
                  selected = 'Sum of Rolls'),
       sliderInput('no.dice', 
                   label = 'Number Of Rolls', 
                   min = 1, 
                   max = 4, 
                   value = 1),
       sliderInput('no.sides', 
                   label = 'Number Of Sides', 
                   min = 4, 
                   max = 20, 
                   value = 6)),
         
mainPanel(width = 9,
    tabsetPanel(type = 'pills',
          tabPanel("Outcomes", 
                   DT::dataTableOutput("results", height = "550px")),
          tabPanel('Borel Algegra',
                   plotOutput('diceresults', height = '550px')),
          tabPanel('Probabilities',
                   plotOutput('diceprobs', height = '550px'))))))
