cmake_policy(SET CMP0012 NEW)
cmake_policy(SET CMP0057 NEW)
if(NOT "OFF")
    if(NOT CMAKE_CXX_COMPILER_LOADED)
        message(WARNING "Linking to GDAL may need CXX to be enabled.")
    endif()
    if(DEFINED CMAKE_MODULE_PATH)
        set(_gdal_module_path_backup "${CMAKE_MODULE_PATH}")
    endif()
    include(CMakeFindDependencyMacro)
include("${CMAKE_CURRENT_LIST_DIR}/DefineFindPackage2.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/GdalFindModulePath.cmake")
find_dependency(Threads)
find_dependency(ODBC )
find_dependency(MySQL )
find_dependency(CURL )
find_dependency(Iconv )
find_dependency(LibXml2 )
find_dependency(EXPAT )
find_dependency(ZLIB )
find_dependency(OpenSSL COMPONENTS SSL Crypto)
find_dependency(PROJ 9 CONFIG)
find_dependency(ZSTD NAMES zstd CONFIGS zstdConfig.cmake )
find_dependency(PNG )
find_dependency(JPEG )
find_dependency(GIF )
find_dependency(JSONC NAMES json-c CONFIGS json-c-config.cmake )
find_dependency(PCRE2 )
find_dependency(SQLite3 )
find_dependency(SPATIALITE 4.1.2)
define_find_package2(KEA "libkea/KEACommon.h" "kea")
find_package2(KEA REQUIRED)
find_dependency(HDF5 COMPONENTS C CXX)
find_dependency(WebP )
find_dependency(FreeXL )
define_find_package2(GTA "gta/gta.h" "gta" PKGCONFIG_NAME "gta")
find_package2(GTA REQUIRED)
find_dependency(Armadillo )
find_dependency(GEOS NAMES GEOS CONFIGS geos-config.cmake )
find_dependency(HDF4 )
find_dependency(NetCDF NAMES netCDF CONFIGS netCDFConfig.cmake )
find_dependency(PostgreSQL )
find_dependency(LibLZMA )
find_dependency(LZ4 )
find_dependency(Blosc )
find_dependency(OpenJPEG MODULE)
find_dependency(Poppler )

    if(DEFINED _gdal_module_path_backup)
        set(CMAKE_MODULE_PATH  "${_gdal_module_path_backup}")
    else()
        unset(CMAKE_MODULE_PATH)
    endif()
endif()
include("${CMAKE_CURRENT_LIST_DIR}/GDAL-targets.cmake")
