/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.Clade;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.operators.ExchangeOperator;
import dr.evomodel.operators.FNPR;
import dr.evomodel.operators.NNI;
import dr.evomodel.operators.SubtreeSlideOperator;
import dr.evomodel.operators.WilsonBalding;
import dr.evomodel.tree.AbstractCladeImportanceDistribution;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GeneralOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

@Deprecated
public abstract class AbstractImportanceDistributionOperator
extends SimpleMCMCOperator
implements GeneralOperator {
    private long transitions = 0L;
    private OperatorSchedule schedule;
    protected TreeModel tree;
    protected AbstractCladeImportanceDistribution probabilityEstimater;
    private int sampleEvery;
    private int samples;
    private int sampleCount;
    private Queue<NodeRef> internalNodes;
    private Map<Integer, NodeRef> externalNodes;
    private boolean burnin = false;

    public AbstractImportanceDistributionOperator(TreeModel treeModel, double d) {
        this.tree = treeModel;
        this.setWeight(d);
        this.samples = 10000;
        this.sampleEvery = 10;
        this.init();
    }

    public AbstractImportanceDistributionOperator(TreeModel treeModel, double d, int n, int n2) {
        this.tree = treeModel;
        this.setWeight(d);
        this.samples = n;
        this.sampleEvery = n2;
        this.init();
    }

    private void init() {
        this.schedule = this.getOperatorSchedule(this.tree);
        this.sampleCount = 0;
        this.internalNodes = new LinkedList<NodeRef>();
        this.externalNodes = new HashMap<Integer, NodeRef>();
        this.fillExternalNodes(this.tree.getRoot());
    }

    @Override
    public double doOperation() {
        return 0.0;
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        if (!this.burnin) {
            if (this.sampleCount < this.samples * this.sampleEvery) {
                ++this.sampleCount;
                if (this.sampleCount % this.sampleEvery == 0) {
                    this.probabilityEstimater.addTree(this.tree);
                }
                this.setAcceptCount(0L);
                this.setRejectCount(0L);
                this.setTransitions(0);
                return this.doUnguidedOperation();
            }
            return this.doImportanceDistributionOperation(likelihood);
        }
        return this.doUnguidedOperation();
    }

    protected double doImportanceDistributionOperation(Likelihood likelihood) {
        double[] dArray;
        NodeRef nodeRef = this.tree.getRoot();
        BitSet bitSet = new BitSet();
        bitSet.set(0, (this.tree.getNodeCount() + 1) / 2);
        Clade clade = new Clade(bitSet, this.tree.getNodeHeight(nodeRef));
        this.internalNodes.clear();
        this.fillInternalNodes(nodeRef);
        this.internalNodes.poll();
        this.externalNodes.clear();
        this.fillExternalNodes(nodeRef);
        double d = this.probabilityEstimater.getTreeProbability(this.tree);
        try {
            this.tree.beginTreeEdit();
            ArrayList<Clade> arrayList = new ArrayList<Clade>();
            this.extractClades(this.tree, this.tree.getRoot(), arrayList, null);
            dArray = this.getAbsoluteNodeHeights(arrayList);
            Arrays.sort(dArray);
            d += this.getChanceForNodeHeights(dArray);
            double d2 = this.createTree(nodeRef, clade);
            this.assignDummyHeights(nodeRef);
            this.tree.endTreeEdit();
            this.tree.checkTreeIsValid();
        }
        catch (MutableTree.InvalidTreeException invalidTreeException) {
            throw new RuntimeException(invalidTreeException.getMessage());
        }
        this.tree.pushTreeChangedEvent(nodeRef);
        return d - (d2 += this.setNodeHeights(dArray));
    }

    private void assignDummyHeights(NodeRef nodeRef) {
        double d = this.tree.getNodeHeight(nodeRef) * (double)this.tree.getInternalNodeCount();
        this.tree.setNodeHeight(nodeRef, d);
        int n = this.tree.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
            if (this.tree.isExternal(nodeRef2)) continue;
            this.assignDummyHeights(nodeRef2, d / 2.0);
        }
    }

    private void assignDummyHeights(NodeRef nodeRef, double d) {
        assert (!this.tree.isExternal(nodeRef));
        this.tree.setNodeHeight(nodeRef, d);
        int n = this.tree.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
            if (this.tree.isExternal(nodeRef2)) continue;
            this.assignDummyHeights(nodeRef2, d / 2.0);
        }
    }

    private double createTree(NodeRef nodeRef, Clade clade) throws MutableTree.InvalidTreeException {
        double d = 0.0;
        if (clade.getSize() == 2) {
            NodeRef nodeRef2;
            int n = clade.getBits().nextSetBit(0);
            int n2 = clade.getBits().nextSetBit(n + 1);
            NodeRef nodeRef3 = this.externalNodes.get(n);
            NodeRef nodeRef4 = this.externalNodes.get(n2);
            this.removeChildren(nodeRef);
            NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
            if (nodeRef5 != null) {
                this.tree.removeChild(nodeRef5, nodeRef3);
            }
            if ((nodeRef2 = this.tree.getParent(nodeRef4)) != null) {
                this.tree.removeChild(nodeRef2, nodeRef4);
            }
            this.tree.addChild(nodeRef, nodeRef3);
            this.tree.addChild(nodeRef, nodeRef4);
        } else {
            NodeRef nodeRef6;
            NodeRef nodeRef7;
            NodeRef nodeRef8;
            int n;
            Clade[] cladeArray = new Clade[2];
            d = this.splitClade(clade, cladeArray);
            if (cladeArray[0].getSize() == 1) {
                n = cladeArray[0].getBits().nextSetBit(0);
                nodeRef8 = this.externalNodes.get(n);
            } else {
                nodeRef8 = this.internalNodes.poll();
                this.tree.setNodeHeight(nodeRef8, this.tree.getNodeHeight(nodeRef) * 0.5);
                d += this.createTree(nodeRef8, cladeArray[0]);
            }
            if (cladeArray[1].getSize() == 1) {
                n = cladeArray[1].getBits().nextSetBit(0);
                nodeRef7 = this.externalNodes.get(n);
            } else {
                nodeRef7 = this.internalNodes.poll();
                this.tree.setNodeHeight(nodeRef7, this.tree.getNodeHeight(nodeRef) * 0.5);
                d += this.createTree(nodeRef7, cladeArray[1]);
            }
            this.removeChildren(nodeRef);
            NodeRef nodeRef9 = this.tree.getParent(nodeRef8);
            if (nodeRef9 != null) {
                this.tree.removeChild(nodeRef9, nodeRef8);
            }
            if ((nodeRef6 = this.tree.getParent(nodeRef7)) != null) {
                this.tree.removeChild(nodeRef6, nodeRef7);
            }
            this.tree.addChild(nodeRef, nodeRef8);
            this.tree.addChild(nodeRef, nodeRef7);
        }
        return d;
    }

    private void removeChildren(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        if (nodeRef2 != null) {
            this.tree.removeChild(nodeRef, nodeRef2);
        }
        if ((nodeRef2 = this.tree.getChild(nodeRef, 1)) != null) {
            this.tree.removeChild(nodeRef, nodeRef2);
        }
    }

    private double splitClade(Clade clade, Clade[] cladeArray) {
        return this.probabilityEstimater.splitClade(clade, cladeArray);
    }

    private void extractClades(Tree tree, NodeRef nodeRef, List<Clade> list, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        if (tree.isExternal(nodeRef)) {
            int n = nodeRef.getNumber();
            bitSet2.set(n);
        } else {
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = tree.getChild(nodeRef, i);
                this.extractClades(tree, nodeRef2, list, bitSet2);
            }
            list.add(new Clade(bitSet2, tree.getNodeHeight(nodeRef)));
        }
        if (bitSet != null) {
            bitSet.or(bitSet2);
        }
    }

    private void assignCladeHeights(NodeRef nodeRef, HashMap<Clade, Double> hashMap, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        if (this.tree.isExternal(nodeRef)) {
            int n = nodeRef.getNumber();
            bitSet2.set(n);
        } else {
            for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
                this.assignCladeHeights(nodeRef2, hashMap, bitSet2);
            }
            Clade clade = new Clade(bitSet2, this.tree.getNodeHeight(nodeRef));
            if (hashMap.containsKey(clade)) {
                this.tree.setNodeHeight(nodeRef, hashMap.get(clade));
                hashMap.remove(clade);
            }
        }
        if (bitSet != null) {
            bitSet.or(bitSet2);
        }
    }

    private double[] getRelativeNodeHeights(Tree tree) {
        int n = tree.getInternalNodeCount();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            NodeRef nodeRef2 = tree.getParent(nodeRef);
            dArray[i] = tree.getNodeHeight(nodeRef) / tree.getNodeHeight(nodeRef2);
        }
        return dArray;
    }

    private double[] getAbsoluteNodeHeights(Tree tree) {
        int n = tree.getInternalNodeCount();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef = tree.getInternalNode(i);
            dArray[i] = tree.getNodeHeight(nodeRef);
        }
        return dArray;
    }

    private double[] getAbsoluteNodeHeights(List<Clade> list) {
        double[] dArray = new double[list.size()];
        int n = 0;
        for (Clade clade : list) {
            dArray[n] = clade.getHeight();
            ++n;
        }
        return dArray;
    }

    private double getChanceForNodeHeights(double[] dArray) {
        return this.getChanceOfPermuation(dArray);
    }

    private double getChanceOfUniformNodeHeights(NodeRef nodeRef) {
        double d = 0.0;
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        if (!this.tree.isExternal(nodeRef2)) {
            d += Math.log(1.0 / this.tree.getNodeHeight(nodeRef));
            d += this.getChanceOfUniformNodeHeights(nodeRef2);
        }
        if (!this.tree.isExternal(nodeRef3)) {
            d += Math.log(1.0 / this.tree.getNodeHeight(nodeRef));
            d += this.getChanceOfUniformNodeHeights(nodeRef3);
        }
        return d;
    }

    private double getChanceOfPermuation(double[] dArray) {
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        NodeRef nodeRef = this.tree.getRoot();
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        if (!this.tree.isExternal(nodeRef2)) {
            linkedList.add(nodeRef2);
        }
        if (!this.tree.isExternal(nodeRef3)) {
            linkedList.add(nodeRef3);
        }
        int n = dArray.length - 2;
        double d = 0.0;
        while (!linkedList.isEmpty()) {
            int n2 = this.getHighestNode(linkedList);
            d += Math.log(1.0 / (double)linkedList.size());
            NodeRef nodeRef4 = (NodeRef)linkedList.remove(n2);
            this.tree.setNodeHeight(nodeRef4, dArray[n]);
            --n;
            nodeRef2 = this.tree.getChild(nodeRef4, 0);
            nodeRef3 = this.tree.getChild(nodeRef4, 1);
            if (!this.tree.isExternal(nodeRef2)) {
                linkedList.add(nodeRef2);
            }
            if (this.tree.isExternal(nodeRef3)) continue;
            linkedList.add(nodeRef3);
        }
        return d;
    }

    private int getHighestNode(List<NodeRef> list) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            NodeRef nodeRef = list.get(i);
            if (!(this.tree.getNodeHeight(nodeRef) > d)) continue;
            d = this.tree.getNodeHeight(nodeRef);
            n = i;
        }
        return n;
    }

    private double setNodeHeights(double[] dArray) {
        return this.assignPermutedNodeHeights(dArray);
    }

    private double setUniformNodeHeights(NodeRef nodeRef) {
        double d;
        double d2;
        double d3 = 0.0;
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        if (!this.tree.isExternal(nodeRef2)) {
            d2 = this.tree.getNodeHeight(nodeRef);
            d = d2 * MathUtils.nextDouble();
            this.tree.setNodeHeight(nodeRef2, d);
            d3 += Math.log(1.0 / d2);
            d3 += this.setUniformNodeHeights(nodeRef2);
        }
        if (!this.tree.isExternal(nodeRef3)) {
            d2 = this.tree.getNodeHeight(nodeRef);
            d = d2 * MathUtils.nextDouble();
            this.tree.setNodeHeight(nodeRef3, d);
            d3 += Math.log(1.0 / d2);
            d3 += this.setUniformNodeHeights(nodeRef3);
        }
        return d3;
    }

    private double assignPermutedNodeHeights(double[] dArray) {
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        NodeRef nodeRef = this.tree.getRoot();
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        if (!this.tree.isExternal(nodeRef2)) {
            linkedList.add(nodeRef2);
        }
        if (!this.tree.isExternal(nodeRef3)) {
            linkedList.add(nodeRef3);
        }
        int n = dArray.length - 2;
        double d = 0.0;
        while (!linkedList.isEmpty()) {
            int n2 = MathUtils.nextInt(linkedList.size());
            d += Math.log(1.0 / (double)linkedList.size());
            NodeRef nodeRef4 = (NodeRef)linkedList.remove(n2);
            this.tree.setNodeHeight(nodeRef4, dArray[n]);
            --n;
            nodeRef2 = this.tree.getChild(nodeRef4, 0);
            nodeRef3 = this.tree.getChild(nodeRef4, 1);
            if (!this.tree.isExternal(nodeRef2)) {
                linkedList.add(nodeRef2);
            }
            if (this.tree.isExternal(nodeRef3)) continue;
            linkedList.add(nodeRef3);
        }
        return d;
    }

    private double setMissingNodeHeights(NodeRef nodeRef) {
        double d = 0.0;
        if (!this.tree.isExternal(nodeRef)) {
            for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
                NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
                this.setMissingNodeHeights(nodeRef2);
            }
            double d2 = this.getMinNodeHeight(nodeRef);
            double d3 = this.getMaxNodeHeight(nodeRef);
            if (d3 <= d2) {
                d3 = this.tree.getNodeHeight(this.tree.getRoot());
            }
            d += Math.log(1.0 / (d3 - d2));
            double d4 = d2 + MathUtils.nextDouble() * (d3 - d2);
            this.tree.setNodeHeight(nodeRef, d4);
        }
        return d;
    }

    private double getMinNodeHeight(NodeRef nodeRef) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
            double d2 = this.tree.getNodeHeight(nodeRef2);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    private double getMaxNodeHeight(NodeRef nodeRef) {
        return this.tree.getNodeHeight(this.tree.getParent(nodeRef));
    }

    private void fillInternalNodes(NodeRef nodeRef) {
        if (!this.tree.isExternal(nodeRef)) {
            this.internalNodes.add(nodeRef);
            int n = this.tree.getChildCount(nodeRef);
            for (int i = 0; i < n; ++i) {
                this.fillInternalNodes(this.tree.getChild(nodeRef, i));
            }
        }
    }

    private void fillExternalNodes(NodeRef nodeRef) {
        if (!this.tree.isExternal(nodeRef)) {
            int n = this.tree.getChildCount(nodeRef);
            for (int i = 0; i < n; ++i) {
                this.fillExternalNodes(this.tree.getChild(nodeRef, i));
            }
        } else {
            Integer n = nodeRef.getNumber();
            this.externalNodes.put(n, nodeRef);
        }
    }

    private OperatorSchedule getOperatorSchedule(TreeModel treeModel) {
        ExchangeOperator exchangeOperator = new ExchangeOperator(0, treeModel, 10.0);
        ExchangeOperator exchangeOperator2 = new ExchangeOperator(1, treeModel, 3.0);
        SubtreeSlideOperator subtreeSlideOperator = new SubtreeSlideOperator(treeModel, 10.0, 1.0, true, false, false, false, AdaptationMode.ADAPTATION_ON, 0.234);
        NNI nNI = new NNI(treeModel, 10.0);
        WilsonBalding wilsonBalding = new WilsonBalding(treeModel, 3.0);
        FNPR fNPR = new FNPR(treeModel, 5.0);
        SimpleOperatorSchedule simpleOperatorSchedule = new SimpleOperatorSchedule();
        simpleOperatorSchedule.addOperator(exchangeOperator);
        simpleOperatorSchedule.addOperator(exchangeOperator2);
        simpleOperatorSchedule.addOperator(subtreeSlideOperator);
        simpleOperatorSchedule.addOperator(nNI);
        simpleOperatorSchedule.addOperator(wilsonBalding);
        simpleOperatorSchedule.addOperator(fNPR);
        return simpleOperatorSchedule;
    }

    protected double doUnguidedOperation() {
        int n = this.schedule.getNextOperatorIndex();
        SimpleMCMCOperator simpleMCMCOperator = (SimpleMCMCOperator)this.schedule.getOperator(n);
        return simpleMCMCOperator.doOperation();
    }

    public long getTransitions() {
        return this.transitions;
    }

    public void setTransitions(int n) {
        this.transitions = n;
    }

    public double getTransistionProbability() {
        long l = this.getAcceptCount();
        long l2 = this.getRejectCount();
        long l3 = this.getTransitions();
        return (double)l3 / (double)(l + l2);
    }

    @Override
    public void reset() {
        super.reset();
        this.transitions = 0L;
    }

    public double getMinimumAcceptanceLevel() {
        return 0.5;
    }

    public double getMaximumAcceptanceLevel() {
        return 1.0;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.75;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 1.0;
    }

    @Override
    public abstract String getOperatorName();

    public abstract String getPerformanceSuggestion();
}

