/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import java.util.ArrayList;

public class IntersectionBounds
implements Bounds<Double> {
    private ArrayList<Bounds<Double>> bounds = null;
    private final int dimension;

    IntersectionBounds(int n) {
        this.dimension = n;
    }

    public void addBounds(Bounds<Double> bounds) {
        if (bounds.getBoundsDimension() != this.dimension) {
            throw new IllegalArgumentException("Incorrect dimension of bounds, expected " + this.dimension + " but received " + bounds.getBoundsDimension());
        }
        if (this.bounds == null) {
            this.bounds = new ArrayList();
        }
        this.bounds.add(bounds);
    }

    @Override
    public Double getLowerLimit(int n) {
        double d = Double.NEGATIVE_INFINITY;
        if (this.bounds != null) {
            for (Bounds<Double> bounds : this.bounds) {
                if (!(bounds.getLowerLimit(n) > d)) continue;
                d = bounds.getLowerLimit(n);
            }
        }
        return d;
    }

    @Override
    public Double getUpperLimit(int n) {
        double d = Double.POSITIVE_INFINITY;
        if (this.bounds != null) {
            for (Bounds<Double> bounds : this.bounds) {
                if (!(bounds.getUpperLimit(n) < d)) continue;
                d = bounds.getUpperLimit(n);
            }
        }
        return d;
    }

    @Override
    public int getBoundsDimension() {
        return this.dimension;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder("upper=[" + this.getUpperLimit(0));
        for (n = 1; n < this.getBoundsDimension(); ++n) {
            stringBuilder.append(", ").append(this.getUpperLimit(n));
        }
        stringBuilder.append("] lower=[").append(this.getLowerLimit(0));
        for (n = 1; n < this.getBoundsDimension(); ++n) {
            stringBuilder.append(", ").append(this.getLowerLimit(n));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

