/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.SimpleMetropolizedGibbsOperator;
import dr.inference.operators.SliceInterval;
import dr.math.MathUtils;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;

public class SliceOperator
extends SimpleMetropolizedGibbsOperator {
    private final SliceInterval sliceInterval;
    private final double width = 1.0;
    private final Variable<Double> variable;

    public SliceOperator(Variable<Double> variable) {
        this(new SliceInterval.SteppingOut(), variable);
    }

    public SliceOperator(SliceInterval sliceInterval, Variable<Double> variable) {
        this.sliceInterval = sliceInterval;
        if (variable.getSize() != 1) {
            throw new RuntimeException("Generic slice sampler is currently for univariate parameters only");
        }
        this.variable = variable;
        sliceInterval.setSliceSampler(this);
    }

    public Variable<Double> getVariable() {
        return this.variable;
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        double d = this.evaluate(likelihood, 1.0);
        double d2 = d + MathUtils.randomLogDouble();
        this.sliceInterval.drawFromInterval(likelihood, d2, 1.0);
        return 0.0;
    }

    @Override
    public int getStepCount() {
        return 1;
    }

    @Override
    public String getOperatorName() {
        return "genericSliceSampler";
    }

    public static void main(String[] stringArray) {
        Parameter.Default default_ = new Parameter.Default(1.0);
        Variable.D d = new Variable.D(1.0, 1);
        NormalDistributionModel normalDistributionModel = new NormalDistributionModel(default_, d);
        DistributionLikelihood distributionLikelihood = new DistributionLikelihood(normalDistributionModel);
        DistributionLikelihood distributionLikelihood2 = new DistributionLikelihood(new NormalDistribution(0.0, 1.0));
        distributionLikelihood2.addData(default_);
        distributionLikelihood.addData(new Attribute.Default<double[]>("Data", new double[]{0.0, 1.0, 2.0}));
        ArrayList<Likelihood> arrayList = new ArrayList<Likelihood>();
        arrayList.add(distributionLikelihood);
        arrayList.add(distributionLikelihood2);
        CompoundLikelihood compoundLikelihood = new CompoundLikelihood(0, arrayList);
        SliceOperator sliceOperator = new SliceOperator(default_);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 10000; ++i) {
            sliceOperator.doOperation(compoundLikelihood);
            double d4 = (Double)default_.getValue(0);
            d2 += d4;
            d3 += d4 * d4;
        }
        d3 /= 10000.0;
        System.out.println("E(x) = " + d2);
        System.out.println("V(x) = " + (d3 -= (d2 /= 10000.0) * d2));
    }
}

