/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import CADStat.java.plots.SubsetFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class QuantileRegression
extends DataPlotDialog {
    private JPanel analysisOptionsPane;
    private JCheckBox confIntervals;
    private JLabel confLabel;
    private JSpinner confLevel;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JPanel leftPane;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    private JCheckBox plotCoeffConfBands;
    private JPanel plotOptionsPane;
    private JPanel plotPane;
    private JPanel quantilePane;
    private JScrollPane quantileScrollPane;
    private JTable quantileTable;
    private JCheckBox regScatterPlot;
    private JPanel rightPane;
    private JPanel varPane;

    @Override
    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuantileRegression.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.quantileTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                QuantileRegression.this.quantileTableTableChanged(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void quantileTableTableChanged(TableModelEvent e) {
        TableModel model;
        int row = e.getFirstRow();
        int col = e.getColumn();
        if (row == 0 && col == 0 && (model = (TableModel)e.getSource()).getValueAt(row, col) == null) {
            model.setValueAt(new Double(0.5), row, col);
        }
        this.refreshValidity();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
        } else {
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            try {
                nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
                this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
                if (nonFactors != null) {
                    this.independentList.setListData(nonFactors);
                } else {
                    this.independentList.removeAll();
                }
                if (this.dependentComboBox.getItemCount() > 0) {
                    this.dependentComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(QuantileRegression.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(QuantileRegression.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
        }
        this.refreshValidity();
    }

    public void refreshConfLevelValidity() {
        this.confLabel.setEnabled(this.confIntervals.isSelected());
        this.confLevel.setEnabled(this.confIntervals.isSelected());
    }

    public void refreshScatterPlotValidity() {
        this.regScatterPlot.setEnabled(!this.independentList.isSelectionEmpty() && this.independentList.getSelectedIndices().length == 1);
    }

    public void refreshConfBandValidity() {
        TableModel model = this.quantileTable.getModel();
        int numValues = 0;
        int n = model.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (model.getValueAt(i, 0) == null) continue;
            ++numValues;
        }
        boolean enableConfBands = numValues >= 1 && !this.independentList.isSelectionEmpty() && this.independentList.getSelectedIndices().length == 1;
        this.plotCoeffConfBands.setEnabled(enableConfBands);
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(!this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshConfLevelValidity();
        this.refreshConfBandValidity();
        this.refreshScatterPlotValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.leftPane = new JPanel();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.analysisOptionsPane = new JPanel();
        this.confIntervals = new JCheckBox();
        this.confLabel = new JLabel();
        this.confLevel = new JSpinner();
        this.rightPane = new JPanel();
        this.quantilePane = new JPanel();
        this.quantileScrollPane = new JScrollPane();
        this.quantileTable = new JTable();
        this.plotOptionsPane = new JPanel();
        this.regScatterPlot = new JCheckBox();
        this.plotCoeffConfBands = new JCheckBox();
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout(this.modelEqPane);
        this.modelEqPane.setLayout(modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -1, 638, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup(modelEqPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modelEqPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.modelEqScrollPane, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuantileRegression.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                QuantileRegression.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.independentLabel).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentScrollPane, -1, 184, Short.MAX_VALUE).addComponent(this.dependentComboBox, GroupLayout.Alignment.TRAILING, 0, 184, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dependentComboBox, -2, -1, -2).addComponent(this.dependentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.independentLabel).addComponent(this.independentScrollPane, -1, 190, Short.MAX_VALUE)).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.confIntervals.setText("Compute Confidence Intervals");
        this.confIntervals.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                QuantileRegression.this.confIntervalsStateChanged(evt);
            }
        });
        this.confLabel.setText("Confidence Level:");
        this.confLevel.setModel(new SpinnerNumberModel(0.95, 0.01, 0.99, 0.01));
        GroupLayout analysisOptionsPaneLayout = new GroupLayout(this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout(analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.confIntervals)).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addGap(61, 61, 61).addComponent(this.confLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confLevel, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.confIntervals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(analysisOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confLabel).addComponent(this.confLevel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.analysisOptionsPane, -2, -1, -2).addComponent(this.varPane, -1, -1, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftPaneLayout.createSequentialGroup().addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.analysisOptionsPane, -2, -1, -2)));
        this.quantilePane.setBorder(BorderFactory.createTitledBorder("Quantiles"));
        this.quantileScrollPane.setPreferredSize(new Dimension(200, 120));
        this.quantileTable.setModel(new DefaultTableModel(new Object[][]{{new Double(0.5)}, {null}, {null}, {null}, {null}, {null}, {null}, {null}}, new String[]{"Quantiles"}){
            Class[] types;
            {
                this.types = new Class[]{Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.quantileTable.setCellSelectionEnabled(true);
        this.quantileScrollPane.setViewportView(this.quantileTable);
        GroupLayout quantilePaneLayout = new GroupLayout(this.quantilePane);
        this.quantilePane.setLayout(quantilePaneLayout);
        quantilePaneLayout.setHorizontalGroup(quantilePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantilePaneLayout.createSequentialGroup().addContainerGap().addComponent(this.quantileScrollPane, -1, 282, Short.MAX_VALUE).addContainerGap()));
        quantilePaneLayout.setVerticalGroup(quantilePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(quantilePaneLayout.createSequentialGroup().addContainerGap().addComponent(this.quantileScrollPane, -1, 234, Short.MAX_VALUE).addContainerGap()));
        this.plotOptionsPane.setBorder(BorderFactory.createTitledBorder("Plot Options"));
        this.regScatterPlot.setText("Regression Scatterplot");
        this.plotCoeffConfBands.setText("Coefficient Confidence Bands");
        GroupLayout plotOptionsPaneLayout = new GroupLayout(this.plotOptionsPane);
        this.plotOptionsPane.setLayout(plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.regScatterPlot).addComponent(this.plotCoeffConfBands)).addContainerGap(-1, Short.MAX_VALUE)));
        plotOptionsPaneLayout.setVerticalGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptionsPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.regScatterPlot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotCoeffConfBands).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout rightPaneLayout = new GroupLayout(this.rightPane);
        this.rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotOptionsPane, -2, -1, -2).addComponent(this.quantilePane, -1, -1, Short.MAX_VALUE));
        rightPaneLayout.setVerticalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightPaneLayout.createSequentialGroup().addComponent(this.quantilePane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotOptionsPane, -2, -1, -2)));
        GroupLayout plotPaneLayout = new GroupLayout(this.plotPane);
        this.plotPane.setLayout(plotPaneLayout);
        plotPaneLayout.setHorizontalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.modelEqPane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, plotPaneLayout.createSequentialGroup().addComponent(this.leftPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPane, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPaneLayout.createSequentialGroup().addComponent(this.modelEqPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.leftPane, -1, -1, Short.MAX_VALUE).addComponent(this.rightPane, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.setTitle("Quantile Regression");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 716) / 2, (screenSize.height - 730) / 2, 716, 730);
    }

    private void confIntervalsStateChanged(ChangeEvent evt) {
        this.refreshValidity();
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshValidity();
    }

    private List getColumn(JTable table, int column) {
        if (table != null && column <= table.getColumnCount()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                list.add(table.getValueAt(i, column));
            }
            return list;
        }
        return null;
    }

    @Override
    protected void submitButtonAction() {
        String cmd = "rq.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane1().getSelectedFactorValues())) + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.getFactorSelectionPane2().getSelectedFactorValues())) + ", my.formula='" + this.modelEqTextArea.getText() + "', my.tau=c(" + RUtils.toString(this.getColumn(this.quantileTable, 0), ",", "'") + "), iCI=" + String.valueOf(this.confIntervals.isSelected()).toUpperCase() + (this.confIntervals.isSelected() ? ", conf.level=" + (Double)this.confLevel.getValue() : "") + (this.regScatterPlot.isEnabled() ? ", iScatterplot=" + String.valueOf(this.regScatterPlot.isSelected()).toUpperCase() : "") + ", iCIplot=" + String.valueOf(this.plotCoeffConfBands.isSelected()).toUpperCase() + ", dep.var='" + GUIUtils.getSelectedItem(this.dependentComboBox) + "', indep.var=c(" + RUtils.toString(this.independentList.getSelectedValues(), ",", "'") + "))";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    protected void helpButtonAction() {
        String cmd = "CADStat.help('rq.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object dep = this.dependentComboBox.getSelectedItem();
        int[] indepIndices = this.independentList.getSelectedIndices();
        this.getDatasetPane().refreshDatasetComboBox();
        this.refreshFactorSelectionPanes();
        this.dependentComboBox.setSelectedItem(dep);
        this.independentList.setSelectedIndices(indepIndices);
        this.updateModelEquation();
        this.refreshValidity();
    }
}

