/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import edu.cens.text.AbstractTermFrequencyViewer;
import edu.cens.text.TermFrequencyDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.rosuda.deducer.Deducer;

public class WordCloudViewer
extends AbstractTermFrequencyViewer {
    double WC_rotatePercentage;
    double WC_minFontSize;
    double WC_maxFontSize;
    String WC_colors;

    public WordCloudViewer(TermFrequencyDialog termFrequencyDialog) {
        super(termFrequencyDialog);
    }

    public JPanel getOptionsPanel() {
        Double[] doubleArray = new Double[]{0.25, 1.0, 2.0, 4.0, 8.0};
        final JComboBox<Double> jComboBox = new JComboBox<Double>(doubleArray);
        final JComboBox<Double> jComboBox2 = new JComboBox<Double>(doubleArray);
        InputVerifier inputVerifier = new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                JTextComponent jTextComponent = (JTextComponent)jComponent;
                String string = jTextComponent.getText();
                try {
                    Double d = Double.parseDouble(string);
                    return d >= 0.0;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        };
        ((JTextField)jComboBox.getEditor().getEditorComponent()).setInputVerifier(inputVerifier);
        ((JTextField)jComboBox2.getEditor().getEditorComponent()).setInputVerifier(inputVerifier);
        jComboBox.setEditable(true);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordCloudViewer.this.WC_minFontSize = (Double)jComboBox.getSelectedItem();
                jComboBox2.setSelectedItem(Math.max(WordCloudViewer.this.WC_minFontSize, WordCloudViewer.this.WC_maxFontSize));
            }
        });
        jComboBox2.setEditable(true);
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WordCloudViewer.this.WC_maxFontSize = (Double)jComboBox2.getSelectedItem();
                jComboBox.setSelectedItem(Math.min(WordCloudViewer.this.WC_minFontSize, WordCloudViewer.this.WC_maxFontSize));
            }
        });
        jComboBox.setSelectedItem(0.25);
        jComboBox2.setSelectedItem(4.0);
        String[] stringArray = new String[]{"Black", "Black/White", "Spectral", "Dark2", "Purple/Green", "Red/Cyan", "Blue/Gold"};
        final JComboBox<String> jComboBox3 = new JComboBox<String>(stringArray);
        jComboBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)jComboBox3.getSelectedItem();
                WordCloudViewer.this.WC_colors = "'black'";
                if (string.equals("Black")) {
                    WordCloudViewer.this.WC_colors = "'black'";
                } else if (string.equals("Black/White")) {
                    WordCloudViewer.this.WC_colors = "make.color.scale(c(.95,.95,.95),c(0,0,0),256,.4)";
                } else if (string.equals("Spectral")) {
                    WordCloudViewer.this.WC_colors = "brewer.pal(11,'Spectral')";
                } else if (string.equals("Dark2")) {
                    WordCloudViewer.this.WC_colors = "brewer.pal(8,'Dark2')";
                } else if (string.equals("Purple/Green")) {
                    WordCloudViewer.this.WC_colors = "brewer.pal(11,'PRGn')";
                } else if (string.equals("Red/Cyan")) {
                    WordCloudViewer.this.WC_colors = "make.color.scale(c(0,1,1), c(1,0,0),256,.25)";
                } else if (string.equals("Blue/Gold")) {
                    WordCloudViewer.this.WC_colors = "make.color.scale(c(1,1,0), c(0,0,.85),256,.5)";
                } else {
                    throw new IllegalStateException("unrecognized color! '" + string + "' from combo box!");
                }
            }
        });
        jComboBox3.setSelectedIndex(0);
        JCheckBox jCheckBox = new JCheckBox("Randomly Rotate Terms");
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                WordCloudViewer.this.WC_rotatePercentage = itemEvent.getStateChange() == 1 ? 0.25 : 0.0;
            }
        });
        jCheckBox.setSelected(true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getTopLevelLayoutDefaults();
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("Min Font Size:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(jComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("Max Font Size:"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add(jComboBox2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("Coloring:"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        jPanel.add(jComboBox3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        jComboBox.setPreferredSize(new Dimension(60, jComboBox.getPreferredSize().height));
        jComboBox2.setPreferredSize(new Dimension(60, jComboBox2.getPreferredSize().height));
        return jPanel;
    }

    public String toString() {
        return "Word Cloud";
    }

    public void executeView() {
        String string = "";
        String string2 = Deducer.getUniqueName((String)"tempFreq");
        string = string + string2 + "<-" + this.tfDialog.getTermFreqCall(this.getExtraTermFreqArgs());
        string = string + "\nwordcloud(names(" + string2 + "), " + string2 + ", min.freq=0 " + ", random.order=FALSE" + ", scale = c(" + this.WC_maxFontSize + ", " + this.WC_minFontSize + ")" + ", colors=" + this.WC_colors + ", rot.per=" + this.WC_rotatePercentage + ")";
        string = string + "\nrm(" + string2 + ")";
        Deducer.execute((String)string);
        Deducer.execute((String)"dev.set()", (boolean)false);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(new WordCloudViewer(null).getOptionsPanel());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

