/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;

public class JVM {
    private ReflectionProvider reflectionProvider;
    private transient Map loaderCache = new HashMap();
    private final boolean supportsAWT = this.loadClass("java.awt.Color") != null;
    private final boolean supportsSwing = this.loadClass("javax.swing.LookAndFeel") != null;
    private final boolean supportsSQL = this.loadClass("java.sql.Date") != null;
    private static final String vendor = System.getProperty("java.vm.vendor");
    private static final float majorJavaVersion = JVM.getMajorJavaVersion();
    private static final boolean reverseFieldOrder = JVM.isHarmony() || JVM.isIBM() && !JVM.is15();
    static final float DEFAULT_JAVA_VERSION = 1.3f;
    static /* synthetic */ Class class$java$text$AttributedString;
    static /* synthetic */ Class class$com$thoughtworks$xstream$core$JVM;

    private static final float getMajorJavaVersion() {
        try {
            return Float.parseFloat(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException e) {
            return 1.3f;
        }
    }

    public static boolean is14() {
        return majorJavaVersion >= 1.4f;
    }

    public static boolean is15() {
        return majorJavaVersion >= 1.5f;
    }

    public static boolean is16() {
        return majorJavaVersion >= 1.6f;
    }

    private static boolean isSun() {
        return vendor.indexOf("Sun") != -1;
    }

    private static boolean isApple() {
        return vendor.indexOf("Apple") != -1;
    }

    private static boolean isHPUX() {
        return vendor.indexOf("Hewlett-Packard Company") != -1;
    }

    private static boolean isIBM() {
        return vendor.indexOf("IBM") != -1;
    }

    private static boolean isBlackdown() {
        return vendor.indexOf("Blackdown") != -1;
    }

    private static boolean isHarmony() {
        return vendor.indexOf("Apache Software Foundation") != -1;
    }

    private static boolean isBEAWithUnsafeSupport() {
        if (vendor.indexOf("BEA") != -1) {
            String vmVersion = System.getProperty("java.vm.version");
            if (vmVersion.startsWith("R")) {
                return true;
            }
            String vmInfo = System.getProperty("java.vm.info");
            if (vmInfo != null) {
                return vmInfo.startsWith("R25.1") || vmInfo.startsWith("R25.2");
            }
        }
        return false;
    }

    private static boolean isHitachi() {
        return vendor.indexOf("Hitachi") != -1;
    }

    private static boolean isSAP() {
        return vendor.indexOf("SAP AG") != -1;
    }

    public Class loadClass(String name) {
        try {
            Class cached;
            WeakReference reference = (WeakReference)this.loaderCache.get(name);
            if (reference != null && (cached = (Class)reference.get()) != null) {
                return cached;
            }
            Class<?> clazz = Class.forName(name, false, this.getClass().getClassLoader());
            this.loaderCache.put(name, new WeakReference(clazz));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public synchronized ReflectionProvider bestReflectionProvider() {
        if (this.reflectionProvider == null) {
            try {
                if (this.canUseSun14ReflectionProvider()) {
                    String cls = "com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider";
                    this.reflectionProvider = (ReflectionProvider)this.loadClass(cls).newInstance();
                } else if (this.canUseHarmonyReflectionProvider()) {
                    String cls = "com.thoughtworks.xstream.converters.reflection.HarmonyReflectionProvider";
                    this.reflectionProvider = (ReflectionProvider)this.loadClass(cls).newInstance();
                }
                if (this.reflectionProvider == null) {
                    this.reflectionProvider = new PureJavaReflectionProvider();
                }
            }
            catch (InstantiationException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (IllegalAccessException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
            catch (AccessControlException e) {
                this.reflectionProvider = new PureJavaReflectionProvider();
            }
        }
        return this.reflectionProvider;
    }

    private boolean canUseSun14ReflectionProvider() {
        return (JVM.isSun() || JVM.isApple() || JVM.isHPUX() || JVM.isIBM() || JVM.isBlackdown() || JVM.isBEAWithUnsafeSupport() || JVM.isHitachi() || JVM.isSAP()) && JVM.is14() && this.loadClass("sun.misc.Unsafe") != null;
    }

    private boolean canUseHarmonyReflectionProvider() {
        return JVM.isHarmony();
    }

    public static boolean reverseFieldDefinition() {
        return reverseFieldOrder;
    }

    public boolean supportsAWT() {
        return this.supportsAWT;
    }

    public boolean supportsSwing() {
        return this.supportsSwing;
    }

    public boolean supportsSQL() {
        return this.supportsSQL;
    }

    private Object readResolve() {
        this.loaderCache = new HashMap();
        return this;
    }

    public static void main(String[] args) {
        int i;
        boolean reverse = false;
        Field[] fields = (class$java$text$AttributedString == null ? (class$java$text$AttributedString = JVM.class$("java.text.AttributedString")) : class$java$text$AttributedString).getDeclaredFields();
        for (i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals("text")) continue;
            reverse = i > 3;
            break;
        }
        if (reverse) {
            fields = (class$com$thoughtworks$xstream$core$JVM == null ? (class$com$thoughtworks$xstream$core$JVM = JVM.class$("com.thoughtworks.xstream.core.JVM")) : class$com$thoughtworks$xstream$core$JVM).getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals("reflectionProvider")) continue;
                reverse = i > 2;
                break;
            }
        }
        JVM jvm = new JVM();
        System.out.println("XStream JVM diagnostics");
        System.out.println("java.specification.version: " + System.getProperty("java.specification.version"));
        System.out.println("java.vm.vendor: " + vendor);
        System.out.println("Version: " + majorJavaVersion);
        System.out.println("XStream support for enhanced Mode: " + (jvm.canUseSun14ReflectionProvider() || jvm.canUseHarmonyReflectionProvider()));
        System.out.println("Supports AWT: " + jvm.supportsAWT());
        System.out.println("Supports SQL: " + jvm.supportsSQL());
        System.out.println("Reverse field order detected (may have failed): " + reverse);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

