/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.stefano;

import java.util.Comparator;
import net.sourceforge.jclec.syntaxtree.IRecombineSyntaxTree;
import net.sourceforge.jclec.syntaxtree.NonTerminalNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeNode;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.lang.builder.EqualsBuilder;

public class StefanoCrossover
implements IRecombineSyntaxTree {
    private static final long serialVersionUID = -6447244450691681809L;
    protected Comparator<SyntaxTreeNode> symbolsComparator = new Comparator<SyntaxTreeNode>(){

        @Override
        public int compare(SyntaxTreeNode o1, SyntaxTreeNode o2) {
            if (o1 instanceof NonTerminalNode && o2 instanceof NonTerminalNode) {
                NonTerminalNode co1 = (NonTerminalNode)o1;
                NonTerminalNode co2 = (NonTerminalNode)o2;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append(co1.getSymbol(), co2.getSymbol());
                if (eb.isEquals()) {
                    return 0;
                }
                return StefanoCrossover.this.areCompatible(co1.getSymbol(), co2.getSymbol());
            }
            return -1;
        }
    };

    @Override
    public void recombine(SyntaxTree parentTree0, SyntaxTree parentTree1, SyntaxTree sonTree0, SyntaxTree sonTree1, SyntaxTreeSchema schema, IRandGen randgen) {
        SyntaxTreeNode node;
        boolean cond1;
        int p0_branchStart = this.selectSymbol(parentTree0, schema, randgen);
        if (p0_branchStart == -1) {
            int i = 0;
            while (i < parentTree0.size()) {
                sonTree0.addNode(parentTree0.getNode(i).copy());
                ++i;
            }
            i = 0;
            while (i < parentTree1.size()) {
                sonTree1.addNode(parentTree1.getNode(i).copy());
                ++i;
            }
            return;
        }
        NonTerminalNode selectedSymbol = (NonTerminalNode)parentTree0.getNode(p0_branchStart);
        int p1_branchStart = this.searchSymbolIn(selectedSymbol, parentTree1, randgen);
        if (p1_branchStart == -1) {
            int i = 0;
            while (i < parentTree0.size()) {
                sonTree0.addNode(parentTree0.getNode(i).copy());
                ++i;
            }
            i = 0;
            while (i < parentTree1.size()) {
                sonTree1.addNode(parentTree1.getNode(i).copy());
                ++i;
            }
            return;
        }
        int p0_branchEnd = this.endOfBranch(parentTree0, p0_branchStart);
        int p1_branchEnd = this.endOfBranch(parentTree1, p1_branchStart);
        int p1_branchDepth = parentTree1.derivSize();
        int p1_swapBranch = 0;
        int i = p1_branchStart;
        while (i <= p1_branchEnd) {
            if (parentTree1.getNode(i).arity() != 0) {
                ++p1_swapBranch;
            }
            ++i;
        }
        int p0_branchDepth = parentTree0.derivSize();
        int p0_swapBranch = 0;
        int i2 = p0_branchStart;
        while (i2 <= p0_branchEnd) {
            if (parentTree0.getNode(i2).arity() != 0) {
                ++p0_swapBranch;
            }
            ++i2;
        }
        boolean cond0 = p0_branchDepth - p0_swapBranch + p1_swapBranch > schema.getMaxDerivSize();
        boolean bl = cond1 = p1_branchDepth - p1_swapBranch + p0_swapBranch > schema.getMaxDerivSize();
        if (cond0 && cond1) {
            int i3 = 0;
            while (i3 < parentTree0.size()) {
                sonTree0.addNode(parentTree0.getNode(i3).copy());
                ++i3;
            }
            i3 = 0;
            while (i3 < parentTree1.size()) {
                sonTree1.addNode(parentTree1.getNode(i3).copy());
                ++i3;
            }
            return;
        }
        if (cond0) {
            int i4 = 0;
            while (i4 < parentTree0.size()) {
                sonTree0.addNode(parentTree0.getNode(i4).copy());
                ++i4;
            }
            i4 = 0;
            while (i4 < p1_branchStart) {
                sonTree1.addNode(parentTree1.getNode(i4).copy());
                ++i4;
            }
            i4 = p0_branchStart;
            while (i4 <= p0_branchEnd) {
                SyntaxTreeNode node2 = parentTree0.getNode(i4).copy();
                sonTree1.addNode(node2);
                ++i4;
            }
            int p1_length = parentTree1.size();
            int i5 = p1_branchEnd + 1;
            while (i5 < p1_length) {
                sonTree1.addNode(parentTree1.getNode(i5).copy());
                ++i5;
            }
            return;
        }
        if (cond1) {
            int i6 = 0;
            while (i6 < parentTree1.size()) {
                sonTree1.addNode(parentTree1.getNode(i6).copy());
                ++i6;
            }
            i6 = 0;
            while (i6 < p0_branchStart) {
                sonTree0.addNode(parentTree0.getNode(i6).copy());
                ++i6;
            }
            i6 = p1_branchStart;
            while (i6 <= p1_branchEnd) {
                SyntaxTreeNode node3 = parentTree1.getNode(i6).copy();
                sonTree0.addNode(node3);
                ++i6;
            }
            int p0_length = parentTree0.size();
            int i7 = p0_branchEnd + 1;
            while (i7 < p0_length) {
                sonTree0.addNode(parentTree0.getNode(i7).copy());
                ++i7;
            }
            return;
        }
        int i8 = 0;
        while (i8 < p0_branchStart) {
            sonTree0.addNode(parentTree0.getNode(i8).copy());
            ++i8;
        }
        i8 = 0;
        while (i8 < p1_branchStart) {
            sonTree1.addNode(parentTree1.getNode(i8).copy());
            ++i8;
        }
        i8 = p0_branchStart;
        while (i8 <= p0_branchEnd) {
            node = parentTree0.getNode(i8).copy();
            sonTree1.addNode(node);
            ++i8;
        }
        i8 = p1_branchStart;
        while (i8 <= p1_branchEnd) {
            node = parentTree1.getNode(i8).copy();
            sonTree0.addNode(node);
            ++i8;
        }
        int p0_length = parentTree0.size();
        int i9 = p0_branchEnd + 1;
        while (i9 < p0_length) {
            sonTree0.addNode(parentTree0.getNode(i9).copy());
            ++i9;
        }
        int p1_length = parentTree1.size();
        int i10 = p1_branchEnd + 1;
        while (i10 < p1_length) {
            sonTree1.addNode(parentTree1.getNode(i10).copy());
            ++i10;
        }
    }

    private final int searchSymbolIn(NonTerminalNode symbol, SyntaxTree tree, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (this.symbolsComparator.compare(symbol, tree.getNode(actPos)) == 0) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }

    private final int selectSymbol(SyntaxTree tree, SyntaxTreeSchema schema, IRandGen randgen) {
        int startPos;
        int treeLength = tree.size();
        int actPos = startPos = randgen.choose(0, treeLength);
        int i = 0;
        while (i < treeLength) {
            actPos = (startPos + i) % treeLength;
            if (!schema.isTerminal(tree.getNode(actPos).getSymbol())) {
                return actPos;
            }
            ++i;
        }
        return -1;
    }

    private final int endOfBranch(SyntaxTree tree, int currentNode) {
        int cont = 1;
        while (cont != 0) {
            cont += tree.getNode(currentNode).arity() - 1;
            ++currentNode;
        }
        return currentNode - 1;
    }

    private int areCompatible(String o1, String o2) {
        if (o1.equalsIgnoreCase("=") || o1.equalsIgnoreCase("!=")) {
            if (o2.equalsIgnoreCase("!=") || o2.equalsIgnoreCase("=")) {
                return 1;
            }
            return -1;
        }
        if (o1.equalsIgnoreCase("IN") || o1.equalsIgnoreCase("OUT")) {
            if (o2.equalsIgnoreCase("OUT") || o2.equalsIgnoreCase("IN")) {
                return 1;
            }
            return -1;
        }
        if (o1.equalsIgnoreCase("<=") || o1.equalsIgnoreCase(">") || o1.equalsIgnoreCase("<") || o1.equalsIgnoreCase(">=")) {
            if (o2.equalsIgnoreCase("<=") || o2.equalsIgnoreCase(">") || o2.equalsIgnoreCase("<") || o2.equalsIgnoreCase(">=")) {
                return 1;
            }
            return -1;
        }
        return -1;
    }
}

