/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Iterator;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.ClassAwareObjectStore;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EqualityKeyComparator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.ObjectHashMap;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.runtime.beliefs.Mode;

public class TruthMaintenanceSystem {
    private NamedEntryPoint ep;
    private ObjectTypeConfigurationRegistry typeConfReg;
    private ObjectHashMap equalityKeyMap;
    private BeliefSystem defaultBeliefSystem;
    private RuleBaseConfiguration.AssertBehaviour assertBehaviour;

    public TruthMaintenanceSystem() {
    }

    public TruthMaintenanceSystem(StatefulKnowledgeSessionImpl wm, NamedEntryPoint ep) {
        this.ep = ep;
        this.assertBehaviour = ep.getKnowledgeBase().getConfiguration().getAssertBehaviour();
        this.typeConfReg = ep.getObjectTypeConfigurationRegistry();
        this.equalityKeyMap = new ObjectHashMap();
        this.equalityKeyMap.setComparator(EqualityKeyComparator.getInstance());
        this.defaultBeliefSystem = wm.getKnowledgeBase().getConfiguration().getComponentFactory().getBeliefSystemFactory().createBeliefSystem(wm.getSessionConfiguration().getBeliefSystemType(), ep, this);
    }

    public ObjectHashMap getEqualityKeyMap() {
        return this.equalityKeyMap;
    }

    public Object put(EqualityKey key) {
        return this.equalityKeyMap.put(key, key, false);
    }

    public InternalFactHandle insert(Object object, Object tmsValue, RuleImpl rule, Activation activation) {
        ObjectTypeConf typeConf = this.typeConfReg.getObjectTypeConf(this.ep.getEntryPoint(), object);
        if (!typeConf.isTMSEnabled()) {
            this.enableTMS(object, typeConf);
        }
        EqualityKey key = this.get(object);
        InternalFactHandle fh = null;
        if (key == null) {
            fh = this.ep.getHandleFactory().newFactHandle(object, typeConf, this.ep.getInternalWorkingMemory(), this.ep);
            key = new EqualityKey(fh, 2);
            fh.setEqualityKey(key);
            this.put(key);
        } else {
            fh = key.getLogicalFactHandle();
            if (fh == null) {
                fh = this.ep.getHandleFactory().newFactHandle(object, typeConf, this.ep.getInternalWorkingMemory(), this.ep);
                key.setLogicalFactHandle(fh);
                fh.setEqualityKey(key);
            }
        }
        fh = this.addLogicalDependency(fh, object, tmsValue, activation, activation.getPropagationContext(), rule, typeConf);
        return fh;
    }

    public void delete(FactHandle fh) {
        if (fh == null) {
            return;
        }
        InternalFactHandle ifh = (InternalFactHandle)fh;
        EqualityKey key = ifh.getEqualityKey();
        if (key.getLogicalFactHandle() != fh) {
            throw new IllegalArgumentException("The FactHandle did not originate from TMS : " + fh);
        }
        InternalWorkingMemory wm = this.ep.getInternalWorkingMemory();
        PropagationContext propagationContext = this.ep.getPctxFactory().createPropagationContext(wm.getNextPropagationIdCounter(), 1, null, null, ifh, this.ep.entryPoint);
        TruthMaintenanceSystemHelper.removeLogicalDependencies(ifh, propagationContext);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.get(key);
    }

    public EqualityKey get(Object object) {
        InternalFactHandle fh;
        EqualityKey key = (EqualityKey)this.equalityKeyMap.get(object);
        if (key == null && this.assertBehaviour == RuleBaseConfiguration.AssertBehaviour.EQUALITY && (fh = this.ep.getObjectStore().getHandleForObject(object)) != null && (key = fh.getEqualityKey()) == null) {
            ObjectTypeConf typeC = this.typeConfReg.getObjectTypeConf(this.ep.getEntryPoint(), fh.getObject());
            this.enableTMS(fh.getObject(), typeC);
            key = fh.getEqualityKey();
        }
        return key;
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.remove(key);
    }

    public void readLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf) {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, true);
    }

    public InternalFactHandle addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf) {
        return this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, false);
    }

    public InternalFactHandle addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, RuleImpl rule, ObjectTypeConf typeConf, boolean read) {
        BeliefSet beliefSet;
        BeliefSystem beliefSystem = this.defaultBeliefSystem;
        if (value != null && value instanceof Mode & !(value instanceof SimpleMode)) {
            Mode mode = (Mode)value;
            beliefSystem = (BeliefSystem)mode.getBeliefSystem();
        }
        if ((beliefSet = handle.getEqualityKey().getBeliefSet()) == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            beliefSet = beliefSystem.newBeliefSet(handle);
            handle.getEqualityKey().setBeliefSet(beliefSet);
        }
        LogicalDependency node = beliefSystem.newLogicalDependency(activation, beliefSet, object, value);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        if (read) {
            beliefSystem.read(node, beliefSet, context, typeConf);
        } else {
            beliefSet = beliefSystem.insert(node, beliefSet, context, typeConf);
        }
        return beliefSet.getFactHandle();
    }

    public void clear() {
        this.equalityKeyMap.clear();
    }

    public BeliefSystem getBeliefSystem() {
        return this.defaultBeliefSystem;
    }

    private void enableTMS(Object object, ObjectTypeConf conf) {
        Iterator<InternalFactHandle> it = ((ClassAwareObjectStore)this.ep.getObjectStore()).iterateFactHandles(ClassAwareObjectStore.getActualClass(object));
        while (it.hasNext()) {
            InternalFactHandle handle = it.next();
            if (handle == null || handle.getEqualityKey() != null) continue;
            EqualityKey key = new EqualityKey(handle);
            handle.setEqualityKey(key);
            key.setStatus(1);
            this.put(key);
        }
        conf.enableTMS();
    }
}

