/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.util.IteratorCollection;
import java.util.Iterator;
import java.util.List;

public class WrappedBulkUpdateHandler
implements BulkUpdateHandler {
    protected BulkUpdateHandler base;
    protected GraphEventManager manager;
    protected GraphWithPerform graph;

    public WrappedBulkUpdateHandler(GraphWithPerform graph, BulkUpdateHandler base) {
        this.graph = graph;
        this.base = base;
        this.manager = graph.getEventManager();
    }

    @Override
    @Deprecated
    public void add(Triple[] triples) {
        this.base.add(triples);
        this.manager.notifyAddArray(this.graph, triples);
    }

    @Override
    @Deprecated
    public void add(List<Triple> triples) {
        this.base.add(triples);
        this.manager.notifyAddList(this.graph, triples);
    }

    @Override
    @Deprecated
    public void add(Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        this.base.add(s);
        this.manager.notifyAddIterator((Graph)this.graph, s);
    }

    @Override
    @Deprecated
    public void add(Graph g, boolean withReifications) {
        this.base.add(g, withReifications);
        this.manager.notifyAddGraph(this.graph, g);
    }

    @Override
    public void add(Graph g) {
        this.base.add(g);
        this.manager.notifyAddGraph(this.graph, g);
    }

    @Override
    @Deprecated
    public void delete(Triple[] triples) {
        this.base.delete(triples);
        this.manager.notifyDeleteArray(this.graph, triples);
    }

    @Override
    @Deprecated
    public void delete(List<Triple> triples) {
        this.base.delete(triples);
        this.manager.notifyDeleteList(this.graph, triples);
    }

    @Override
    @Deprecated
    public void delete(Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        this.base.delete(s);
        this.manager.notifyDeleteIterator((Graph)this.graph, s);
    }

    @Override
    public void delete(Graph g) {
        this.base.delete(g);
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    @Override
    @Deprecated
    public void delete(Graph g, boolean withReifications) {
        this.base.delete(g, withReifications);
        this.manager.notifyDeleteGraph(this.graph, g);
    }

    @Override
    public void removeAll() {
        this.base.removeAll();
        this.manager.notifyEvent(this.graph, GraphEvents.removeAll);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        this.base.remove(s, p, o);
        this.manager.notifyEvent(this.graph, GraphEvents.remove(s, p, o));
    }
}

