/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.aromaticity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.ringsearch.RingSearch;

final class AtomTypeModel
extends ElectronDonation {
    private static final Map<String, Integer> TYPES = ImmutableMap.builder().put("N.planar3", 2).put("N.minus.planar3", 2).put("N.amide", 2).put("S.2", 2).put("S.planar3", 2).put("C.minus.planar", 2).put("O.planar3", 2).put("N.sp2.3", 1).put("C.sp2", 1).build();
    private final boolean exocyclic;

    AtomTypeModel(boolean exocyclic) {
        this.exocyclic = exocyclic;
    }

    @Override
    int[] contribution(IAtomContainer container, RingSearch ringSearch) {
        int nAtoms = container.getAtomCount();
        int[] electrons = new int[nAtoms];
        Arrays.fill(electrons, -1);
        HashMap<IAtom, Integer> indexMap = Maps.newHashMapWithExpectedSize(nAtoms);
        block4: for (int i = 0; i < nAtoms; ++i) {
            IAtom atom = container.getAtom(i);
            indexMap.put(atom, i);
            if (!ringSearch.cyclic(i)) continue;
            IAtomType.Hybridization hyb = atom.getHybridization();
            Preconditions.checkNotNull(atom.getAtomTypeName(), "atom has unset atom type");
            if (hyb == null) continue;
            switch (hyb) {
                case SP2: 
                case PLANAR3: {
                    electrons[i] = AtomTypeModel.electronsForAtomType(atom);
                    continue block4;
                }
                case SP3: {
                    electrons[i] = AtomTypeModel.lonePairCount(atom) > 0 ? 2 : -1;
                }
            }
        }
        if (this.exocyclic) {
            return electrons;
        }
        for (IBond bond : container.bonds()) {
            int v;
            if (bond.getOrder() != IBond.Order.DOUBLE && bond.getOrder() != IBond.Order.TRIPLE) continue;
            IAtom a1 = bond.getBegin();
            IAtom a2 = bond.getEnd();
            String a1Type = a1.getAtomTypeName();
            String a2Type = a2.getAtomTypeName();
            int u = (Integer)indexMap.get(a1);
            if (ringSearch.cyclic(u, v = ((Integer)indexMap.get(a2)).intValue()) || a1Type.equals("N.sp2.3") && a2Type.equals("O.sp2") || a1Type.equals("O.sp2") && a2Type.equals("N.sp2.3")) continue;
            electrons[v] = -1;
            electrons[u] = -1;
        }
        return electrons;
    }

    private static int electronsForAtomType(IAtom atom) {
        Integer electrons = TYPES.get(atom.getAtomTypeName());
        if (electrons != null) {
            return electrons;
        }
        try {
            IAtomType atomType = AtomTypeFactory.getInstance("org/openscience/cdk/dict/data/cdk-atom-types.owl", atom.getBuilder()).getAtomType(atom.getAtomTypeName());
            electrons = (Integer)atomType.getProperty("cdk:Pi Bond Count");
            return electrons != null ? electrons : 0;
        }
        catch (NoSuchAtomTypeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static int lonePairCount(IAtom atom) {
        Integer count = (Integer)atom.getProperty("cdk:Lone Pair Count");
        return count != null ? count : -1;
    }
}

