/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils;

public class ProgressBar {
    private int max;
    private int current;
    private int barSize = 70;
    private long start;
    private long lastUpdate;
    private long lastValue;
    private boolean showPercent = true;
    private boolean showTime = true;
    private boolean showETA = true;

    /*
     * WARNING - void declaration
     */
    public ProgressBar(int max, boolean showPercent, boolean showTime, boolean showETA) {
        void var1_1;
        void var2_3 = var1_1;
        ProgressBar progressBar = this;
        this.start = System.currentTimeMillis();
        progressBar.max = var2_3;
        progressBar.printBar(false);
    }

    /*
     * WARNING - void declaration
     */
    public final void setVal(int val) {
        if (val <= this.max) {
            void var2_2;
            this.current = val;
            int delta = Math.round(100.0f * (float)val / (float)this.max) - Math.round(100.0f * (float)this.lastValue / (float)this.max);
            if (System.currentTimeMillis() - this.lastUpdate > 1000L || var2_2 >= 10) {
                void var1_1;
                this.lastUpdate = System.currentTimeMillis();
                this.lastValue = (long)var1_1;
                this.printBar(false);
            }
        }
    }

    public final void finish() {
        this.current = this.max;
        this.printBar(true);
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder createBar() {
        void var1_1;
        void var2_2;
        StringBuilder strbar = new StringBuilder("[");
        double numbar = Math.floor((float)this.barSize * (float)this.current / (float)this.max);
        int ii = 0;
        while ((double)ii < numbar) {
            if ((double)ii == numbar - 1.0) {
                strbar.append(">");
            } else {
                strbar.append("=");
            }
            ++ii;
        }
        ii = (int)var2_2;
        while (ii < this.barSize) {
            strbar.append(" ");
            ++ii;
        }
        strbar.append("]");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void printBar(boolean finished) {
        void var1_1;
        void var2_2;
        StringBuilder strbar = this.createBar();
        long elapsed = System.currentTimeMillis() - this.start;
        int seconds = (int)(elapsed / 1000L) % 60;
        int minutes = (int)(elapsed / 1000L) / 60;
        String strTime = "";
        if (this.showTime) {
            strTime = " Time: " + String.format("%02d", minutes) + ":" + String.format("%02d", seconds);
        }
        String strPercentage = "";
        if (this.showPercent) {
            strPercentage = " " + Math.round(100.0f * (float)this.current / (float)this.max) + "%";
        }
        String strETA = "";
        if (this.showETA) {
            if (elapsed < 2000L) {
                strETA = "--:--";
            } else {
                void var3_4;
                long timeETA = elapsed * (long)((double)this.max / (double)this.current);
                int ETAseconds = (int)(timeETA / 1000L) % 60;
                int ETAminutes = (int)(timeETA / 1000L) / 60;
                strETA = String.valueOf(String.format("%02d", ETAminutes)) + ":" + String.format("%02d", (int)var3_4);
            }
            strETA = finished ? "               " : " ETA: " + strETA + "    ";
        }
        String strend = String.valueOf(strPercentage) + strTime + strETA;
        System.out.print(String.valueOf(var2_2.toString()) + " " + strend);
        if (var1_1 != false) {
            System.out.print("\n");
            return;
        }
        System.out.print("\r");
    }

    public static void main(String[] argv) {
        ProgressBar progressBar;
        ProgressBar bar = new ProgressBar(300, true, true, true);
        int i = 0;
        while (i < 300) {
            bar.setVal(i);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
            ++i;
        }
        progressBar.finish();
    }
}

