/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.trees.ASHoeffdingTree;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.MiscUtils;
import moa.core.Utils;
import moa.options.ClassOption;

public class OzaBagASHT
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models in the bag.", 10, 1, Integer.MAX_VALUE);
    public IntOption firstClassifierSizeOption = new IntOption("firstClassifierSize", 'f', "The size of first classifier in the bag.", 1, 1, Integer.MAX_VALUE);
    public FlagOption useWeightOption = new FlagOption("useWeight", 'u', "Enable weight classifiers.");
    public FlagOption resetTreesOption = new FlagOption("resetTrees", 'e', "Reset trees when size is higher than the max.");
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "ASHoeffdingTree to train.", ASHoeffdingTree.class, "moa.classifiers.trees.ASHoeffdingTree");
    protected ASHoeffdingTree[] ensemble;
    protected double[] error;
    protected double alpha = 0.01;

    @Override
    public String getPurposeString() {
        return "Bagging using trees of different size.";
    }

    @Override
    public void resetLearningImpl() {
        this.ensemble = new ASHoeffdingTree[this.ensembleSizeOption.getValue()];
        this.error = new double[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        int pow = this.firstClassifierSizeOption.getValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = (ASHoeffdingTree)baseLearner.copy();
            this.error[i] = 0.0;
            this.ensemble[i].setMaxSize(pow);
            if (this.resetTreesOption != null && this.resetTreesOption.isSet()) {
                this.ensemble[i].setResetTree();
            }
            pow *= 2;
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        int trueClass = (int)inst.classValue();
        for (int i = 0; i < this.ensemble.length; ++i) {
            int k = MiscUtils.poisson(1.0, this.classifierRandom);
            if (k <= 0) continue;
            Instance weightedInst = inst.copy();
            weightedInst.setWeight(inst.weight() * (double)k);
            if (Utils.maxIndex(this.ensemble[i].getVotesForInstance(inst)) == trueClass) {
                int n = i;
                this.error[n] = this.error[n] + this.alpha * (0.0 - this.error[i]);
            } else {
                int n = i;
                this.error[n] = this.error[n] + this.alpha * (1.0 - this.error[i]);
            }
            this.ensemble[i].trainOnInstance(weightedInst);
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        DoubleVector combinedVote = new DoubleVector();
        for (int i = 0; i < this.ensemble.length; ++i) {
            DoubleVector vote = new DoubleVector(this.ensemble[i].getVotesForInstance(inst));
            if (!(vote.sumOfValues() > 0.0)) continue;
            vote.normalize();
            if (this.useWeightOption != null && this.useWeightOption.isSet()) {
                vote.scaleValues(1.0 / (this.error[i] * this.error[i]));
            }
            combinedVote.addValues(vote);
        }
        return combinedVote.getArrayRef();
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("ensemble size", this.ensemble != null ? (double)this.ensemble.length : 0.0)};
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.ensemble.clone();
    }
}

