/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.CoalescentSimulator;
import dr.evolution.coalescent.PiecewiseLinearPopulation;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.util.Attributable;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PLCoalescentSimulator {
    private static PrintStream debug = System.err;

    public static void main(String[] stringArray) throws IOException {
        Attributable attributable;
        double d;
        double d2;
        int n;
        Object object;
        String string = stringArray[0];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        double d3 = 1.0;
        double d4 = 1.0;
        if (stringArray.length > 2) {
            d3 = Double.parseDouble(stringArray[2]);
        }
        if (stringArray.length > 3) {
            d4 = Double.parseDouble(stringArray[3]);
        }
        PrintWriter printWriter = null;
        if (stringArray.length > 5) {
            object = stringArray[5];
            printWriter = ((String)object).equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileWriter((String)object));
        }
        object = new ArrayList();
        String string2 = bufferedReader.readLine();
        String[] stringArray2 = string2.trim().split("[\t ]+");
        if (stringArray2.length < 2) {
            throw new RuntimeException();
        }
        ArrayList arrayList = new ArrayList();
        while (string2 != null) {
            double d5 = Double.parseDouble(stringArray2[0]) / d4;
            object.add(d5);
            for (n = 1; n < stringArray2.length; ++n) {
                arrayList.add(new ArrayList());
                ((ArrayList)arrayList.get(n - 1)).add(Double.parseDouble(stringArray2[n]));
            }
            string2 = bufferedReader.readLine();
            if (string2 == null || (stringArray2 = string2.trim().split("[\t ]+")).length == arrayList.size() + 1) continue;
            throw new RuntimeException();
        }
        bufferedReader.close();
        String string3 = stringArray[1];
        bufferedReader = new BufferedReader(new FileReader(string3));
        string2 = bufferedReader.readLine();
        Taxa taxa = new Taxa();
        n = 0;
        while (string2 != null) {
            if (!string2.startsWith("#")) {
                stringArray2 = string2.split("[\t ]+");
                if (stringArray2.length == 4) {
                    d2 = Double.parseDouble(stringArray2[0]);
                    d = Double.parseDouble(stringArray2[1]);
                    double d6 = Double.parseDouble(stringArray2[2]);
                    int n2 = Integer.parseInt(stringArray2[3]);
                    for (double d7 = d2; d7 <= d; d7 += d6) {
                        double d8 = d7 / d4;
                        for (int i = 0; i < n2; ++i) {
                            attributable = new Taxon("t" + n);
                            attributable.setAttribute("date", new Date(d8, Units.Type.GENERATIONS, true));
                            taxa.addTaxon((Taxon)attributable);
                            ++n;
                        }
                    }
                } else {
                    d2 = Double.parseDouble(stringArray2[0]) / d4;
                    int n3 = Integer.parseInt(stringArray2[1]);
                    for (int i = 0; i < n3; ++i) {
                        Taxon taxon = new Taxon(n + "");
                        taxon.setAttribute("date", new Date(d2, Units.Type.GENERATIONS, true));
                        taxa.addTaxon(taxon);
                        ++n;
                    }
                }
            }
            string2 = bufferedReader.readLine();
        }
        d2 = Double.MAX_VALUE;
        d = 0.0;
        PrintWriter printWriter2 = stringArray.length > 4 ? new PrintWriter(new FileWriter(stringArray[4])) : new PrintWriter(System.out);
        int n4 = 0;
        for (List list : arrayList) {
            double[] dArray = new double[list.size()];
            double[] dArray2 = new double[object.size() - 1];
            if (printWriter != null) {
                printWriter.println("# " + n4);
                ++n4;
            }
            for (int i = dArray2.length; i > 0; --i) {
                double d9;
                dArray2[dArray2.length - i] = (Double)object.get(i) - (Double)object.get(i - 1);
                dArray[dArray2.length - i] = d9 = (Double)list.get(i) * d3;
                if (d9 < d2) {
                    d2 = d9;
                }
                if (d9 > d) {
                    d = d9;
                }
                double d10 = (Double)object.get(dArray2.length) - (Double)object.get(i);
                if (printWriter == null) continue;
                printWriter.println(d10 + "\t" + d9);
            }
            if (debug != null) {
                debug.println("min theta = " + d2);
                debug.println("max theta = " + d);
            }
            PiecewiseLinearPopulation piecewiseLinearPopulation = new PiecewiseLinearPopulation(dArray2, dArray, Units.Type.GENERATIONS);
            CoalescentSimulator coalescentSimulator = new CoalescentSimulator();
            attributable = coalescentSimulator.simulateTree(taxa, piecewiseLinearPopulation);
            printWriter2.println(TreeUtils.newick((Tree)attributable));
            if (debug == null) continue;
            debug.println(TreeUtils.newick((Tree)attributable));
        }
        if (printWriter != null) {
            printWriter.flush();
            printWriter.close();
        }
        printWriter2.flush();
        printWriter2.close();
    }
}

